/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.dom;

import oracle.xdb.dom.XDBDOMException;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XDBNamedNodeMap
implements NamedNodeMap {
    private XDBDocument m_owner;
    private long m_mapcstate;

    XDBNamedNodeMap(XDBDocument xDBDocument, long l) {
        this.m_owner = xDBDocument;
        this.m_mapcstate = l;
    }

    public int getLength() {
        return (int)this.getNumNodesNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_mapcstate);
    }

    public Node getNamedItem(String string) {
        long l = this.getNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_mapcstate, null, string);
        if (l != 0L) {
            return XDBNode.getNodeFromCState(this.m_owner, l);
        }
        return null;
    }

    public Node getNamedItemNS(String string, String string2) {
        long l = this.getNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_mapcstate, string, string2);
        if (l != 0L) {
            return XDBNode.getNodeFromCState(this.m_owner, l);
        }
        return null;
    }

    private native long getNodeItemAtNative(long var1, long var3, long var5);

    private native long getNodeNative(long var1, long var3, String var5, String var6);

    private native long getNumNodesNative(long var1, long var3);

    public Node item(int n) {
        long l = this.getNodeItemAtNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_mapcstate, n);
        if (l != 0L) {
            return XDBNode.getNodeFromCState(this.m_owner, l);
        }
        return null;
    }

    public Node removeNamedItem(String string) {
        long l = this.removeNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_mapcstate, null, string);
        if (l != 0L) {
            return XDBNode.getNodeFromCState(this.m_owner, l);
        }
        throw new DOMException(8, "Item " + string + " not found");
    }

    public Node removeNamedItemNS(String string, String string2) {
        long l = this.removeNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_mapcstate, string, string2);
        if (l != 0L) {
            return XDBNode.getNodeFromCState(this.m_owner, l);
        }
        throw new DOMException(8, "Item " + string2 + " not found in " + string);
    }

    private native long removeNodeNative(long var1, long var3, String var5, String var6);

    public Node setNamedItem(Node node) {
        if (node.getNodeType() != 2 && node.getNodeType() != 12 && node.getNodeType() != 6) {
            throw new XDBDOMException(3, "Only attribute, notation and entity nodes can be inserted here");
        }
        long l = 0L;
        try {
            l = this.setNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_mapcstate, ((XDBNode)node).toCState());
        }
        catch (DOMException dOMException) {
            switch (dOMException.code) {
                case 32124: {
                    throw new DOMException(10, "Attribute in use");
                }
            }
            throw dOMException;
        }
        if (l == 0L) {
            return null;
        }
        return XDBNode.getNodeFromCState(this.m_owner, l);
    }

    public Node setNamedItemNS(Node node) {
        if (node.getNodeType() != 2 && node.getNodeType() != 12 && node.getNodeType() != 6) {
            throw new XDBDOMException(3, "Only attribute, notation and entity nodes can be inserted here");
        }
        long l = 0L;
        try {
            l = this.setNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_mapcstate, ((XDBNode)node).toCState());
        }
        catch (DOMException dOMException) {
            switch (dOMException.code) {
                case 32124: {
                    throw new DOMException(10, "Attribute in use");
                }
            }
            throw dOMException;
        }
        if (l == 0L) {
            return null;
        }
        return XDBNode.getNodeFromCState(this.m_owner, l);
    }

    private native long setNodeNative(long var1, long var3, long var5);
}

