/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.userdb.ws;

import alma.obsprep.ot.userdb.UserDatabase;
import alma.obsprep.ot.userdb.exceptions.CommunicationException;
import alma.obsprep.ot.userdb.exceptions.InvalidArgumentException;
import alma.obsprep.ot.userdb.exceptions.InvestigatorDatabaseException;
import alma.obsprep.ot.userdb.ws.server.CommunicationException_Exception;
import alma.obsprep.ot.userdb.ws.server.InvalidArgumentException_Exception;
import alma.obsprep.ot.userdb.ws.server.InvestigatorDatabaseException_Exception;
import alma.obsprep.ot.userdb.ws.server.MatchInvestigators;
import alma.obsprep.ot.userdb.ws.server.MatchInvestigatorsService;
import alma.obsprep.ot.userdb.ws.server.QueryResults;
import alma.obsprep.ot.userdb.ws.server.User;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceClient;

public class WebServiceUserDatabase
implements UserDatabase {
    MatchInvestigatorsService service;

    public WebServiceUserDatabase() throws MalformedURLException, CommunicationException {
        this(null);
    }

    public WebServiceUserDatabase(URL url) throws MalformedURLException, CommunicationException {
        if (url == null) {
            url = new URL("http://localhost:8180/InvestigatorDbWS/MatchInvestigators");
        }
        WebServiceClient ann = MatchInvestigatorsService.class.getAnnotation(WebServiceClient.class);
        QName qname = new QName(ann.targetNamespace(), ann.name());
        try {
            this.service = new MatchInvestigatorsService(url, qname);
        }
        catch (RuntimeException ex) {
            throw new CommunicationException("No web service at " + url.toString(), (Throwable)ex);
        }
    }

    public boolean isAlive() {
        if (this.service == null) {
            return false;
        }
        try {
            MatchInvestigators port = this.service.getMatchInvestigatorsPort();
            return port.isAlive();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public alma.obsprep.ot.userdb.QueryResults matchEmail(String email) throws CommunicationException, InvestigatorDatabaseException, InvalidArgumentException {
        try {
            MatchInvestigators port = this.service.getMatchInvestigatorsPort();
            QueryResults result = port.matchEmail(email);
            return this.convertWSQueryResults(result);
        }
        catch (InvalidArgumentException_Exception ex) {
            throw new InvalidArgumentException((Throwable)ex);
        }
        catch (CommunicationException_Exception ex) {
            throw new CommunicationException((Throwable)ex);
        }
        catch (InvestigatorDatabaseException_Exception ex) {
            throw new InvestigatorDatabaseException((Throwable)ex);
        }
    }

    public alma.obsprep.ot.userdb.QueryResults matchEmail(List<String> addresses) throws CommunicationException, InvestigatorDatabaseException, InvalidArgumentException {
        try {
            MatchInvestigators port = this.service.getMatchInvestigatorsPort();
            QueryResults result = port.matchEmails(addresses);
            return this.convertWSQueryResults(result);
        }
        catch (InvalidArgumentException_Exception ex) {
            throw new InvalidArgumentException((Throwable)ex);
        }
        catch (CommunicationException_Exception ex) {
            throw new CommunicationException((Throwable)ex);
        }
        catch (InvestigatorDatabaseException_Exception ex) {
            throw new InvestigatorDatabaseException((Throwable)ex);
        }
    }

    public alma.obsprep.ot.userdb.QueryResults matchName(String name) throws CommunicationException, InvestigatorDatabaseException {
        try {
            MatchInvestigators port = this.service.getMatchInvestigatorsPort();
            QueryResults result = port.matchName(name);
            return this.convertWSQueryResults(result);
        }
        catch (CommunicationException_Exception ex) {
            throw new CommunicationException((Throwable)ex);
        }
        catch (InvestigatorDatabaseException_Exception ex) {
            throw new InvestigatorDatabaseException((Throwable)ex);
        }
    }

    public alma.obsprep.ot.userdb.QueryResults matchName(List<String> names) throws CommunicationException, InvestigatorDatabaseException {
        try {
            MatchInvestigators port = this.service.getMatchInvestigatorsPort();
            QueryResults result = port.matchNames(names);
            return this.convertWSQueryResults(result);
        }
        catch (CommunicationException_Exception ex) {
            throw new CommunicationException((Throwable)ex);
        }
        catch (InvestigatorDatabaseException_Exception ex) {
            throw new InvestigatorDatabaseException((Throwable)ex);
        }
    }

    public alma.obsprep.ot.userdb.QueryResults matchUid(String uid) throws CommunicationException, InvestigatorDatabaseException {
        try {
            MatchInvestigators port = this.service.getMatchInvestigatorsPort();
            QueryResults result = port.matchUid(uid);
            return this.convertWSQueryResults(result);
        }
        catch (CommunicationException_Exception ex) {
            throw new CommunicationException((Throwable)ex);
        }
        catch (InvestigatorDatabaseException_Exception ex) {
            throw new InvestigatorDatabaseException((Throwable)ex);
        }
    }

    public alma.obsprep.ot.userdb.QueryResults matchUid(List<String> uids) throws CommunicationException, InvestigatorDatabaseException {
        try {
            MatchInvestigators port = this.service.getMatchInvestigatorsPort();
            QueryResults result = port.matchUids(uids);
            return this.convertWSQueryResults(result);
        }
        catch (CommunicationException_Exception ex) {
            throw new CommunicationException((Throwable)ex);
        }
        catch (InvestigatorDatabaseException_Exception ex) {
            throw new InvestigatorDatabaseException((Throwable)ex);
        }
    }

    public alma.obsprep.ot.userdb.QueryResults convertWSQueryResults(QueryResults wsResult) {
        List<User> wsUsers = wsResult.getMatches();
        ArrayList<alma.obsprep.ot.userdb.User> users = new ArrayList<alma.obsprep.ot.userdb.User>();
        for (User wsUser : wsUsers) {
            alma.obsprep.ot.userdb.User user = new alma.obsprep.ot.userdb.User();
            user.setAffiliation(wsUser.getAffiliation());
            user.setEmail(wsUser.getEmail());
            user.setFirstName(wsUser.getFirstName());
            user.setFullName(wsUser.getFullName());
            user.setSurname(wsUser.getSurname());
            user.setTelephone(wsUser.getTelephone());
            user.setUid(wsUser.getUid());
            users.add(user);
        }
        return new alma.obsprep.ot.userdb.QueryResults(users);
    }
}

