/*
 * Decompiled with CFR 0.152.
 */
package com.codestreet.selector.parser;

import com.codestreet.selector.parser.IExpression;
import com.codestreet.selector.parser.IValueProvider;
import com.codestreet.selector.parser.NumericValue;
import com.codestreet.selector.parser.Result;
import java.util.Map;

abstract class ArithCompareOpImpl {
    public static final ArithCompareOpImpl EQ = new ArithCompareOpImpl(" = "){

        public Object eval(Map identifiers, IExpression lhs, IExpression rhs) {
            Object oLhs = lhs.eval(identifiers);
            if (oLhs == null) {
                return Result.RESULT_UNKNOWN;
            }
            if (!(oLhs instanceof NumericValue)) {
                return Result.RESULT_FALSE;
            }
            NumericValue nLhs = (NumericValue)oLhs;
            Object oRhs = rhs.eval(identifiers);
            if (oRhs == null) {
                return Result.RESULT_UNKNOWN;
            }
            if (!(oRhs instanceof NumericValue)) {
                return Result.RESULT_FALSE;
            }
            NumericValue nRhs = (NumericValue)oRhs;
            return nLhs.doubleValue() == nRhs.doubleValue() ? Result.RESULT_TRUE : Result.RESULT_FALSE;
        }

        public Object eval(IValueProvider provider, Object corr, IExpression lhs, IExpression rhs) {
            Object oLhs = lhs.eval(provider, corr);
            if (oLhs == null) {
                return Result.RESULT_UNKNOWN;
            }
            if (!(oLhs instanceof NumericValue)) {
                return Result.RESULT_FALSE;
            }
            NumericValue nLhs = (NumericValue)oLhs;
            Object oRhs = rhs.eval(provider, corr);
            if (oRhs == null) {
                return Result.RESULT_UNKNOWN;
            }
            if (!(oRhs instanceof NumericValue)) {
                return Result.RESULT_FALSE;
            }
            NumericValue nRhs = (NumericValue)oRhs;
            return nLhs.doubleValue() == nRhs.doubleValue() ? Result.RESULT_TRUE : Result.RESULT_FALSE;
        }
    };
    public static final ArithCompareOpImpl GT = new ArithCompareOpImpl(" > "){

        public Object eval(Map identifiers, IExpression lhs, IExpression rhs) {
            Object oLhs = lhs.eval(identifiers);
            if (oLhs == null) {
                return Result.RESULT_UNKNOWN;
            }
            if (!(oLhs instanceof NumericValue)) {
                return Result.RESULT_FALSE;
            }
            NumericValue nLhs = (NumericValue)oLhs;
            Object oRhs = rhs.eval(identifiers);
            if (oRhs == null) {
                return Result.RESULT_UNKNOWN;
            }
            if (!(oRhs instanceof NumericValue)) {
                return Result.RESULT_FALSE;
            }
            NumericValue nRhs = (NumericValue)oRhs;
            return nLhs.doubleValue() > nRhs.doubleValue() ? Result.RESULT_TRUE : Result.RESULT_FALSE;
        }

        public Object eval(IValueProvider provider, Object corr, IExpression lhs, IExpression rhs) {
            Object oLhs = lhs.eval(provider, corr);
            if (oLhs == null) {
                return Result.RESULT_UNKNOWN;
            }
            if (!(oLhs instanceof NumericValue)) {
                return Result.RESULT_FALSE;
            }
            NumericValue nLhs = (NumericValue)oLhs;
            Object oRhs = rhs.eval(provider, corr);
            if (oRhs == null) {
                return Result.RESULT_UNKNOWN;
            }
            if (!(oRhs instanceof NumericValue)) {
                return Result.RESULT_FALSE;
            }
            NumericValue nRhs = (NumericValue)oRhs;
            return nLhs.doubleValue() > nRhs.doubleValue() ? Result.RESULT_TRUE : Result.RESULT_FALSE;
        }
    };
    public static final ArithCompareOpImpl GE = new ArithCompareOpImpl(" >= "){

        public Object eval(Map identifiers, IExpression lhs, IExpression rhs) {
            Object oLhs = lhs.eval(identifiers);
            if (oLhs == null) {
                return Result.RESULT_UNKNOWN;
            }
            if (!(oLhs instanceof NumericValue)) {
                return Result.RESULT_FALSE;
            }
            NumericValue nLhs = (NumericValue)oLhs;
            Object oRhs = rhs.eval(identifiers);
            if (oRhs == null) {
                return Result.RESULT_UNKNOWN;
            }
            if (!(oRhs instanceof NumericValue)) {
                return Result.RESULT_FALSE;
            }
            NumericValue nRhs = (NumericValue)oRhs;
            return nLhs.doubleValue() >= nRhs.doubleValue() ? Result.RESULT_TRUE : Result.RESULT_FALSE;
        }

        public Object eval(IValueProvider provider, Object corr, IExpression lhs, IExpression rhs) {
            Object oLhs = lhs.eval(provider, corr);
            if (oLhs == null) {
                return Result.RESULT_UNKNOWN;
            }
            if (!(oLhs instanceof NumericValue)) {
                return Result.RESULT_FALSE;
            }
            NumericValue nLhs = (NumericValue)oLhs;
            Object oRhs = rhs.eval(provider, corr);
            if (oRhs == null) {
                return Result.RESULT_UNKNOWN;
            }
            if (!(oRhs instanceof NumericValue)) {
                return Result.RESULT_FALSE;
            }
            NumericValue nRhs = (NumericValue)oRhs;
            return nLhs.doubleValue() >= nRhs.doubleValue() ? Result.RESULT_TRUE : Result.RESULT_FALSE;
        }
    };
    public static final ArithCompareOpImpl LT = new ArithCompareOpImpl(" < "){

        public Object eval(Map identifiers, IExpression lhs, IExpression rhs) {
            Object oLhs = lhs.eval(identifiers);
            if (oLhs == null) {
                return Result.RESULT_UNKNOWN;
            }
            if (!(oLhs instanceof NumericValue)) {
                return Result.RESULT_FALSE;
            }
            NumericValue nLhs = (NumericValue)oLhs;
            Object oRhs = rhs.eval(identifiers);
            if (oRhs == null) {
                return Result.RESULT_UNKNOWN;
            }
            if (!(oRhs instanceof NumericValue)) {
                return Result.RESULT_FALSE;
            }
            NumericValue nRhs = (NumericValue)oRhs;
            return nLhs.doubleValue() < nRhs.doubleValue() ? Result.RESULT_TRUE : Result.RESULT_FALSE;
        }

        public Object eval(IValueProvider provider, Object corr, IExpression lhs, IExpression rhs) {
            Object oLhs = lhs.eval(provider, corr);
            if (oLhs == null) {
                return Result.RESULT_UNKNOWN;
            }
            if (!(oLhs instanceof NumericValue)) {
                return Result.RESULT_FALSE;
            }
            NumericValue nLhs = (NumericValue)oLhs;
            Object oRhs = rhs.eval(provider, corr);
            if (oRhs == null) {
                return Result.RESULT_UNKNOWN;
            }
            if (!(oRhs instanceof NumericValue)) {
                return Result.RESULT_FALSE;
            }
            NumericValue nRhs = (NumericValue)oRhs;
            return nLhs.doubleValue() < nRhs.doubleValue() ? Result.RESULT_TRUE : Result.RESULT_FALSE;
        }
    };
    public static final ArithCompareOpImpl LE = new ArithCompareOpImpl(" <= "){

        public Object eval(Map identifiers, IExpression lhs, IExpression rhs) {
            Object oLhs = lhs.eval(identifiers);
            if (oLhs == null) {
                return Result.RESULT_UNKNOWN;
            }
            if (!(oLhs instanceof NumericValue)) {
                return Result.RESULT_FALSE;
            }
            NumericValue nLhs = (NumericValue)oLhs;
            Object oRhs = rhs.eval(identifiers);
            if (oRhs == null) {
                return Result.RESULT_UNKNOWN;
            }
            if (!(oRhs instanceof NumericValue)) {
                return Result.RESULT_FALSE;
            }
            NumericValue nRhs = (NumericValue)oRhs;
            return nLhs.doubleValue() <= nRhs.doubleValue() ? Result.RESULT_TRUE : Result.RESULT_FALSE;
        }

        public Object eval(IValueProvider provider, Object corr, IExpression lhs, IExpression rhs) {
            Object oLhs = lhs.eval(provider, corr);
            if (oLhs == null) {
                return Result.RESULT_UNKNOWN;
            }
            if (!(oLhs instanceof NumericValue)) {
                return Result.RESULT_FALSE;
            }
            NumericValue nLhs = (NumericValue)oLhs;
            Object oRhs = rhs.eval(provider, corr);
            if (oRhs == null) {
                return Result.RESULT_UNKNOWN;
            }
            if (!(oRhs instanceof NumericValue)) {
                return Result.RESULT_FALSE;
            }
            NumericValue nRhs = (NumericValue)oRhs;
            return nLhs.doubleValue() <= nRhs.doubleValue() ? Result.RESULT_TRUE : Result.RESULT_FALSE;
        }
    };
    private final String operator_;

    private ArithCompareOpImpl(String operator) {
        this.operator_ = operator;
    }

    public String toString() {
        return this.operator_;
    }

    public abstract Object eval(Map var1, IExpression var2, IExpression var3);

    public abstract Object eval(IValueProvider var1, Object var2, IExpression var3, IExpression var4);
}

