/*
 * Decompiled with CFR 0.152.
 */
package alma.ngas.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Status {
    private Logger logger;
    private boolean OK;
    private boolean receivingFile;
    private int httpCode;
    private String httpMsg;
    private String xml;
    private String msg;
    private String xmlFileName;
    private HashMap<String, String> statusMap = new HashMap();
    private HashMap<String, String> diskStatusMap = new HashMap();
    private HashMap<String, String> fileStatusMap = new HashMap();
    private Document xmlDoc = null;

    Status(boolean bl) {
        this.OK = bl;
    }

    Status(boolean bl, String string) {
        this.OK = bl;
        this.msg = string;
    }

    Status(int n, String string, String string2, String string3, Logger logger) {
        this.logger = logger;
        this.httpCode = n;
        this.httpMsg = string;
        this.OK = n == 200;
        this.xmlFileName = string3;
        this.xml = string2;
        this.parseXML();
    }

    Status(int n, String string) {
        this.httpCode = n;
        this.httpMsg = string;
        this.OK = n == 200;
    }

    Status(int n, String string, String string2, String string3, String string4, Logger logger) {
        this.logger = logger;
        this.httpCode = n;
        this.httpMsg = string;
        this.xml = string2;
        this.xmlFileName = string4;
        this.parseXML();
        this.msg = string3;
        this.OK = n == 200;
    }

    public String getXML() {
        return this.xml;
    }

    public boolean getOK() {
        return this.OK;
    }

    public int getHttpCode() {
        return this.httpCode;
    }

    public String getHttpMsg() {
        return this.httpMsg;
    }

    public String getMsg() {
        return this.msg;
    }

    public boolean getReceivingFile() {
        return this.receivingFile;
    }

    public String getCompletionTime() {
        return this.statusMap.get(StatusEnum.CompletionTime.toString());
    }

    public String getDate() {
        return this.statusMap.get(StatusEnum.Date.toString());
    }

    public String getHostId() {
        return this.statusMap.get(StatusEnum.HostId.toString());
    }

    public String getLastRequestStatUpdate() {
        return this.statusMap.get(StatusEnum.LastRequestStatUpdate.toString());
    }

    public String getMessage() {
        return this.statusMap.get(StatusEnum.Message.toString());
    }

    public String getRequestId() {
        return this.statusMap.get(StatusEnum.RequestId.toString());
    }

    public String getRequestTime() {
        return this.statusMap.get(StatusEnum.RequestTime.toString());
    }

    public String getState() {
        return this.statusMap.get(StatusEnum.State.toString());
    }

    public String getStatus() {
        return this.statusMap.get(StatusEnum.Status.toString());
    }

    public String getSubState() {
        return this.statusMap.get(StatusEnum.SubState.toString());
    }

    public String getVersion() {
        return this.statusMap.get(StatusEnum.Version.toString());
    }

    public String getArchive() {
        return this.diskStatusMap.get(DiskStatusEnum.Archive.toString());
    }

    public String getAvailableMb() {
        return this.diskStatusMap.get(DiskStatusEnum.AvailableMb.toString());
    }

    public String getBytesStored() {
        return this.diskStatusMap.get(DiskStatusEnum.BytesStored.toString());
    }

    public String getDiskChecksum() {
        return this.diskStatusMap.get(DiskStatusEnum.Checksum.toString());
    }

    public String getCompleted() {
        return this.diskStatusMap.get(DiskStatusEnum.Completed.toString());
    }

    public String getCompletionDate() {
        return this.diskStatusMap.get(DiskStatusEnum.CompletionDate.toString());
    }

    public String getDiskId() {
        return this.diskStatusMap.get(DiskStatusEnum.DiskId.toString());
    }

    public String getInstallationDate() {
        return this.diskStatusMap.get(DiskStatusEnum.InstallationDate.toString());
    }

    public String getLastCheck() {
        return this.diskStatusMap.get(DiskStatusEnum.LastCheck.toString());
    }

    public String getLogicalName() {
        return this.diskStatusMap.get(DiskStatusEnum.LogicalName.toString());
    }

    public String getManufacturer() {
        return this.diskStatusMap.get(DiskStatusEnum.Manufacturer.toString());
    }

    public String getMountPoint() {
        return this.diskStatusMap.get(DiskStatusEnum.MountPoint.toString());
    }

    public String getMounted() {
        return this.diskStatusMap.get(DiskStatusEnum.Mounted.toString());
    }

    public String getNumberOfFiles() {
        return this.diskStatusMap.get(DiskStatusEnum.NumberOfFiles.toString());
    }

    public String getSlotId() {
        return this.diskStatusMap.get(DiskStatusEnum.SlotId.toString());
    }

    public String getTotalDiskWriteTime() {
        return this.diskStatusMap.get(DiskStatusEnum.TotalDiskWriteTime.toString());
    }

    public String getType() {
        return this.diskStatusMap.get(DiskStatusEnum.Type.toString());
    }

    public String getFileChecksum() {
        return this.fileStatusMap.get(FileStatusEnum.Checksum.toString());
    }

    public String getChecksumPlugIn() {
        return this.fileStatusMap.get(FileStatusEnum.ChecksumPlugIn.toString());
    }

    public String getCompression() {
        return this.fileStatusMap.get(FileStatusEnum.Compression.toString());
    }

    public String getCreationDate() {
        return this.fileStatusMap.get(FileStatusEnum.CreationDate.toString());
    }

    public String getFileId() {
        return this.fileStatusMap.get(FileStatusEnum.FileId.toString());
    }

    public String getFileName() {
        return this.fileStatusMap.get(FileStatusEnum.FileName.toString());
    }

    public String getFileSize() {
        return this.fileStatusMap.get(FileStatusEnum.FileSize.toString());
    }

    public String getFileStatus() {
        return this.fileStatusMap.get(FileStatusEnum.FileStatus.toString());
    }

    public String getFileVersion() {
        return this.fileStatusMap.get(FileStatusEnum.FileVersion.toString());
    }

    public String getFormat() {
        return this.fileStatusMap.get(FileStatusEnum.Format.toString());
    }

    public String getIgnore() {
        return this.fileStatusMap.get(FileStatusEnum.Ignore.toString());
    }

    public String getIngestionDate() {
        return this.fileStatusMap.get(FileStatusEnum.IngestionDate.toString());
    }

    public String getTag() {
        return this.fileStatusMap.get(FileStatusEnum.Tag.toString());
    }

    public String getUncompressedFileSize() {
        return this.fileStatusMap.get(FileStatusEnum.UncompressedFileSize.toString());
    }

    public String getRequestStatus() {
        String string;
        String string2 = string = this.OK ? "Status is OK" : "Status is not OK";
        if (this.httpMsg != null) {
            string = string + "\nHTTP code is " + this.httpCode + " & HTTP message is: " + this.httpMsg;
        }
        string = string + (this.msg == null || this.msg == "" ? "\nNo additional message." : "\nAdditional message:\n" + this.msg);
        return string;
    }

    private void saveXML(String string) {
        try {
            File file = new File(string);
            file.deleteOnExit();
            if (file.exists()) {
                file.delete();
            }
            boolean bl = file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(this.xmlFileName);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            printWriter.print(this.xml);
            printWriter.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            this.logger.warning("IOException in Status.saveXML; messge is: " + iOException.getMessage());
        }
    }

    public void getTagAttrs(String string, HashMap<String, String> hashMap) {
        this.getTagAttrs(string, 0, hashMap);
    }

    public void getTagAttrs(String string, int n, HashMap<String, String> hashMap) {
        try {
            if (this.xml == null || this.xml == "") {
                throw new IllegalArgumentException("There is no XML to parse. Error generated by getTagAttr in Status.");
            }
            NodeList nodeList = this.xmlDoc.getElementsByTagName(string);
            if (nodeList.getLength() <= n || n < 0) {
                return;
            }
            NamedNodeMap namedNodeMap = nodeList.item(n).getAttributes();
            for (String string2 : hashMap.keySet()) {
                Node node = namedNodeMap.getNamedItem(string2);
                if (node == null) {
                    hashMap.put(string2, null);
                    continue;
                }
                hashMap.put(string2, node.getNodeValue());
            }
        }
        catch (Exception exception) {
            this.logger.warning("Exception in Status.getTagAttr; message is: " + exception.getMessage());
            throw new IllegalArgumentException("Unexpected exception", exception);
        }
    }

    private void makeXmlDoc(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            StringReader stringReader = new StringReader(string);
            InputSource inputSource = new InputSource(stringReader);
            this.xmlDoc = documentBuilder.parse(inputSource);
        }
        catch (Throwable throwable) {
            this.logger.severe("Exception in Status.makeXmlDoc; message is: " + throwable);
            this.logger.severe("Original document was: \n" + string);
        }
    }

    private void parseXML() {
        this.makeXmlDoc(this.getXML());
        this.statusMap = new HashMap();
        for (StatusEnum enum_ : (StatusEnum[])StatusEnum.class.getEnumConstants()) {
            this.statusMap.put(enum_.toString(), null);
        }
        this.getTagAttrs("Status", this.statusMap);
        this.diskStatusMap = new HashMap();
        for (Enum enum_ : (DiskStatusEnum[])DiskStatusEnum.class.getEnumConstants()) {
            this.diskStatusMap.put(enum_.toString(), null);
        }
        this.getTagAttrs("DiskStatus", this.diskStatusMap);
        this.fileStatusMap = new HashMap();
        for (Enum enum_ : (FileStatusEnum[])FileStatusEnum.class.getEnumConstants()) {
            this.fileStatusMap.put(enum_.toString(), null);
        }
        this.getTagAttrs("FileStatus", this.fileStatusMap);
    }

    private static enum FileStatusEnum {
        Checksum,
        ChecksumPlugIn,
        Compression,
        CreationDate,
        FileId,
        FileName,
        FileSize,
        FileStatus,
        FileVersion,
        Format,
        Ignore,
        IngestionDate,
        Tag,
        UncompressedFileSize;

    }

    private static enum DiskStatusEnum {
        Archive,
        AvailableMb,
        BytesStored,
        Checksum,
        Completed,
        CompletionDate,
        DiskId,
        InstallationDate,
        LastCheck,
        LogicalName,
        Manufacturer,
        MountPoint,
        Mounted,
        NumberOfFiles,
        SlotId,
        TotalDiskWriteTime,
        Type;

    }

    private static enum StatusEnum {
        CompletionTime,
        Date,
        HostId,
        LastRequestStatUpdate,
        Message,
        RequestId,
        RequestTime,
        State,
        Status,
        SubState,
        Version;

    }
}

