/*
 * Decompiled with CFR 0.152.
 */
package alma.ngas.client;

import alma.ngas.client.ConnectionManager;
import alma.ngas.client.FileReceivedEventListener;
import alma.ngas.client.MiniServer;
import alma.ngas.client.Status;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JClient {
    private static final int BLOCK_SIZE = 1024;
    private int miniServerPort;
    private String ngamsHost;
    private int ngamsPort;
    private boolean subscribed = false;
    private static MiniServer miniServer;
    public Logger logger;
    public String url;
    private String dataRaw;
    private ConnectionManager myConnectionManager = ConnectionManager.getInstance();
    private String myProcessingParameters;

    public static void main(String[] stringArray) {
        Logger logger = Logger.getLogger("ArchiverTest logger");
        logger.setLevel(Level.ALL);
        ArrayList<InetSocketAddress> arrayList = new ArrayList<InetSocketAddress>();
        arrayList.add(new InetSocketAddress("ga004786", 7777));
        JClient jClient = new JClient(arrayList, logger);
        Status status = jClient.status();
        System.out.println("XML Status Document:\n" + status.getXML());
        status = jClient.retrieve("TEST.2001-05-08T15:25:00.123", "TEST.2001-05-08T15:25:00.123.fits.Z");
        System.out.println("XML Status Document:\n" + status.getXML());
        status = jClient.retrieve("NON-EXISTING", "");
        System.out.println("XML Status Document:\n" + status.getXML());
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("NCU.2003-11-11T11:11:11.111.fits.Z");
            status = jClient.retrieveStream("NCU.2003-11-11T11:11:11.111", fileOutputStream);
            System.out.println("XML Status Document:\n" + status.getXML());
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.warning("FileNotFoundException while retrieving file. Error: " + fileNotFoundException.toString());
        }
    }

    public JClient(List<InetSocketAddress> list, int n, String string, String string2, Logger logger) {
        this.logger = logger;
        this.myConnectionManager.setConnectionList(list);
        this.ngamsHost = list.get(0).getHostName();
        this.ngamsPort = list.get(0).getPort();
        this.miniServerPort = n;
        this.dataRaw = string;
        try {
            if (string2 == null) {
                string2 = InetAddress.getLocalHost().getCanonicalHostName();
            }
        }
        catch (UnknownHostException unknownHostException) {
            String string3 = "The parameter URL to the constructor JClient was specified as null. This means the constructor attempts to find the URL of the local machine using the method InetAddress.getLocalHost().getCanonicalHostName(). Note that JClient needs the URL of the local machine for handling SUBSCRIBE commands. In this case a miniServer object is set up by JClient in order to listen for files HTTP POST command. An error occured while trying to find the URL of the local machine. The exception message is: " + unknownHostException.getMessage();
            this.logger.severe(string3);
        }
        this.url = "http://" + string2 + ":" + n + "/ARCHIVE";
    }

    public JClient(List<InetSocketAddress> list, Logger logger) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("The supplied connection list may not be empty.");
        }
        this.myConnectionManager.setConnectionList(list);
        this.ngamsHost = list.get(0).getHostName();
        this.ngamsPort = list.get(0).getPort();
        this.logger = logger;
    }

    ConnectionManager getConnectionManager() {
        return this.myConnectionManager;
    }

    private Status _archive(String string, String string2, String string3) {
        try {
            String string4 = "attachment;";
            int n = 1;
            File file = new File(string);
            long l = file.length();
            String string5 = file.getName();
            URL uRL = null;
            uRL = new URL("http", this.ngamsHost, this.ngamsPort, "ARCHIVE");
            HttpURLConnection httpURLConnection = null;
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            HttpURLConnection.setFollowRedirects(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("User-Agent", "NG/AMS J-API");
            httpURLConnection.setRequestProperty("Content-Type", string2);
            httpURLConnection.setRequestProperty("Content-Length", String.valueOf(l));
            string4 = string4 + "filename=\"" + string5 + "\";";
            string4 = string4 + "wait=\"" + n + "\";";
            string4 = string4 + (string3 == "1" ? "" : " no_versioning=0");
            httpURLConnection.setRequestProperty("Content-Disposition", string4);
            httpURLConnection.connect();
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            byte[] byArray = new byte[1024];
            int n2 = 0;
            while ((n2 = dataInputStream.read(byArray, 0, 1024)) > 0) {
                dataOutputStream.write(byArray, 0, n2);
                dataOutputStream.flush();
            }
            dataInputStream.close();
            dataOutputStream.close();
            int n3 = httpURLConnection.getResponseCode();
            String string6 = httpURLConnection.getResponseMessage();
            BufferedReader bufferedReader = null;
            if (n3 != 200) {
                this.logger.warning("NGAS returned HTTP code: " + n3 + " in response to archive request, in " + "JClient.myArchive. Please see instance of " + "Status returned for more information.");
            }
            bufferedReader = new BufferedReader(new InputStreamReader(n3 == 200 ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream()));
            String string7 = "";
            String string8 = null;
            while ((string8 = bufferedReader.readLine()) != null) {
                string7 = string7 + string8 + "\n";
            }
            bufferedReader.close();
            httpURLConnection.disconnect();
            return new Status(n3, string6, string7, this.dataRaw + "ngams.xml", this.logger);
        }
        catch (IOException iOException) {
            this.logger.warning("IOException in JClient._archive. Please see instance of Status returned for more details");
            return new Status(false, "Error generated by myArchive in JClient. Description:\n" + iOException.toString());
        }
    }

    private Status _ArchiveStream(InputStream inputStream, String string, String string2, String string3) {
        try {
            String string4 = "attachment;";
            int n = 1;
            URL uRL = null;
            uRL = new URL("http", this.ngamsHost, this.ngamsPort, "ARCHIVE");
            HttpURLConnection httpURLConnection = null;
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            HttpURLConnection.setFollowRedirects(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("User-Agent", "NG/AMS J-API");
            httpURLConnection.setRequestProperty("Content-Type", string);
            string4 = string4 + "filename=\"" + string2 + "\";";
            string4 = string4 + "wait=\"" + n + "\";";
            string4 = string4 + (string3 == "1" ? "" : " no_versioning=0");
            httpURLConnection.setRequestProperty("Content-Disposition", string4);
            httpURLConnection.connect();
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            byte[] byArray = new byte[1024];
            int n2 = 0;
            while ((n2 = dataInputStream.read(byArray, 0, 1024)) > 0) {
                dataOutputStream.write(byArray, 0, n2);
                dataOutputStream.flush();
            }
            dataInputStream.close();
            dataOutputStream.close();
            int n3 = httpURLConnection.getResponseCode();
            String string5 = httpURLConnection.getResponseMessage();
            BufferedReader bufferedReader = null;
            if (n3 != 200) {
                this.logger.warning("NGAS returned HTTP code: " + n3 + " in response to archive request, in " + "JClient._archive. Please see instance of " + "Status returned for more information.");
            }
            bufferedReader = new BufferedReader(new InputStreamReader(n3 == 200 ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream()));
            String string6 = "";
            String string7 = null;
            while ((string7 = bufferedReader.readLine()) != null) {
                string6 = string6 + string7 + "\n";
            }
            bufferedReader.close();
            httpURLConnection.disconnect();
            return new Status(n3, string5, string6, null, this.dataRaw + "ngams.xml", this.logger);
        }
        catch (IOException iOException) {
            this.logger.warning("IOException in JClient._archive. Please see instance of Status returned for more details");
            return new Status(false, "Error generated by myArchive in JClient. Description:\n" + iOException.toString());
        }
    }

    private Status _Retrieve(String string, String string2) {
        try {
            HttpURLConnection httpURLConnection = this.myConnectionManager.getConnection(string);
            int n = httpURLConnection.getResponseCode();
            String string3 = httpURLConnection.getResponseMessage();
            if (n != 200) {
                String string4 = "";
                BufferedReader bufferedReader = null;
                bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream()));
                String string5 = null;
                while ((string5 = bufferedReader.readLine()) != null) {
                    string4 = string4 + string5 + "\n";
                }
                bufferedReader.close();
                String string6 = "Error when attempting to send a retrieve command:\n" + string + " to NGAS. For further information, " + "consult the instance of Status returned.";
                this.logger.warning(string6);
                return new Status(n, string3, string4, this.dataRaw + "ngams.xml", this.logger);
            }
            File file = new File(string2);
            DataInputStream dataInputStream = new DataInputStream(httpURLConnection.getInputStream());
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[1024];
            int n2 = 0;
            while ((n2 = dataInputStream.read(byArray, 0, 1024)) > 0) {
                dataOutputStream.write(byArray, 0, n2);
                dataOutputStream.flush();
            }
            dataInputStream.close();
            dataOutputStream.close();
            n = httpURLConnection.getResponseCode();
            string3 = httpURLConnection.getResponseMessage();
            httpURLConnection.disconnect();
            this.logger.info("Sent retrieve message to NGAMS: " + string);
            return new Status(n, string3);
        }
        catch (IOException iOException) {
            this.logger.warning("IOException sending retrieve command to NGAS. Tried to send command: " + string);
            return new Status(false, "Error generated by _Retrieve in JClient. Description:\n" + iOException.toString());
        }
    }

    private Status _RetrieveStream(String string, OutputStream outputStream) {
        try {
            HttpURLConnection httpURLConnection = this.myConnectionManager.getConnection(string);
            int n = httpURLConnection.getResponseCode();
            String string2 = httpURLConnection.getResponseMessage();
            if (n != 200) {
                String string3 = "";
                BufferedReader bufferedReader = null;
                bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream()));
                String string4 = null;
                while ((string4 = bufferedReader.readLine()) != null) {
                    string3 = string3 + string4 + "\n";
                }
                bufferedReader.close();
                String string5 = "Error when attempting to send a retrieve command:\n" + string + " to NGAS. For further information, " + "consult the instance of Status returned.";
                this.logger.warning(string5);
                return new Status(n, string2, string3, this.dataRaw + "ngams.xml", this.logger);
            }
            DataInputStream dataInputStream = new DataInputStream(httpURLConnection.getInputStream());
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            byte[] byArray = new byte[1024];
            int n2 = 0;
            while ((n2 = dataInputStream.read(byArray, 0, 1024)) > 0) {
                dataOutputStream.write(byArray, 0, n2);
                dataOutputStream.flush();
            }
            dataInputStream.close();
            dataOutputStream.close();
            n = httpURLConnection.getResponseCode();
            string2 = httpURLConnection.getResponseMessage();
            httpURLConnection.disconnect();
            this.logger.info("Sent retrieve message to NGAMS: " + string);
            return new Status(n, string2);
        }
        catch (IOException iOException) {
            this.logger.warning("IOException sending retrieve command to NGAS. Tried to send command: " + string);
            return new Status(false, "Error generated by _Retrieve in JClient. Description:\n" + iOException.toString());
        }
    }

    public boolean addFileReceivedEventListener(FileReceivedEventListener fileReceivedEventListener) {
        if (miniServer == null) {
            this.logger.warning("addFileReceivedEventListener failed to add a listener since miniServer == null. Call subscribe to initialise miniServer.");
            return false;
        }
        if (!JClient.miniServer.listOfFileReceivedEventListeners.add(fileReceivedEventListener)) {
            this.logger.warning("Error adding FileReceivedEventListener()");
            return false;
        }
        this.logger.info("Added FileReceivedEventListener");
        return true;
    }

    public Status archive(String string) {
        return this.archive(string, null, true);
    }

    public Status archive(String string, String string2) {
        return this.archive(string, string2, true);
    }

    public Status archive(String string, String string2, boolean bl) {
        File file = new File(string);
        if (!file.exists()) {
            this.logger.warning("Errror: the file you wish to send does not exist on your system. Error generated by archive in JClient.");
            return new Status(false, "Errror: the file you wish to send does not exist on your system. Error generated by archive in JClient.");
        }
        if (string2 == null) {
            String string3 = "Error: No content type specified.";
            this.logger.warning(string3);
            return new Status(false, string3);
        }
        return this._archive(string, string2, bl ? "1" : "0");
    }

    public Status archiveStream(InputStream inputStream, String string, String string2) {
        return this._ArchiveStream(inputStream, string, string2, "1");
    }

    public Status clone(String string) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("file_id", string);
        return this.sendSimpleCmd("CLONE", linkedHashMap);
    }

    public Status clone(String string, String string2) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("disk_id", string);
        linkedHashMap.put("file_id", string2);
        return this.sendSimpleCmd("CLONE", linkedHashMap);
    }

    public Status clone(String string, String string2, String string3) {
        if (string == null && string2 == null) {
            return new Status(false, "This combination of arguments is illegal, when calling the CLONE command. At least one of disk_id and file_id must be specified. Error generated by clone in JClient.");
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("disk_id", string);
        linkedHashMap.put("file_id", string2);
        linkedHashMap.put("file_version", string3);
        return this.sendSimpleCmd("CLONE", linkedHashMap);
    }

    public Status configStatus() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("configuration_file", null);
        return this.sendSimpleCmd("STATUS", linkedHashMap);
    }

    public Status diskStatus(String string) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("disk_id", string);
        return this.sendSimpleCmd("STATUS", linkedHashMap);
    }

    public Status exit() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        return this.sendSimpleCmd("EXIT", linkedHashMap);
    }

    public Status fileStatus(String string) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("file_id", string);
        return this.sendSimpleCmd("STATUS", linkedHashMap);
    }

    public Status flushLog() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("flush_log", null);
        return this.sendSimpleCmd("STATUS", linkedHashMap);
    }

    public boolean getMiniServerTakingFile() {
        if (miniServer != null) {
            return JClient.miniServer.takingFile;
        }
        return false;
    }

    public Status init() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        return this.sendSimpleCmd("INIT", linkedHashMap);
    }

    public Status label(String string) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("slot_id", string);
        return this.sendSimpleCmd("LABEL", linkedHashMap);
    }

    public Status label(String string, String string2) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("slot_id", string);
        linkedHashMap.put("host_id", string2);
        return this.sendSimpleCmd("LABEL", linkedHashMap);
    }

    public Status offline() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        return this.sendSimpleCmd("OFFLINE", linkedHashMap);
    }

    public Status offlineForce() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("force", null);
        return this.sendSimpleCmd("OFFLINE", linkedHashMap);
    }

    public Status online() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        return this.sendSimpleCmd("ONLINE", linkedHashMap);
    }

    private String prepareCommand(String string, LinkedHashMap<String, String> linkedHashMap) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (linkedHashMap.size() > 0) {
            stringBuilder.append("?");
            for (String string2 : linkedHashMap.keySet()) {
                String string3 = linkedHashMap.get(string2);
                stringBuilder.append(string2);
                if (string3 != null) {
                    stringBuilder.append("=");
                    stringBuilder.append(string3);
                }
                stringBuilder.append("&");
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        if (this.myProcessingParameters != null) {
            stringBuilder.append("&processing_pars=");
            stringBuilder.append(this.myProcessingParameters);
            this.myProcessingParameters = null;
        }
        return stringBuilder.toString();
    }

    public Status register(String string) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("path", string);
        return this.sendSimpleCmd("REGISTER", linkedHashMap);
    }

    public Status register(String string, String string2) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("path", string);
        linkedHashMap.put("mime_type", string2);
        return this.sendSimpleCmd("REGISTER", linkedHashMap);
    }

    public Status remdisk(String string, boolean bl) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("disk_id", string);
        linkedHashMap.put("execute", bl ? "1" : "0");
        return this.sendSimpleCmd("REMDISK", linkedHashMap);
    }

    public Status remfile(String string, boolean bl) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("file_id", string);
        linkedHashMap.put("execute", bl ? "1" : "0");
        return this.sendSimpleCmd("REMFILE", linkedHashMap);
    }

    public Status remfile(String string, String string2, boolean bl) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("disk_id", string);
        linkedHashMap.put("file_id", string2);
        linkedHashMap.put("execute", bl ? "1" : "0");
        return this.sendSimpleCmd("REMFILE", linkedHashMap);
    }

    public Status remfile(String string, String string2, String string3, boolean bl) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("disk_id", string);
        linkedHashMap.put("file_id", string2);
        linkedHashMap.put("file_version", string3);
        linkedHashMap.put("execute", bl ? "1" : "0");
        return this.sendSimpleCmd("REMFILE", linkedHashMap);
    }

    public boolean removeFileReceivedEventListener(FileReceivedEventListener fileReceivedEventListener) {
        if (miniServer == null) {
            this.logger.warning("removeFileReceivedEventListener failed to remove a listener since miniServer == null. Call subscribe to initialise miniServer.");
            return false;
        }
        JClient.miniServer.listOfFileReceivedEventListeners.removeElement(fileReceivedEventListener);
        this.logger.info("removed FileReceivedEventListener");
        return true;
    }

    public Status retrieve(String string, String string2) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("file_id", string);
        String string3 = this.prepareCommand("RETRIEVE", linkedHashMap);
        return this._Retrieve(string3, string2);
    }

    public Status retrieve(String string, String string2, String string3) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("file_id", string);
        linkedHashMap.put("file_version", string2);
        String string4 = this.prepareCommand("RETRIEVE", linkedHashMap);
        return this._Retrieve(string4, string3);
    }

    public Status retrieve(String string, String string2, String string3, String string4) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("file_id", string);
        linkedHashMap.put("file_version", string2);
        linkedHashMap.put("internal", string3);
        String string5 = this.prepareCommand("RETRIEVE", linkedHashMap);
        return this._Retrieve(string5, string4);
    }

    public Status retrieveInternal(String string, String string2, String string3) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("file_id", string);
        linkedHashMap.put("internal", string2);
        String string4 = this.prepareCommand("RETRIEVE", linkedHashMap);
        return this._Retrieve(string4, string3);
    }

    public Status retrieveLog(String string, String string2) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("file_id", string);
        linkedHashMap.put("ng_log", null);
        String string3 = this.prepareCommand("RETRIEVE", linkedHashMap);
        return this._Retrieve(string3, string2);
    }

    public Status retrieveStream(String string, OutputStream outputStream) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("file_id", string);
        String string2 = this.prepareCommand("RETRIEVE", linkedHashMap);
        return this._RetrieveStream(string2, outputStream);
    }

    public Status retrieveStream(String string, String string2, OutputStream outputStream) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("file_id", string);
        linkedHashMap.put("file_version", string2);
        String string3 = this.prepareCommand("RETRIEVE", linkedHashMap);
        return this._RetrieveStream(string3, outputStream);
    }

    public Status retrieveStream(String string, String string2, String string3, OutputStream outputStream) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("file_id", string);
        linkedHashMap.put("file_version", string2);
        linkedHashMap.put("internal", string3);
        String string4 = this.prepareCommand("RETRIEVE", linkedHashMap);
        return this._RetrieveStream(string4, outputStream);
    }

    public void setProcessingParameters(String string) {
        this.myProcessingParameters = string;
    }

    private Status sendSimpleCmd(String string, LinkedHashMap<String, String> linkedHashMap) {
        return this.sendSimpleCmd(string, linkedHashMap, false);
    }

    private Status sendSimpleCmd(String string, LinkedHashMap<String, String> linkedHashMap, boolean bl) {
        try {
            String string2 = this.prepareCommand(string, linkedHashMap);
            HttpURLConnection httpURLConnection = this.myConnectionManager.getConnection(string2);
            int n = httpURLConnection.getResponseCode();
            String string3 = httpURLConnection.getResponseMessage();
            InputStream inputStream = httpURLConnection.getInputStream();
            if (n != 200) {
                inputStream = httpURLConnection.getErrorStream();
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string4 = null;
            String string5 = "";
            while ((string4 = bufferedReader.readLine()) != null) {
                string5 = string5 + string4 + "\n";
            }
            bufferedReader.close();
            httpURLConnection.disconnect();
            if (n == 200) {
                String string6 = "Succesfully sent the following command to NGAS, via HTTP GET: ";
                string6 = string6 + string2;
                this.logger.info(string6);
            } else {
                String string7 = "Error sending the following command to NGAS, via HTTP GET: ";
                string7 = string7 + string2;
                string7 = string7 + "For more information on the error, consult the instance of Status ";
                string7 = string7 + "returned by this method.";
                this.logger.warning(string7);
            }
            return new Status(n, string3, string5, this.dataRaw + "ngams.xml", this.logger);
        }
        catch (IOException iOException) {
            return new Status(false, "Error generated by sendSimpleCmd in JClient. Description: " + iOException.toString());
        }
    }

    public Status status() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        return this.sendSimpleCmd("STATUS", linkedHashMap);
    }

    public Status subscribe(String string, String string2, String string3, String string4, String string5) {
        if (string5 == null) {
            this.logger.info("The call to JClient.subscribe speficified the URL parameter as null. Using default url: " + this.url);
            string5 = this.url;
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("filter_plug_in", string);
        linkedHashMap.put("plug_in_pars", string2);
        linkedHashMap.put("priority", string3);
        linkedHashMap.put("start_date", string4);
        linkedHashMap.put("url", string5);
        miniServer = new MiniServer(this.miniServerPort, 1024, this.dataRaw, this.logger);
        Thread thread = new Thread(miniServer);
        thread.start();
        while (!JClient.miniServer.ready) {
        }
        if (!this.subscribed && string5.equals(this.url)) {
            this.subscribed = true;
            return this.sendSimpleCmd("SUBSCRIBE", linkedHashMap);
        }
        if (!string5.equals(this.url)) {
            this.logger.info("the call to JClient.subscribe refers to a URL: " + string5 + " which is different from the default URL: " + this.url);
            return this.sendSimpleCmd("SUBSCRIBE", linkedHashMap);
        }
        String string6 = "The call to JClient.subscribe either specified the parameter URL as null (meaning the default value: " + this.url + " is used) or explicitly passed parameter URL as " + this.url + ". But this URL has previously subscribed to " + "NGAS. A second subscribe command has NOT been sent. You can " + "find out whether the miniServer was receiving a file when " + " this error message was generated by calling " + "status.getReceivingFile() where status is the object " + "returned by this method. At any other time you can find " + "out whether the miniServer is taking a file by calling " + "JClient.getMiniServerTakingFile().";
        this.logger.warning(string6);
        return new Status(true, string6);
    }

    public Status unsubscribe(String string) {
        if (string == null) {
            this.logger.info("URL specified as null in call to JClient.unsubscribe. Using default: " + this.url);
            string = this.url;
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("url", string);
        if (miniServer != null) {
            JClient.miniServer.serve = false;
        }
        if (this.subscribed && string.equals(this.url)) {
            this.subscribed = false;
            return this.sendSimpleCmd("UNSUBSCRIBE", linkedHashMap, JClient.miniServer.takingFile);
        }
        if (!string.equals(this.url)) {
            this.logger.info("the call to JClient.unsubscribe specifies a url " + string + " different to the default url: " + this.url);
            return this.sendSimpleCmd("UNSUBSCRIBE", linkedHashMap, JClient.miniServer.takingFile);
        }
        String string2 = "The call to JClient.unsubscribe either specified the parameter url as null (meaning the default value: " + this.url + "is used) or explicitly passed parameter URL as " + this.url + ". But this URK is NOT currently subscribed to " + "NGAS. An unnecessary UNSUBSCRIBE command has NOT been sent " + "to NGAS. You can find out whether the miniServer was " + "receiving a file when this error message was generated by " + "calling status.getReceivingFile() where status is the " + "object returned by this method. At any other time you can " + "find out whether the miniServer is taking a file by " + "calling JClient.getMiniServerTakingFile().";
        this.logger.warning(string2);
        return new Status(true, string2);
    }
}

