/*
 * Decompiled with CFR 0.152.
 */
package alma.ngas.client;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ConnectionManager {
    private static final long TIMEOUT = 600000L;
    private static ConnectionManager instance;
    private LinkedHashMap<InetSocketAddress, Date> myConnectionMap = new LinkedHashMap();
    private Iterator<Map.Entry<InetSocketAddress, Date>> myConnectionIterator;
    private long retryTime = 600000L;
    private Logger logger;

    private ConnectionManager() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized HttpURLConnection getConnection(String string) throws IOException {
        URL uRL = null;
        HttpURLConnection httpURLConnection = null;
        if (this.myConnectionMap.size() == 0) {
            throw new IOException("The connections to use has not been defined.");
        }
        HttpURLConnection.setFollowRedirects(true);
        int n = 0;
        int n2 = 0;
        InetSocketAddress inetSocketAddress = null;
        int n3 = 0;
        boolean bl = false;
        block2: while (!bl) {
            Map.Entry<InetSocketAddress, Date> entry;
            Date date;
            if (++n3 > this.myConnectionMap.size()) {
                throw new IOException("There are currently no working NGAS servers available.");
            }
            if (!this.myConnectionIterator.hasNext()) {
                this.myConnectionIterator = this.myConnectionMap.entrySet().iterator();
            }
            if ((date = (entry = this.myConnectionIterator.next()).getValue()) != null) {
                if (System.currentTimeMillis() <= date.getTime() + this.retryTime) continue;
                if (this.logger != null) {
                    this.logger.info("Connection " + entry.getKey() + " will now be attempted again after a retry time of " + this.retryTime + " milliseconds.");
                }
                entry.setValue(null);
            }
            inetSocketAddress = entry.getKey();
            String string2 = inetSocketAddress.getHostName();
            int n4 = inetSocketAddress.getPort();
            try {
                block3: while (true) {
                    if (bl) continue block2;
                    uRL = new URL("http", string2, n4, string);
                    httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.setRequestMethod("GET");
                    httpURLConnection.connect();
                    n = httpURLConnection.getResponseCode();
                    if (n > 300 && n < 304) {
                        Object object;
                        String string3;
                        if (++n2 > 20) {
                            throw new IOException("More than 20 redirects have been peformed. This indicates an infinite loop. The last address tried was " + string2 + ":" + n4);
                        }
                        Map<String, List<String>> map = httpURLConnection.getHeaderFields();
                        Iterator<String> iterator = map.keySet().iterator();
                        do {
                            if (!iterator.hasNext()) continue block3;
                        } while (!"Location".equalsIgnoreCase(string3 = iterator.next()));
                        String string4 = map.get(string3).get(0);
                        if (string4.startsWith("http://")) {
                            object = string4.replaceAll("http://", "");
                            String[] stringArray = ((String)object).split("/");
                            string4 = stringArray[0];
                        }
                        object = string4.split(":");
                        string2 = object[0];
                        if (((Object)object).length <= 1) continue;
                        n4 = Integer.parseInt((String)object[1]);
                        continue;
                    }
                    bl = true;
                }
            }
            catch (IOException iOException) {
                if (this.logger != null) {
                    this.logger.warning("Connection " + inetSocketAddress + " is considered broke and will be attempted again after a retry time of " + this.retryTime + " milliseconds.");
                }
                this.myConnectionMap.put(inetSocketAddress, new Date());
                continue;
            }
            break;
        }
        return httpURLConnection;
    }

    public static synchronized ConnectionManager getInstance() {
        if (instance == null) {
            instance = new ConnectionManager();
        }
        return instance;
    }

    public synchronized void setConnectionList(List<InetSocketAddress> list) {
        if (list == null) {
            throw new IllegalArgumentException("The supplied connection list may not be null.");
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("The supplied connection list may not be empty.");
        }
        this.myConnectionMap = new LinkedHashMap();
        for (InetSocketAddress inetSocketAddress : list) {
            this.myConnectionMap.put(inetSocketAddress, null);
        }
        this.myConnectionIterator = this.myConnectionMap.entrySet().iterator();
    }

    public synchronized void setLogger(Logger logger) {
        this.logger = logger;
    }

    public synchronized void setRetryTime(long l) {
        this.retryTime = l;
    }
}

