/*
 * Decompiled with CFR 0.152.
 */
package ahc.util.string.sprintf;

import ahc.util.string.sprintf.SPrintfHandler;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

abstract class NumberHandler
implements SPrintfHandler {
    protected final DecimalFormat _nf;

    public NumberHandler() {
        this._nf = null;
    }

    public NumberHandler(boolean hasThousandsSeparator, int numDecimals, boolean hasPositiveSign, boolean hasSpaceSign) {
        String patternNoSign = this.getPatternPre(hasThousandsSeparator) + this.getPatternDecimals(numDecimals);
        String posPattern = (hasPositiveSign ? "+" : (hasSpaceSign ? " " : "")) + patternNoSign;
        String pattern = posPattern + ";-" + patternNoSign;
        this._nf = new DecimalFormat(pattern, new DecimalFormatSymbols(Locale.US));
    }

    private String getPatternPre(boolean hasThousandsSeparator) {
        return hasThousandsSeparator ? "#,##0" : "0";
    }

    private String getPatternDecimals(int numDecimals) {
        if (numDecimals == 0) {
            return "";
        }
        if (numDecimals < 0) {
            return ".####################";
        }
        StringBuffer result = new StringBuffer();
        while (result.length() < numDecimals) {
            result.append("0000000000");
        }
        return "." + result.toString().substring(0, numDecimals);
    }

    public boolean hasParameter() {
        return true;
    }

    public String handle(Object o) {
        if (this._nf == null || o == null) {
            return "" + o;
        }
        return this._nf.format(o);
    }
}

