/*
 * Decompiled with CFR 0.152.
 */
package ahc.util.string.sprintf;

import ahc.util.string.sprintf.FlagParser;
import ahc.util.string.sprintf.PaddingWrapper;
import ahc.util.string.sprintf.SPrintfHandler;
import ahc.util.string.sprintf.SPrintfHandlerType;
import java.util.HashSet;
import java.util.Set;

abstract class AbstractHandlerType
implements SPrintfHandlerType {
    private final Set _conversionChars = new HashSet();

    protected AbstractHandlerType(String ch) {
        for (int i = 0; i < ch.length(); ++i) {
            this._conversionChars.add(new Character(ch.charAt(i)));
        }
    }

    public int numPatternChars(String pattern) {
        if (this.isDefaultPattern(pattern)) {
            return 2;
        }
        FlagParser fp = new FlagParser(pattern);
        if (pattern.length() <= fp.indConversionSpecifier() || !this._conversionChars.contains(new Character(pattern.charAt(fp.indConversionSpecifier())))) {
            return 0;
        }
        return fp.indConversionSpecifier() + 1;
    }

    private boolean isDefaultPattern(String pattern) {
        return pattern.length() >= 2 && pattern.startsWith("%") && this._conversionChars.contains(new Character(pattern.charAt(1)));
    }

    public SPrintfHandler getHandler(String pattern) {
        if (this.isDefaultPattern(pattern)) {
            return this.getDefaultHandler();
        }
        FlagParser flags = new FlagParser(pattern);
        return new PaddingWrapper(this.getHandler(flags), flags.isLeftJustified(), flags.minWidth(), flags.hasZeroPadding());
    }

    protected abstract SPrintfHandler getDefaultHandler();

    protected abstract SPrintfHandler getHandler(FlagParser var1);
}

