/*
 * Decompiled with CFR 0.152.
 */
package ahc.util.string;

import ahc.util.string.AttribIterator;
import ahc.util.string.StringHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ToStringDumper
extends AttribIterator {
    private final List _result = new ArrayList();
    private final boolean _escapeStrings;

    public ToStringDumper(boolean filterStatic, boolean filterTransient, boolean alwaysUseToStringImpl, boolean collectionsAsPrimitives, boolean javaLangAsPrimitives, boolean escapeStrings) {
        super(filterStatic, filterTransient, alwaysUseToStringImpl, collectionsAsPrimitives, javaLangAsPrimitives);
        this._escapeStrings = escapeStrings;
    }

    protected void handlePre(Object obj) {
        if (obj != null) {
            this._result.add("{" + this.getSimpleName(obj.getClass().getName()) + ": ");
        }
    }

    protected void handlePost(Object obj) {
        if (obj != null) {
            this._result.add("}");
        }
    }

    protected void handlePreCollection(Object o) {
        if (o != null) {
            this._result.add("[");
        }
    }

    protected void handlePostCollection(Object o) {
        if (o != null) {
            this._result.add("]");
        }
    }

    protected void handleNode(Object obj) {
        if (this._escapeStrings && obj instanceof String) {
            obj = StringHelper.escape((String)obj);
        }
        this._result.add("" + obj);
    }

    protected void handleEnumSeparator() {
        this._result.add(", ");
    }

    protected void handleMapArrow() {
        this._result.add("->");
    }

    protected void handleField(Field field) {
        this._result.add(this.getSimpleName(field.getName()) + "=");
    }

    protected void handleCycleDef(Object obj) {
        this._result.add(new CycleDefProxy(obj));
    }

    protected void handleCycleRef(Object obj) {
        this._result.add("<" + this.getCycleNo(obj) + ">");
    }

    protected void handleObject(Object obj) {
    }

    public String genericToString(Object o, int maxDepth) {
        if (this._result.size() > 0) {
            throw new IllegalStateException("Each instance of ToStringDumper can be used only once");
        }
        this.handleGeneric(o, maxDepth);
        StringBuffer result = new StringBuffer();
        Iterator iter = this._result.iterator();
        while (iter.hasNext()) {
            result.append(iter.next());
        }
        return result.toString();
    }

    String getSimpleName(String fullyQualified) {
        int lastDot = fullyQualified.lastIndexOf(46);
        if (lastDot == -1) {
            return fullyQualified;
        }
        return fullyQualified.substring(lastDot + 1);
    }

    private class CycleDefProxy {
        private final Object _obj;

        public CycleDefProxy(Object obj) {
            this._obj = obj;
        }

        public String toString() {
            if (ToStringDumper.this.isCycle(this._obj)) {
                return "<" + ToStringDumper.this.getCycleNo(this._obj) + ">";
            }
            return "";
        }
    }
}

