/*
 * Decompiled with CFR 0.152.
 */
package ahc.util;

import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateDay
implements Comparable,
Serializable {
    private final int _day;
    private final int _month;
    private final int _year;
    private static final int[] MIN_NUM_DAYS_IN_MONTH = new int[]{-1, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] MAX_NUM_DAYS_IN_MONTH = new int[]{-1, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int NUM_MONTHS = 12;

    private DateDay(int day, int month, int year) {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("illegal month " + month + ", must be in range from 1 to 12");
        }
        if (day < 1 || day > DateDay.numDays(month, year)) {
            throw new IllegalArgumentException("illegal day " + day + " for month " + month + " in year " + year + ".");
        }
        this._day = day;
        this._month = month;
        this._year = year;
    }

    public static DateDay create(int day, int month, int year) {
        return new DateDay(day, month, year);
    }

    public static DateDay create(Date date, TimeZone timezone) {
        if (date == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar(timezone);
        cal.setTime(date);
        return new DateDay(cal.get(5), cal.get(2) + 1, cal.get(1));
    }

    public static DateDay create(Date date) {
        return DateDay.create(date, TimeZone.getDefault());
    }

    public int getDay() {
        return this._day;
    }

    public int getMonth() {
        return this._month;
    }

    public int getYear() {
        return this._year;
    }

    public DateDay setDay(int day) {
        return DateDay.create(day, this._month, this._year);
    }

    public DateDay setMonth(int month) {
        return DateDay.create(this._day, month, this._year);
    }

    public DateDay setYear(int year) {
        return DateDay.create(this._day, this._month, year);
    }

    public Date asDate() {
        return this.asDate(TimeZone.getDefault());
    }

    public Date asDate(TimeZone timeZone) {
        GregorianCalendar cal = new GregorianCalendar(timeZone);
        cal.clear();
        cal.set(5, this._day);
        cal.set(2, this._month - 1);
        cal.set(1, this._year);
        return cal.getTime();
    }

    public int compareTo(Object o) {
        DateDay other = (DateDay)o;
        if (other._year != this._year) {
            return this._year - other._year;
        }
        if (other._month != this._month) {
            return this._month - other._month;
        }
        return this._day - other._day;
    }

    public boolean before(DateDay other) {
        return this.compareTo(other) < 0;
    }

    public boolean after(DateDay other) {
        return this.compareTo(other) > 0;
    }

    public static boolean isLeapYear(int year) {
        if (year % 4 != 0) {
            return false;
        }
        if (year % 400 == 0) {
            return true;
        }
        return year % 100 != 0;
    }

    public static int numDays(int month, int year) {
        return DateDay.isLeapYear(year) ? MAX_NUM_DAYS_IN_MONTH[month] : MIN_NUM_DAYS_IN_MONTH[month];
    }

    public DateDay incDay() {
        return this.normalizedDay(this._day + 1, this._month, this._year);
    }

    public DateDay incDay(int num) {
        return this.normalizedDay(this._day + num, this._month, this._year);
    }

    private DateDay normalizedDay(int day, int month, int year) {
        if (month <= 0) {
            return this.normalizedDay(day, month + 12, year - 1);
        }
        if (month > 12) {
            return this.normalizedDay(day, month - 12, year + 1);
        }
        if (day > DateDay.numDays(month, year)) {
            return this.normalizedDay(day - DateDay.numDays(month, year), month + 1, year);
        }
        if (day <= 0) {
            if (--month == 0) {
                month = 12;
                --year;
            }
            return this.normalizedDay(day + DateDay.numDays(month, year), month, year);
        }
        return DateDay.create(day, month, year);
    }

    private DateDay normalizedMonth(int day, int month, int year, boolean roundLater) {
        while (month < 1) {
            month += 12;
            --year;
        }
        while (month > 12) {
            month -= 12;
            ++year;
        }
        if (day <= DateDay.numDays(month, year)) {
            return DateDay.create(day, month, year);
        }
        return roundLater ? this.normalizedDay(1, month + 1, year) : DateDay.create(DateDay.numDays(month, year), month, year);
    }

    public DateDay decDay() {
        return this.normalizedDay(this._day - 1, this._month, this._year);
    }

    public DateDay decDay(int num) {
        return this.normalizedDay(this._day - num, this._month, this._year);
    }

    public DateDay incMonth(boolean roundLater) {
        return this.incMonth(1, roundLater);
    }

    public DateDay incMonth(int num, boolean roundLater) {
        return this.normalizedMonth(this._day, this._month + num, this._year, roundLater);
    }

    public DateDay decMonth(boolean roundLater) {
        return this.decMonth(1, roundLater);
    }

    public DateDay decMonth(int num, boolean roundLater) {
        return this.normalizedMonth(this._day, this._month - num, this._year, roundLater);
    }

    public DateDay incYear(boolean roundLater) {
        return this.incYear(1, roundLater);
    }

    public DateDay incYear(int num, boolean roundLater) {
        return this.normalizedMonth(this._day, this._month, this._year + num, roundLater);
    }

    public DateDay decYear(boolean roundLater) {
        return this.decYear(1, roundLater);
    }

    public DateDay decYear(int num, boolean roundLater) {
        return this.normalizedMonth(this._day, this._month, this._year - num, roundLater);
    }

    public String toString() {
        return this.asDate().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DateDay)) {
            return false;
        }
        DateDay dateDay = (DateDay)o;
        if (this._day != dateDay._day) {
            return false;
        }
        if (this._month != dateDay._month) {
            return false;
        }
        return this._year == dateDay._year;
    }

    public int hashCode() {
        int result = this._day;
        result = 29 * result + this._month;
        result = 29 * result + this._year;
        return result;
    }
}

