/*
 * Decompiled with CFR 0.152.
 */
package ahc.jdbc.connectionpool;

import ahc.jdbc.connectionpool.AbstractConnectionPool;
import ahc.jdbc.connectionpool.ConnectionPoolException;
import ahc.jdbc.connectionpool.ConnectionValidator;
import ahc.jdbc.connectionpool.NullConnectionValidator;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;

public class ConnectionPool
extends AbstractConnectionPool {
    private final String _url;
    private final String _user;
    private final String _password;
    private Driver _driver;

    public ConnectionPool(int initialSize, String url, Class driverClass, String user, String password) throws ConnectionPoolException {
        this(initialSize, url, driverClass, user, password, NullConnectionValidator.INSTANCE);
    }

    public ConnectionPool(int initialSize, String url, Class driverClass, String user, String password, ConnectionValidator validator) throws ConnectionPoolException {
        super(initialSize, validator);
        this._url = url;
        this._user = user;
        this._password = password;
        try {
            this._driver = (Driver)driverClass.newInstance();
        }
        catch (Exception e) {
            throw new ConnectionPoolException("Can not instantiate driver");
        }
    }

    protected Connection createConnection() throws ConnectionPoolException, SQLException {
        Properties loginProps = new Properties();
        loginProps.put("user", this._user);
        loginProps.put("password", this._password);
        return this._driver.connect(this._url, loginProps);
    }
}

