/*
 * Decompiled with CFR 0.152.
 */
package ahc.jdbc.connectionpool;

import ahc.jdbc.connectionpool.ConnectionPoolException;
import ahc.jdbc.connectionpool.ConnectionValidator;
import ahc.jdbc.connectionpool.NullConnectionValidator;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractConnectionPool {
    private final Object _lock = new Object();
    private final int _size;
    private final List _pooledConnections = new ArrayList();
    private int _numConnectionsInUse = 0;
    private final ConnectionValidator _validator;
    private boolean _isClosed = false;
    static /* synthetic */ Class class$java$sql$Connection;

    public AbstractConnectionPool(int initialSize) {
        this(initialSize, NullConnectionValidator.INSTANCE);
    }

    public AbstractConnectionPool(int initialSize, ConnectionValidator validator) {
        this._size = initialSize;
        this._validator = validator;
    }

    public void addShutdownHookForClose() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                AbstractConnectionPool.this.close();
            }
        });
    }

    protected abstract Connection createConnection() throws ConnectionPoolException, SQLException;

    private Connection createValidConnection() throws ConnectionPoolException, SQLException {
        Connection result = this.createConnection();
        if (!this._validator.isValid(result)) {
            throw new ConnectionPoolException("Created connection is invalid");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException, ConnectionPoolException {
        Object object = this._lock;
        synchronized (object) {
            if (this._isClosed) {
                throw new ConnectionPoolException("This pool was closed.");
            }
            this.refillPool();
            this.checkConnectionAvailability();
            Connection inner = (Connection)this._pooledConnections.remove(0);
            if (!this._validator.isValid(inner)) {
                inner = this.createValidConnection();
            }
            ++this._numConnectionsInUse;
            return (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{class$java$sql$Connection == null ? (class$java$sql$Connection = AbstractConnectionPool.class$("java.sql.Connection")) : class$java$sql$Connection}, (InvocationHandler)new ConnectionInvocationHandler(inner));
        }
    }

    private void checkConnectionAvailability() throws ConnectionPoolException {
        if (this._pooledConnections.isEmpty()) {
            throw new ConnectionPoolException("Connection pool is empty");
        }
    }

    private void refillPool() throws ConnectionPoolException, SQLException {
        while (this._numConnectionsInUse + this._pooledConnections.size() < this._size) {
            this._pooledConnections.add(this.createValidConnection());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this._lock;
        synchronized (object) {
            Iterator iter = this._pooledConnections.iterator();
            while (iter.hasNext()) {
                Connection conn = (Connection)iter.next();
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
            this._pooledConnections.clear();
            this._isClosed = true;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ConnectionInvocationHandler
    implements InvocationHandler {
        private final Connection _inner;
        private boolean _isOpen = true;

        public ConnectionInvocationHandler(Connection inner) {
            this._inner = inner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (!this._isOpen) {
                throw new ConnectionPoolException("attempt to use closed connection");
            }
            if (method.getName().equals("close") && (args == null || args.length == 0)) {
                this._isOpen = false;
                Object object = AbstractConnectionPool.this._lock;
                synchronized (object) {
                    AbstractConnectionPool.this._pooledConnections.add(this._inner);
                    AbstractConnectionPool.this._numConnectionsInUse--;
                }
                return null;
            }
            return method.invoke((Object)this._inner, args);
        }

        protected void finalize() throws Throwable {
            if (this._isOpen) {
                AbstractConnectionPool.this._numConnectionsInUse--;
                this._inner.close();
            }
            super.finalize();
        }
    }
}

