/*
 * Decompiled with CFR 0.152.
 */
package ahc.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class FileWatcher {
    private long _lastRead = 0L;
    private long _lastModified = 0L;
    private Object _cached = null;
    private final File _file;
    private final long _minRereadInterval;

    public FileWatcher(String filename) {
        this(filename, 1000L);
    }

    public FileWatcher(String filename, long minRereadInterval) {
        this._file = new File(filename);
        this._minRereadInterval = minRereadInterval;
    }

    public synchronized Object getData() throws IOException {
        long now = System.currentTimeMillis();
        if (this._cached == null || now - this._lastRead > this._minRereadInterval && this._lastModified != this._file.lastModified()) {
            this._lastRead = now;
            this._lastModified = this._file.lastModified();
            this._cached = this.read(new BufferedInputStream(new FileInputStream(this._file)));
        }
        return this._cached;
    }

    protected abstract Object read(InputStream var1) throws IOException;
}

