/*
 * Decompiled with CFR 0.152.
 */
package ahc.generic.classloader;

import ahc.util.bytes.ByteArray;

abstract class MethodForClassFile {
    private static final int ACCESS_PUBLIC = 1;
    private final int _indName;
    private final int _indSignature;
    private final int _maxStack;
    private final int _numLocals;
    private final int _indCodeAtt;

    protected MethodForClassFile(int indName, int indSignature, int maxStack, int numLocals, int indCodeAtt) {
        this._indName = indName;
        this._indSignature = indSignature;
        this._maxStack = maxStack;
        this._numLocals = numLocals;
        this._indCodeAtt = indCodeAtt;
    }

    public byte[] asBytes() {
        ByteArray result = new ByteArray();
        result.addInt16(1);
        result.addInt16(this._indName);
        result.addInt16(this._indSignature);
        result.addInt16(1);
        result.addInt16(this._indCodeAtt);
        ByteArray body = this.getBody();
        result.addInt32(8 + body.getSize() + 2 + 2);
        result.addInt16(this._maxStack);
        result.addInt16(this._numLocals);
        result.addInt32(this.getBody().getSize());
        result.add(body);
        result.addInt16(0);
        result.addInt16(0);
        return result.asBytes();
    }

    protected abstract ByteArray getBody();
}

