/*
 * Decompiled with CFR 0.152.
 */
package ahc.generic.classloader;

import ahc.collection.DoubleKeyCache;
import ahc.exception.TunnelingException;
import ahc.generic.AttributeGetter;
import ahc.generic.classloader.GetterDynAttribClassLoader;
import ahc.generic.classloader.internal.SingleAttributeGetter;

public class ClassLoaderAttributeGetter
implements AttributeGetter {
    private final DoubleKeyCache _cache = new DoubleKeyCache(){

        protected Object createNew(Object key1, Object key2) {
            try {
                Class cls = (Class)key1;
                String accesspath = (String)key2;
                GetterDynAttribClassLoader cl = new GetterDynAttribClassLoader(cls);
                Class<?> resultCls = cl.loadClass(accesspath);
                return resultCls.newInstance();
            }
            catch (Exception e) {
                throw TunnelingException.create(e);
            }
        }
    };

    public Object get(Object obj, String accesspath) {
        try {
            return ((SingleAttributeGetter)this._cache.get(obj.getClass(), accesspath)).getValue(obj);
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("access path '" + accesspath + "' is not accessible for this object.");
        }
    }
}

