/*
 * Decompiled with CFR 0.152.
 */
package ahc.collection.store;

import ahc.collection.Iterator;
import ahc.collection.equality.EqualityStrategy;
import ahc.collection.store.AbstractStore;
import ahc.collection.store.Store;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;

public class DlinkedStore
extends AbstractStore {
    private final Entry _before = new Entry(null, null, null);
    private final Entry _after = new Entry(null, null, null);
    private int _size = 0;
    private int _modCount = 0;

    public DlinkedStore(EqualityStrategy eqStrat) {
        super(eqStrat);
        this._before._next = this._after;
        this._after._prev = this._before;
    }

    public boolean preservesOrdering() {
        return true;
    }

    public boolean isSorted() {
        return false;
    }

    public void prepend(Object o) {
        Entry newElement;
        this._before._next._prev = newElement = new Entry(o, this._before, this._before._next);
        this._before._next = newElement;
        ++this._size;
        ++this._modCount;
    }

    public void append(Object o) {
        Entry newElement;
        this._after._prev._next = newElement = new Entry(o, this._after._prev, this._after);
        this._after._prev = newElement;
        ++this._size;
        ++this._modCount;
    }

    public Object get(int index) {
        return this.entry((int)index)._element;
    }

    public int size() {
        return this._size;
    }

    public void clear() {
        this._before._next = this._after;
        this._after._prev = this._before;
        this._size = 0;
    }

    private Entry entry(int ind) {
        if (ind <= this._size / 2) {
            Entry entry = this._before;
            for (int i = 0; i <= ind; ++i) {
                entry = entry._next;
            }
            return entry;
        }
        Entry entry = this._after;
        for (int i = 0; i < this._size - ind; ++i) {
            entry = entry._prev;
        }
        return entry;
    }

    public Iterator iter(int ind) {
        return new Itr(this.entry(ind), ind);
    }

    public Iterator before() {
        return new Itr(this._before, -1);
    }

    public Iterator begin() {
        return new Itr(this._before._next, 0);
    }

    public Iterator end() {
        return new Itr(this._after._prev, this.size() - 1);
    }

    public Iterator after() {
        return new Itr(this._after, this.size());
    }

    public void compactSize() {
    }

    public Store cloneEmpty() {
        return new DlinkedStore(this._eqStrat);
    }

    private class Itr
    implements Iterator {
        Entry _curPos;
        int _expectedModCount;
        int _curIndex;

        public Itr(Entry curPos, int curIndex) {
            this._curPos = DlinkedStore.this._before;
            this._expectedModCount = DlinkedStore.this._modCount;
            this._curPos = curPos;
            this._curIndex = curIndex;
        }

        public void add(Object o) {
            Entry newElement;
            if (this._curPos == DlinkedStore.this._before) {
                throw new NoSuchElementException();
            }
            this.checkCoModification();
            this._curPos._prev._next = newElement = new Entry(o, this._curPos._prev, this._curPos);
            this._curPos._prev = newElement;
            ++this._curIndex;
            DlinkedStore.this._size++;
            DlinkedStore.this._modCount++;
            this._expectedModCount = DlinkedStore.this._modCount;
        }

        public boolean hasCurrent() {
            return this._curPos != DlinkedStore.this._after && this._curPos != DlinkedStore.this._before;
        }

        public Object current() {
            this.checkRange();
            this.checkCoModification();
            return this._curPos._element;
        }

        public int currentIndex() {
            return this._curIndex;
        }

        public boolean replace(Object o) {
            this.checkRange();
            this.checkCoModification();
            this._curPos._element = o;
            DlinkedStore.this._modCount++;
            this._expectedModCount = DlinkedStore.this._modCount;
            return true;
        }

        public void set(Object o) {
            this.replace(o);
        }

        public boolean hasNext() {
            return this._curPos._next != DlinkedStore.this._after && this._curPos != DlinkedStore.this._after;
        }

        public Object next() {
            this._curPos = this._curPos._next;
            ++this._curIndex;
            return this.hasCurrent() ? this.current() : null;
        }

        public Object next(int n) {
            for (int i = 0; i < n; ++i) {
                this.next();
            }
            return this.hasCurrent() ? this.current() : null;
        }

        public int nextIndex() {
            return this._curIndex + 1;
        }

        public boolean hasPrevious() {
            return this._curPos._prev != DlinkedStore.this._before && this._curPos != DlinkedStore.this._before;
        }

        public Object previous() {
            this._curPos = this._curPos._prev;
            --this._curIndex;
            return this.hasCurrent() ? this.current() : null;
        }

        public Object previous(int n) {
            for (int i = 0; i < n; ++i) {
                this.previous();
            }
            return this.hasCurrent() ? this.current() : null;
        }

        public int previousIndex() {
            return this._curIndex - 1;
        }

        public void remove() {
            this.checkRange();
            this.checkCoModification();
            this._curPos._prev._next = this._curPos._next;
            this._curPos._next._prev = this._curPos._prev;
            this._curPos = this._curPos._next;
            DlinkedStore.this._size--;
        }

        private void checkRange() {
            if (!this.hasCurrent()) {
                throw new NoSuchElementException();
            }
        }

        private void checkCoModification() {
            if (this._expectedModCount != DlinkedStore.this._modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class Entry {
        Object _element;
        Entry _prev;
        Entry _next;

        public Entry(Object element, Entry prev, Entry next) {
            this._element = element;
            this._prev = prev;
            this._next = next;
        }
    }
}

