/*
 * Decompiled with CFR 0.152.
 */
package ahc.collection;

import ahc.collection.EntryKeyComparator;
import ahc.collection.GenericMap;
import ahc.collection.GenericMultiMap;
import ahc.collection.Map;
import ahc.collection.MultiMap;
import ahc.collection.access.AccessStrategy;
import ahc.collection.access.GenericAccessStrategy;
import ahc.collection.equality.EqualityStrategy;
import ahc.collection.equality.EqualsEqualityStrategy;
import ahc.collection.equality.IdentityEqualityStrategy;
import ahc.collection.store.ArrayStore;
import ahc.collection.store.DlinkedStore;
import ahc.collection.store.HashStore;
import ahc.collection.store.Store;
import java.util.Comparator;

public class MultiMapHelper {
    public static final EqualityStrategy EQ_EQUALS = new EqualsEqualityStrategy();
    public static final EqualityStrategy EQ_IDENTITY = new IdentityEqualityStrategy();
    private static final AccessStrategy ACCESS_UNIQUE = GenericAccessStrategy.create(null, true);

    public static MultiMap createMultiMap() {
        return MultiMapHelper.createHashMultiMap();
    }

    public static MultiMap createArrayMultiMap() {
        return MultiMapHelper.createArrayMultiMap(EQ_EQUALS, ACCESS_UNIQUE);
    }

    public static MultiMap createArrayMultiMap(int initialSize) {
        return MultiMapHelper.createArrayMultiMap(EQ_EQUALS, ACCESS_UNIQUE, initialSize);
    }

    public static MultiMap createArrayMultiMap(EqualityStrategy eqStrat) {
        return MultiMapHelper.createArrayMultiMap(eqStrat, ACCESS_UNIQUE);
    }

    public static MultiMap createArrayMultiMap(EqualityStrategy eqStrat, int initialSize) {
        return MultiMapHelper.createArrayMultiMap(eqStrat, ACCESS_UNIQUE, initialSize);
    }

    public static MultiMap createArrayMultiMap(Comparator comp) {
        return MultiMapHelper.createArrayMultiMap(EQ_EQUALS, GenericAccessStrategy.create(new EntryKeyComparator(comp), true));
    }

    public static MultiMap createArrayMultiMap(Comparator comp, int initialSize) {
        return MultiMapHelper.createArrayMultiMap(EQ_EQUALS, GenericAccessStrategy.create(new EntryKeyComparator(comp), true), initialSize);
    }

    public static MultiMap createArrayMultiMap(AccessStrategy accessStrat) {
        return MultiMapHelper.createArrayMultiMap(EQ_EQUALS, accessStrat);
    }

    public static MultiMap createArrayMultiMap(AccessStrategy accessStrat, int initialSize) {
        return MultiMapHelper.createArrayMultiMap(EQ_EQUALS, accessStrat, initialSize);
    }

    public static MultiMap createArrayMultiMap(EqualityStrategy eqStrat, AccessStrategy accessStrat) {
        return MultiMapHelper.createMultiMap(new ArrayStore(eqStrat), accessStrat);
    }

    public static MultiMap createArrayMultiMap(EqualityStrategy eqStrat, AccessStrategy accessStrat, int initialSize) {
        return MultiMapHelper.createMultiMap(new ArrayStore(eqStrat, initialSize), accessStrat);
    }

    public static MultiMap createDlinkedMultiMap() {
        return MultiMapHelper.createDlinkedMultiMap(EQ_EQUALS, ACCESS_UNIQUE);
    }

    public static MultiMap createDlinkedMultiMap(EqualityStrategy eqStrat) {
        return MultiMapHelper.createDlinkedMultiMap(eqStrat, ACCESS_UNIQUE);
    }

    public static MultiMap createDlinkedMultiMap(Comparator comp) {
        return MultiMapHelper.createDlinkedMultiMap(EQ_EQUALS, GenericAccessStrategy.create(new EntryKeyComparator(comp), true));
    }

    public static MultiMap createDlinkedMultiMap(AccessStrategy accessStrat) {
        return MultiMapHelper.createDlinkedMultiMap(EQ_EQUALS, accessStrat);
    }

    public static MultiMap createDlinkedMultiMap(EqualityStrategy eqStrat, AccessStrategy accessStrat) {
        return MultiMapHelper.createMultiMap(new DlinkedStore(eqStrat), accessStrat);
    }

    public static MultiMap createHashMultiMap() {
        return MultiMapHelper.createHashMultiMap(EQ_EQUALS);
    }

    public static MultiMap createHashMultiMap(int initialSize) {
        return MultiMapHelper.createHashMultiMap(EQ_EQUALS, initialSize);
    }

    public static MultiMap createHashMultiMap(int initialSize, double loadFactor) {
        return MultiMapHelper.createHashMultiMap(EQ_EQUALS, initialSize, loadFactor);
    }

    public static MultiMap createHashMultiMap(EqualityStrategy eqStrat) {
        return MultiMapHelper.createHashMultiMap(eqStrat, ACCESS_UNIQUE);
    }

    public static MultiMap createHashMultiMap(EqualityStrategy eqStrat, int initialSize) {
        return MultiMapHelper.createHashMultiMap(eqStrat, ACCESS_UNIQUE, initialSize);
    }

    public static MultiMap createHashMultiMap(EqualityStrategy eqStrat, int initialSize, double loadFactor) {
        return MultiMapHelper.createHashMultiMap(eqStrat, ACCESS_UNIQUE, initialSize, loadFactor);
    }

    public static MultiMap createHashMultiMap(AccessStrategy accessStrat) {
        return MultiMapHelper.createHashMultiMap(EQ_EQUALS, accessStrat);
    }

    public static MultiMap createHashMultiMap(AccessStrategy accessStrat, int initialSize) {
        return MultiMapHelper.createHashMultiMap(EQ_EQUALS, accessStrat, initialSize);
    }

    public static MultiMap createHashMultiMap(AccessStrategy accessStrat, int initialSize, double loadFactor) {
        return MultiMapHelper.createHashMultiMap(EQ_EQUALS, accessStrat, initialSize, loadFactor);
    }

    public static MultiMap createHashMultiMap(EqualityStrategy eqStrat, AccessStrategy accessStrat) {
        return MultiMapHelper.createMultiMap(new HashStore(eqStrat), accessStrat);
    }

    public static MultiMap createHashMultiMap(EqualityStrategy eqStrat, AccessStrategy accessStrat, int initialSize) {
        return MultiMapHelper.createMultiMap(new HashStore(eqStrat, initialSize), accessStrat);
    }

    public static MultiMap createHashMultiMap(EqualityStrategy eqStrat, AccessStrategy accessStrat, int initialSize, double loadFactor) {
        return MultiMapHelper.createMultiMap(new HashStore(eqStrat, initialSize, loadFactor), accessStrat);
    }

    private static MultiMap createMultiMap(Store store, AccessStrategy accessStrat) {
        return MultiMapHelper.createMultiMap(new GenericMap(store, accessStrat));
    }

    public static MultiMap createMultiMap(Map map) {
        return new GenericMultiMap(map);
    }
}

