/*
 * Decompiled with CFR 0.152.
 */
package ahc.collection;

import ahc.collection.Iterator;
import ahc.collection.Queue;
import ahc.collection.access.AccessStrategy;
import ahc.collection.store.Store;
import ahc.exception.TimeoutException;
import ahc.util.SynchronizedGetCode;
import java.util.NoSuchElementException;

public class GenericQueue
implements Queue {
    private final Store _store;
    private final AccessStrategy _accessStrategy;
    private final boolean _isThreadSafe;
    final SynchronizedGetCode _removeCode;
    final SynchronizedGetCode _peekCode;

    public GenericQueue(Store store, AccessStrategy accessStrategy, boolean isThreadSafe) {
        if (!store.preservesOrdering()) {
            throw new IllegalArgumentException("the underlying store of a queue must preserve ordering");
        }
        this._store = store;
        this._accessStrategy = accessStrategy;
        this._isThreadSafe = isThreadSafe;
        this._removeCode = new SynchronizedGetCode(store){

            public boolean precondition() {
                return GenericQueue.this._store.size() > 0;
            }

            public Object getUnsynchronized() {
                if (GenericQueue.this.isEmpty()) {
                    throw new NoSuchElementException("queue is empty");
                }
                Iterator iter = GenericQueue.this._accessStrategy.end(GenericQueue.this._store);
                Object result = iter.current();
                iter.remove();
                return result;
            }
        };
        this._peekCode = new SynchronizedGetCode(this._store){

            public boolean precondition() {
                return GenericQueue.this._store.size() > 0;
            }

            public Object getUnsynchronized() {
                if (GenericQueue.this.isEmpty()) {
                    throw new NoSuchElementException("queue is empty");
                }
                return GenericQueue.this._accessStrategy.end(GenericQueue.this._store).current();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object obj) {
        if (this._isThreadSafe) {
            Store store = this._store;
            synchronized (store) {
                this._accessStrategy.prepend(this._store, obj);
                this._store.notify();
            }
        } else {
            this._accessStrategy.prepend(this._store, obj);
        }
    }

    public Object remove() {
        if (this._isThreadSafe) {
            throw new IllegalStateException();
        }
        return this._removeCode.getUnsynchronized();
    }

    public Object remove(boolean blocking) throws InterruptedException {
        if (this._isThreadSafe) {
            return this._removeCode.get(blocking);
        }
        throw new IllegalStateException("makes sense only for thread safe queues");
    }

    public Object remove(int timeoutMillis) throws InterruptedException, TimeoutException {
        if (this._isThreadSafe) {
            return this._removeCode.get(timeoutMillis);
        }
        throw new IllegalStateException("makes sense only for thread safe queues");
    }

    public Object peek() {
        if (this._isThreadSafe) {
            throw new IllegalStateException();
        }
        return this._peekCode.getUnsynchronized();
    }

    public Object peek(boolean blocking) throws InterruptedException {
        if (this._isThreadSafe) {
            return this._peekCode.get(blocking);
        }
        throw new IllegalStateException("makes sense only for thread safe queues");
    }

    public Object peek(int timeoutMillis) throws InterruptedException, TimeoutException {
        if (this._isThreadSafe) {
            return this._peekCode.get(timeoutMillis);
        }
        throw new IllegalStateException("makes sense only for thread safe queues");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        if (this._isThreadSafe) {
            Store store = this._store;
            synchronized (store) {
                return this._store.size();
            }
        }
        return this._store.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        if (this._isThreadSafe) {
            Store store = this._store;
            synchronized (store) {
                return this._store.isEmpty();
            }
        }
        return this._store.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this._isThreadSafe) {
            Store store = this._store;
            synchronized (store) {
                this._store.clear();
            }
        } else {
            this._store.clear();
        }
    }

    public boolean isThreadSafe() {
        return this._isThreadSafe;
    }

    public Queue cloneEmpty() {
        return new GenericQueue(this._store.cloneEmpty(), this._accessStrategy, this._isThreadSafe);
    }

    public Object clone() {
        return new GenericQueue((Store)this._store.clone(), this._accessStrategy, this._isThreadSafe);
    }
}

