/*
 * Decompiled with CFR 0.152.
 */
package ahc.collection;

import ahc.collection.Cache;
import ahc.collection.Collection;
import ahc.collection.Iterator;
import ahc.collection.Map;
import ahc.collection.MultiSet;
import ahc.collection.Set;
import ahc.collection.mod.ExternalIterator;
import ahc.collection.mod.Function1;
import ahc.collection.mod.Predicate1;
import ahc.exception.TunnelingException;
import ahc.util.IntegerFactory;
import java.util.Arrays;

public class GenericMultiSet
implements MultiSet {
    private final Map _map;

    public GenericMultiSet(Map map) {
        if (!map.isEmpty()) {
            throw new IllegalArgumentException("map must be empty");
        }
        this._map = map;
    }

    private GenericMultiSet(Map map, boolean dummy) {
        this._map = map;
    }

    public int getCount(Object o) {
        Integer count = this.getInt(o);
        return count == null ? 0 : count;
    }

    private Integer getInt(Object o) {
        Integer count = (Integer)this._map.get(o);
        return count;
    }

    public boolean removeSingle(Object o) {
        Integer count = this.getInt(o);
        if (count == null) {
            return false;
        }
        if (count == 1) {
            this._map.remove(o);
            return true;
        }
        this._map.put(o, IntegerFactory.decrement(count));
        return true;
    }

    public boolean add(Object o) {
        Integer count = this.getInt(o);
        this._map.put(o, IntegerFactory.increment(count));
        return true;
    }

    public Iterator before() {
        return new MultiSetIterator(this._map.keys().before());
    }

    public Iterator begin() {
        Iterator result = this.before();
        result.next();
        return result;
    }

    public int size() {
        return this._map.size();
    }

    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    public boolean contains(Object o) {
        return this._map.containsKey(o);
    }

    public java.util.Iterator iterator() {
        return this.before();
    }

    public Object[] toArray() {
        return this._map.keys().toArray();
    }

    public Object[] toArray(Object[] a) {
        return this._map.keys().toArray(a);
    }

    public boolean remove(Object o) {
        return this._map.remove(o) != null;
    }

    public boolean containsAll(java.util.Collection c) {
        return this._map.keys().containsAll(c);
    }

    public boolean addAll(java.util.Collection c) {
        java.util.Iterator iter = c.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
        return true;
    }

    public boolean addAll(Object[] newItems) {
        if (newItems == null) {
            return false;
        }
        return this.addAll(Arrays.asList(newItems));
    }

    public boolean removeAll(java.util.Collection c) {
        boolean modified = false;
        java.util.Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (!this.remove(iter.next())) continue;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(java.util.Collection c) {
        boolean modified = false;
        Iterator iter = this.begin();
        while (iter.hasCurrent()) {
            if (!c.contains(iter.current())) {
                this.remove(iter.current());
                modified = true;
            }
            iter.next();
        }
        return modified;
    }

    public void clear() {
        this._map.clear();
    }

    public void foreach(ExternalIterator iter) {
        this._map.keys().foreach(iter);
    }

    public Object firstMatch(Predicate1 pred) {
        return this._map.keys().firstMatch(pred);
    }

    public Collection allMatches(Predicate1 pred) {
        return this._map.keys().allMatches(pred);
    }

    public int numMatches(Predicate1 pred) {
        return this._map.keys().numMatches(pred);
    }

    public boolean matchesAll(Predicate1 pred) {
        return this._map.keys().matchesAll(pred);
    }

    public boolean matchesAny(Predicate1 pred) {
        return this._map.keys().matchesAny(pred);
    }

    public void addAll(MultiSet m) {
        Iterator iter = m.begin();
        while (iter.hasCurrent()) {
            Integer curValue = this.getInt(iter.current());
            this._map.put(iter.current(), IntegerFactory.add(curValue, m.getCount(iter.current())));
            iter.next();
        }
    }

    public void removeAll(MultiSet m) {
        Iterator iter = m.begin();
        while (iter.hasCurrent()) {
            Integer curValue = this.getInt(iter.current());
            if ((curValue = IntegerFactory.subtract(curValue, m.getCount(iter.current()))) < 0) {
                curValue = IntegerFactory.get(0);
            }
            this._map.put(iter.current(), curValue);
            iter.next();
        }
    }

    public boolean removeAllSingle(java.util.Collection c) {
        boolean modified = false;
        java.util.Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (!this.removeSingle(iter.next())) continue;
            modified = true;
        }
        return modified;
    }

    public MultiSet cloneEmptyMultiSet() {
        return (MultiSet)this.cloneEmpty();
    }

    public Set cloneEmptySet() {
        return (Set)this.cloneEmpty();
    }

    public Collection cloneEmpty() {
        return new GenericMultiSet(this._map.cloneEmpty());
    }

    public Object clone() {
        return new GenericMultiSet((Map)this._map.clone(), true);
    }

    public Collection immutableView() {
        return this.immutableSetView();
    }

    public Set immutableSetView() {
        return new GenericMultiSet(this._map.immutableView());
    }

    public Collection transform(Function1 function) {
        Collection result = this.cloneEmpty();
        try {
            Iterator iter = this.begin();
            while (iter.hasCurrent()) {
                result.add(function.eval(iter.current()));
                iter.next();
            }
        }
        catch (Exception e) {
            throw TunnelingException.create(e);
        }
        return result;
    }

    public Map split(Function1 function) {
        Cache cache = new Cache(){

            protected Object createNew(Object key) {
                return GenericMultiSet.this.cloneEmpty();
            }
        };
        try {
            Iterator iter = this.begin();
            while (iter.hasCurrent()) {
                for (int i = 0; i < this.getCount(iter.current()); ++i) {
                    ((MultiSet)cache.get(function.eval(iter.current()))).add(iter.current());
                }
                iter.next();
            }
        }
        catch (Exception e) {
            throw TunnelingException.create(e);
        }
        return cache.getMap();
    }

    protected class MultiSetIterator
    implements Iterator {
        private final Iterator _keysIter;

        public MultiSetIterator(Iterator keysIter) {
            this._keysIter = keysIter;
        }

        public boolean hasCurrent() {
            return this._keysIter.hasCurrent();
        }

        public Object current() {
            return this._keysIter.current();
        }

        public Object next(int n) {
            this._keysIter.next(n);
            return this.safeCurrent();
        }

        public boolean hasNext() {
            return this._keysIter.hasNext();
        }

        public Object next() {
            this._keysIter.next();
            return this.safeCurrent();
        }

        private Object safeCurrent() {
            return this._keysIter.hasCurrent() ? GenericMultiSet.this._map.get(this._keysIter.current()) : null;
        }

        public int currentIndex() {
            throw new UnsupportedOperationException();
        }

        public Object previous(int n) {
            throw new UnsupportedOperationException();
        }

        public boolean replace(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean hasPrevious() {
            throw new UnsupportedOperationException();
        }

        public Object previous() {
            throw new UnsupportedOperationException();
        }

        public int nextIndex() {
            throw new UnsupportedOperationException();
        }

        public int previousIndex() {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }
    }
}

