/*
 * Decompiled with CFR 0.152.
 */
package org.buni.panto;

public class TextUtil {
    private static final String NEWL = "\r\n";

    private static int indexOf(CharSequence s, char c, int fromIndex) {
        int i = fromIndex;
        while (i < s.length()) {
            if (s.charAt(i) == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static CharSequence foldLine(CharSequence line, int maxLength, char newLinePrefix) {
        if (line.length() <= maxLength || maxLength <= 0) {
            return line;
        }
        int foldPos = TextUtil.indexOf(line, ' ', maxLength);
        if (foldPos == -1) {
            return line;
        }
        StringBuilder result = new StringBuilder(line.length() + 3);
        result.append(line.subSequence(0, foldPos));
        result.append(NEWL);
        result.append(newLinePrefix);
        int lastFoldPos = foldPos;
        if ((foldPos += maxLength) < line.length()) {
            foldPos = TextUtil.indexOf(line, ' ', foldPos);
        }
        while (foldPos != -1 && foldPos < line.length()) {
            result.append(line.subSequence(0, foldPos));
            result.append(NEWL);
            result.append(newLinePrefix);
            lastFoldPos = foldPos;
            if ((foldPos += maxLength) >= line.length()) continue;
            foldPos = TextUtil.indexOf(line, ' ', foldPos);
        }
        result.append(line.subSequence(lastFoldPos, line.length()));
        return result;
    }

    public static String trimRight(String s) {
        int len = s.length();
        while (s.charAt(len - 1) <= ' ') {
            --len;
        }
        if (len == s.length()) {
            return s;
        }
        return s.substring(0, len);
    }

    public static String escapeXML(String s) {
        return s.replaceAll("&", "&amp;").replaceAll(">", "&gt;").replaceAll("<", "&lt;");
    }
}

