/*
 * Decompiled with CFR 0.152.
 */
package org.buni.panto;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.buni.panto.BodyHeader;
import org.buni.panto.ContentHandler;
import org.buni.panto.MimeParser;
import org.buni.panto.ParseException;

public class TestMimeParser
extends TestCase {
    File dir = new File("resources");

    public void testSimple() throws IOException, ParseException {
        MimeParser p = new MimeParser();
        p.setContentHandler(new SimpleContentHandler());
        p.parse(new FileInputStream(new File(this.dir, "test2.eml")));
    }

    public void testAttachmentImage() throws IOException, ParseException {
        MimeParser p = new MimeParser();
        p.setContentHandler(new SimpleContentHandler());
        p.parse(new FileInputStream(new File(this.dir, "m-attachment-image.msg")));
    }

    public void testOEAttachment() throws IOException, ParseException {
        MimeParser p = new MimeParser();
        p.setContentHandler(new SimpleContentHandler());
        p.parse(new FileInputStream(new File(this.dir, "Output_Express-Attachment.eml")));
    }

    private static class SimpleContentHandler
    implements ContentHandler {
        private int depth;

        private SimpleContentHandler() {
        }

        private String pad() {
            String s = "";
            int i = 0;
            while (i < this.depth) {
                s = String.valueOf(s) + "  ";
                ++i;
            }
            return s;
        }

        public int checkStream(InputStream in) throws IOException {
            byte[] b = new byte[8192];
            int read = 0;
            int numRead = 0;
            while ((numRead = in.read(b)) != -1) {
                int i = 0;
                while (i < numRead) {
                    if (b[i] == 0) {
                        int pos = read + i;
                        System.out.printf("Incorrect value at: %d\n", pos);
                        TestMimeParser.assertFalse((String)("Incorrect value at: " + pos), (b[i] == 0 ? 1 : 0) != 0);
                    }
                    ++i;
                }
                read += numRead;
            }
            return read;
        }

        public void body(BodyHeader header, InputStream is) throws IOException {
            System.out.println(header.getContentType());
            System.out.println(header.getContentDisposition());
            System.out.println(header.getContentTransferEncoding());
            System.out.println("Body: " + this.checkStream(is));
        }

        public void endBodyPart() {
            System.out.println(String.valueOf(this.pad()) + "</BodyPart>");
        }

        public void endHeader() {
            System.out.println(String.valueOf(this.pad()) + "</Header>");
        }

        public void endMessage() {
            System.out.println(String.valueOf(this.pad()) + "</Message>");
        }

        public void endMultipart() {
            --this.depth;
            System.out.println(String.valueOf(this.pad()) + "</Multipart>");
        }

        public void epilogue(InputStream in) throws IOException {
            System.out.println("Epilogue: " + this.checkStream(in));
        }

        public void field(String fieldData) {
        }

        public void preamble(InputStream in) throws IOException {
            System.out.println("Preamble: " + this.checkStream(in));
        }

        public void startBodyPart() {
            System.out.println(String.valueOf(this.pad()) + "<BodyPart>");
        }

        public void startHeader() {
            System.out.println(String.valueOf(this.pad()) + "<Header>");
        }

        public void startMessage() {
            System.out.println(String.valueOf(this.pad()) + "<Message>");
        }

        public void startMultipart(BodyHeader header) {
            System.out.println(String.valueOf(this.pad()) + "<Multipart>");
            ++this.depth;
        }
    }
}

