/*
 * Decompiled with CFR 0.152.
 */
package org.buni.panto;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.james.mime4j.ContentHandler;
import org.apache.james.mime4j.MimeStreamParser;
import org.buni.panto.Mime4JContentHandler;
import org.buni.panto.MimeParser;
import org.buni.panto.PantoContentHandler;
import org.buni.panto.ParseException;

public class TestMessages
extends TestCase {
    static final File dir = new File("resources");

    public static TestSuite suite() {
        String[] files = dir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".msg") || name.endsWith(".eml");
            }
        });
        TestSuite ts = new TestSuite();
        String[] stringArray = files;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String file = stringArray[n];
            ts.addTest((Test)new TestMessages(file));
            ++n;
        }
        return ts;
    }

    public TestMessages(String name) {
        super(name);
    }

    protected void runTest() throws IOException, ParseException {
        this.applyTest(this.getName());
    }

    public void applyTest(String name) throws IOException, ParseException {
        String s1 = this.getMime4JString(name);
        String s2 = this.getPantoString(name);
        System.out.println(String.valueOf(name) + "/Mime4J: " + s1);
        System.out.println(String.valueOf(name) + "/Panto : " + s2);
        TestMessages.assertEquals((String)s1, (String)s2);
    }

    private String getMime4JString(String name) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(new File(dir, name)));
        Mime4JContentHandler h = new Mime4JContentHandler();
        MimeStreamParser p = new MimeStreamParser();
        p.setContentHandler((ContentHandler)h);
        p.parse((InputStream)in);
        return h.toString();
    }

    private String getPantoString(String name) throws IOException, ParseException {
        FileInputStream in = new FileInputStream("resources/" + name);
        PantoContentHandler h = new PantoContentHandler();
        MimeParser p = new MimeParser();
        p.setContentHandler(h);
        p.parse(in);
        return h.toString();
    }
}

