/*
 * Decompiled with CFR 0.152.
 */
package org.buni.panto;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.buni.panto.BodyHeader;
import org.buni.panto.BoundaryInputStream;
import org.buni.panto.ContentHandler;
import org.buni.panto.ContentType;
import org.buni.panto.HeaderParser;
import org.buni.panto.IOUtil;
import org.buni.panto.NullContentHandler;

public class MimeParser {
    private static final int SIZE = 8192;
    private static final byte[] ENDL = new byte[]{13, 10};
    private int size = 8192;
    private int pbSize = 8292;
    private ContentHandler handler = new NullContentHandler();
    private HeaderParser hp = new HeaderParser();

    public void parse(InputStream in) throws IOException {
        PushbackInputStream pIn = new PushbackInputStream(in, this.pbSize);
        this.parseMessage(pIn);
    }

    public void setContentHandler(ContentHandler handler) {
        this.handler = handler;
    }

    public void setBufferSize(int size) {
        this.size = size;
    }

    private void parseMessage(PushbackInputStream in) throws IOException {
        this.handler.startMessage();
        BodyHeader header = this.hp.parseHeader(this.handler, in, new ContentType());
        this.parseBodyPart(in, header);
        this.handler.endMessage();
    }

    private void parseMultipart(PushbackInputStream in, BodyHeader header) throws IOException {
        byte[] pattern = header.getContentType().getPattern(false);
        this.handler.startMultipart(header);
        this.parsePreamble(in, pattern);
        byte[] patternNL = header.getContentType().getPattern(true);
        boolean finished = false;
        do {
            BoundaryInputStream bIn = new BoundaryInputStream(in, patternNL, this.size);
            PushbackInputStream pIn = new PushbackInputStream(bIn, this.pbSize);
            this.consumeEOF(pIn);
            this.parseMimeBodyPart(pIn, header.getContentType().getDefault());
            int b1 = in.read();
            int b2 = in.read();
            boolean bl = finished = b1 == -1 || b2 == -1 || b1 == 45 && b2 == 45;
            if (finished) continue;
            in.unread(b2);
            in.unread(b1);
        } while (!finished);
        this.consumeEOF(in);
        this.parseEpilogue(in);
        this.handler.endMultipart();
    }

    public void parseBodyPart(PushbackInputStream in, BodyHeader header) throws IOException {
        if (header.getContentType().isMulitpart()) {
            this.parseMultipart(in, header);
        } else if (header.getContentType().isMessage()) {
            this.parseMessage(in);
        } else {
            this.handler.body(header, in);
        }
    }

    private void parseMimeBodyPart(PushbackInputStream pIn, ContentType defaultContentType) throws IOException {
        this.handler.startBodyPart();
        BodyHeader header = this.hp.parseHeader(this.handler, pIn, defaultContentType);
        this.parseBodyPart(pIn, header);
        this.handler.endBodyPart();
    }

    private void parsePreamble(PushbackInputStream in, byte[] pattern) throws IOException {
        BoundaryInputStream bIn = new BoundaryInputStream(in, pattern, ENDL, this.size);
        this.handler.preamble(bIn);
    }

    private void parseEpilogue(PushbackInputStream in) throws IOException {
        this.handler.epilogue(in);
    }

    private void consumeEOF(PushbackInputStream in) throws IOException {
        IOUtil.appendLine(new StringBuilder(), in, "US-ASCII");
    }
}

