/*
 * Decompiled with CFR 0.152.
 */
package org.buni.panto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;

public class IOUtil {
    public static Object byteArrayToObject(byte[] data) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ObjectInputStream oin = new ObjectInputStream(bais);
            return oin.readObject();
        }
        catch (IOException e) {
            throw new RuntimeException("Error restoring object", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Error restoring object", e);
        }
    }

    public static byte[] objectToByteArray(Object o) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(o);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Error serializing object", e);
        }
    }

    public static void quietClose(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void quietClose(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static int appendLine(StringBuilder b, InputStream in, String charSet) throws IOException {
        int c;
        int numRead = 0;
        if (!in.markSupported()) {
            throw new IOException("mark(int) not support for input stream");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(128);
        while ((c = in.read()) != -1) {
            ++numRead;
            if (c == 13 || c == 10) {
                int expected = c == 13 ? 10 : 13;
                in.mark(1);
                int nextC = in.read();
                if (nextC == expected) {
                    ++numRead;
                    break;
                }
                in.reset();
                break;
            }
            out.write(c);
        }
        if (out.size() > 0) {
            b.append(out.toString(charSet));
        }
        return numRead;
    }

    public static int appendLine(StringBuilder b, PushbackInputStream in, String charSet) throws IOException {
        int c;
        int numRead = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream(128);
        while ((c = in.read()) != -1) {
            ++numRead;
            if (c == 13 || c == 10) {
                int expected = c == 13 ? 10 : 13;
                int nextC = in.read();
                if (nextC == expected) {
                    ++numRead;
                    break;
                }
                in.unread(nextC);
                break;
            }
            out.write(c);
        }
        if (out.size() > 0) {
            b.append(out.toString(charSet));
        }
        return numRead;
    }

    public static String toString(InputStream in, String encoding) throws IOException {
        byte[] b = new byte[8192];
        StringBuilder sb = new StringBuilder();
        int numRead = 0;
        while ((numRead = in.read(b)) != -1) {
            sb.append(new String(b, 0, numRead, encoding));
        }
        return sb.toString();
    }

    public static long count(InputStream in) throws IOException {
        long total = 0L;
        byte[] b = new byte[8192];
        int i = 0;
        while ((i = in.read(b)) != -1) {
            total += (long)i;
        }
        return total;
    }

    public static void dump(String filename, InputStream in) throws IOException {
        FileOutputStream fout = new FileOutputStream(filename);
        IOUtil.copy(in, fout);
        fout.flush();
        fout.close();
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] b = new byte[8192];
        int numRead = 0;
        while ((numRead = in.read(b)) != -1) {
            out.write(b, 0, numRead);
        }
    }
}

