/*
 * Decompiled with CFR 0.152.
 */
package org.buni.panto;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.buni.panto.BodyHeader;
import org.buni.panto.ContentDisposition;
import org.buni.panto.ContentHandler;
import org.buni.panto.ContentTransferEncoding;
import org.buni.panto.ContentType;
import org.buni.panto.IOUtil;
import org.buni.panto.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderParser {
    public BodyHeader parseHeader(ContentHandler handler, ExIterator<String, IOException> exi, ContentType defaultContentType) throws IOException {
        handler.startHeader();
        BodyHeader bodyHeader = new BodyHeader();
        bodyHeader.setContentType(defaultContentType);
        StringBuilder sb = new StringBuilder();
        StringBuilder mh = null;
        while (exi.hasNext()) {
            String s = exi.next();
            if (s.startsWith(" ") || s.startsWith("\t")) {
                if (mh == null) {
                    mh = new StringBuilder();
                } else {
                    mh.append("\r\n");
                }
                mh.append(s);
            } else {
                if (mh != null) {
                    String line = mh.toString();
                    this.addContentHeader(bodyHeader, line);
                    handler.field(line);
                }
                mh = new StringBuilder(s);
            }
            sb.delete(0, sb.length());
        }
        if (mh != null) {
            String line = mh.toString();
            this.addContentHeader(bodyHeader, line);
            handler.field(line);
        }
        handler.endHeader();
        return bodyHeader;
    }

    public BodyHeader parseHeader(ContentHandler handler, PushbackInputStream in, ContentType defaultContentType) throws IOException {
        IOStreamIterator exi = new IOStreamIterator(in);
        return this.parseHeader(handler, exi, defaultContentType);
    }

    public BodyHeader parseHeader(String header, ContentType defaultContentType) throws IOException {
        NullContentHandler ch = new NullContentHandler();
        List<String> fields = Arrays.asList(header.split("\r\n"));
        IteratorIterator<String> exi = new IteratorIterator<String>(fields.iterator());
        return this.parseHeader((ContentHandler)ch, exi, defaultContentType);
    }

    private void addContentHeader(BodyHeader header, String line) {
        try {
            ContentType ct = ContentType.parse(line);
            if (ct != null) {
                header.setContentType(ct);
            }
        }
        catch (ParseException e) {
            System.err.println("Content Type: " + e.getMessage());
        }
        try {
            ContentDisposition cd = ContentDisposition.parse(line);
            if (cd != null) {
                header.setContentDisposition(cd);
            }
        }
        catch (ParseException e) {
            System.err.println("Content Disposition: " + e.getMessage());
        }
        try {
            ContentTransferEncoding cte = ContentTransferEncoding.parse(line);
            if (cte != null) {
                header.setContentTransferEncoding(cte);
            }
        }
        catch (ParseException e) {
            System.err.println("Content Transfer Encoding: " + e.getMessage());
        }
    }

    private static class NullContentHandler
    implements ContentHandler {
        private NullContentHandler() {
        }

        public void body(BodyHeader header, InputStream is) throws IOException {
        }

        public void endBodyPart() {
        }

        public void endHeader() {
        }

        public void endMessage() {
        }

        public void endMultipart() {
        }

        public void epilogue(InputStream in) throws IOException {
        }

        public void field(String fieldData) {
        }

        public void preamble(InputStream in) throws IOException {
        }

        public void startBodyPart() {
        }

        public void startHeader() {
        }

        public void startMessage() {
        }

        public void startMultipart(BodyHeader header) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ExIterator<T, E extends Exception> {
        public boolean hasNext() throws E;

        public T next() throws E;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IteratorIterator<S>
    implements ExIterator<S, IOException> {
        private Iterator<S> iter;

        public IteratorIterator(Iterator<S> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.iter.hasNext();
        }

        @Override
        public S next() throws IOException {
            return this.iter.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IOStreamIterator
    implements ExIterator<String, IOException> {
        private StringBuilder sb = new StringBuilder();
        private final String charSet = "US-ASCII";
        private PushbackInputStream pIn;

        public IOStreamIterator(PushbackInputStream pIn) throws IOException {
            this.pIn = pIn;
        }

        @Override
        public boolean hasNext() throws IOException {
            this.sb.delete(0, this.sb.length());
            IOUtil.appendLine(this.sb, this.pIn, "US-ASCII");
            return this.sb.toString().length() > 0;
        }

        @Override
        public String next() throws IOException {
            return this.sb.toString();
        }
    }
}

