/*
 * Decompiled with CFR 0.152.
 */
package org.buni.panto;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.buni.panto.ContentTypeParser;
import org.buni.panto.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentHeader {
    private final String type;
    private final String subType;
    private final Map<String, String> parameters;

    public ContentHeader(String type, String subType, Map<String, String> parameters) {
        this.type = type;
        this.subType = subType;
        this.parameters = parameters;
    }

    protected ContentHeader(String line) {
        StringReader r = new StringReader(ContentHeader.stripNewlines(line));
        ContentTypeParser parser = new ContentTypeParser(r);
        try {
            parser.parseAll();
        }
        catch (ParseException e) {
            System.err.print(e.getMessage());
        }
        this.type = ContentHeader.toLowerCase(parser.getType());
        this.subType = ContentHeader.toLowerCase(parser.getSubType());
        this.parameters = new HashMap<String, String>();
        this.parameters.put("charset", "us-ascii");
        ArrayList names = parser.getParamNames();
        ArrayList values = parser.getParamValues();
        int i = 0;
        while (i < names.size() && i < values.size()) {
            String name = ContentHeader.toLowerCase(names.get(i).toString());
            this.parameters.put(name, values.get(i).toString());
            ++i;
        }
    }

    private static String stripNewlines(String s) {
        return s.replaceAll("\r|\n", "");
    }

    private static String toLowerCase(String s) {
        if (s != null) {
            return s.toLowerCase();
        }
        return s;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        String format = "Type: %s, SubType: %s, Parameters: %s";
        return String.format(format, this.type, this.subType, this.parameters);
    }
}

