/*
 * Decompiled with CFR 0.152.
 */
package org.eso.fits;

import java.io.IOException;
import java.util.Date;
import org.eso.fits.FitsException;
import org.eso.fits.FitsFile;
import org.eso.fits.FitsHDUnit;
import org.eso.fits.FitsHeader;
import org.eso.fits.FitsKeyword;

public class SaveFits {
    public static void main(String[] stringArray) {
        System.out.println("Start SaveFits");
        if (stringArray.length != 1) {
            System.out.println("Error: must have one argument, input file");
            System.exit(1);
        }
        FitsFile fitsFile = null;
        try {
            fitsFile = new FitsFile(stringArray[0]);
        }
        catch (FitsException fitsException) {
            System.out.println("Error: is not a FITS file >" + stringArray[0] + "<");
            System.exit(-1);
        }
        catch (IOException iOException) {
            System.out.println("Error: cannot open file >" + stringArray[0] + "<");
            System.exit(-1);
        }
        int n = fitsFile.getNoHDUnits();
        System.out.println("FITS file has " + n + " HDUnits");
        FitsHDUnit fitsHDUnit = fitsFile.getHDUnit(0);
        FitsHeader fitsHeader = fitsHDUnit.getHeader();
        FitsKeyword fitsKeyword = fitsHeader.getKeyword("DATE");
        fitsKeyword.setValue(new Date());
        fitsKeyword.setComment("Date of writting YYYY-MM-DD");
        fitsKeyword = new FitsKeyword("ANY", 1.24870921578123E11, "Just a number");
        fitsHeader.addKeyword(fitsKeyword);
        fitsKeyword = new FitsKeyword("ESO.DET.ID", "ID#123443", "The Detector ID");
        fitsHeader.addKeyword(fitsKeyword);
        fitsKeyword = new FitsKeyword("ATOOLONGKW", 122445, "And an interger");
        fitsHeader.addKeyword(fitsKeyword);
        fitsKeyword = new FitsKeyword("ISITTRUE", false, "let's try a boolesn");
        fitsHeader.addKeyword(fitsKeyword);
        fitsKeyword = new FitsKeyword(" ", "");
        fitsHeader.addKeyword(fitsKeyword);
        fitsKeyword = new FitsKeyword("NewDate", new Date(), "Try a Date");
        fitsHeader.addKeyword(fitsKeyword);
        fitsKeyword = new FitsKeyword("COMMENT", "a small real");
        fitsHeader.addKeyword(fitsKeyword);
        fitsKeyword = new FitsKeyword("AN-amall", 1.2234E-14, "a small real");
        fitsHeader.addKeyword(fitsKeyword);
        fitsKeyword = new FitsKeyword(" ", "");
        fitsHeader.addKeyword(fitsKeyword);
        try {
            fitsFile.saveFile();
        }
        catch (FitsException fitsException) {
            System.out.println("Error: FITS problem in writing >" + stringArray[0] + "<");
            System.exit(-1);
        }
        catch (IOException iOException) {
            System.out.println("Error: cannot write file >" + stringArray[0] + "<");
            System.exit(-1);
        }
        System.exit(0);
    }
}

