/*
 * Decompiled with CFR 0.152.
 */
package org.eso.fits;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import org.eso.fits.FitsData;
import org.eso.fits.FitsException;
import org.eso.fits.FitsHeader;
import org.eso.fits.FitsKeyword;
import org.eso.fits.FitsWCS;

public class FitsRGroup
extends FitsData {
    private int noValues;
    private int dataFormat = -32;
    private int bytesPerData = 4;
    private boolean scaling = false;
    private double zero = 0.0;
    private double scale = 1.0;
    private FitsWCS wcs;

    public FitsRGroup(FitsHeader fitsHeader, DataInput dataInput, boolean bl) throws FitsException {
        super(fitsHeader, dataInput, bl);
        if (this.type != 4) {
            throw new FitsException("Wrong header type", 4);
        }
        int n = this.naxis.length;
        FitsKeyword fitsKeyword = fitsHeader.getKeyword("BITPIX");
        if (fitsKeyword == null || fitsKeyword.getType() != 4) {
            throw new FitsException("Invalid or missing BITPIX", 4);
        }
        this.dataFormat = fitsKeyword.getInt();
        this.bytesPerData = Math.abs(this.dataFormat) / 8;
        this.noValues = (int)(this.size / (long)this.bytesPerData);
        this.wcs = new FitsWCS(fitsHeader);
        fitsKeyword = fitsHeader.getKeyword("BSCALE");
        if (fitsKeyword != null) {
            this.scale = fitsKeyword.getReal();
            if (this.scale != 1.0) {
                this.scaling = true;
            }
        }
        if ((fitsKeyword = fitsHeader.getKeyword("BZERO")) != null) {
            this.zero = fitsKeyword.getReal();
            if (this.zero != 0.0) {
                this.scaling = true;
            }
        }
    }

    @Override
    public FitsHeader getHeader() {
        FitsHeader fitsHeader = new FitsHeader();
        fitsHeader.addKeyword(new FitsKeyword("SIMPLE", true, "Standard FITS format; NOST 100-2.0"));
        fitsHeader.addKeyword(new FitsKeyword("BITPIX", this.bitpix, "No. of bits per pixel"));
        fitsHeader.addKeyword(new FitsKeyword("NAXIS", this.naxis.length + 1, "No. of axes in image"));
        fitsHeader.addKeyword(new FitsKeyword("NAXIS1", 0, "Random Groups convension"));
        for (int i = 2; i <= this.naxis.length + 1; ++i) {
            fitsHeader.addKeyword(new FitsKeyword("NAXIS" + i, this.naxis[i - 2], "No. of pixels"));
        }
        fitsHeader.addKeyword(new FitsKeyword("PCOUNT", this.noParm, "Parameter count"));
        fitsHeader.addKeyword(new FitsKeyword("GCOUNT", this.noGroup, "Group count"));
        fitsHeader.addKeyword(new FitsKeyword("GROUPS", true, "Random Groups format"));
        return fitsHeader;
    }

    public short[] getShortValues(int n, int n2, short[] sArray) throws FitsException {
        if (n < 0 || n2 < 1) {
            return sArray;
        }
        if (this.noValues < n + n2) {
            n2 = this.noValues - n;
        }
        if (sArray == null || sArray.length < n2) {
            sArray = new short[n2];
        }
        int n3 = 0;
        DataInputStream dataInputStream = this.getStream(n, n2);
        try {
            switch (this.dataFormat) {
                case 8: {
                    while (n3 < n2) {
                        sArray[n3++] = (short)dataInputStream.readUnsignedByte();
                    }
                    break;
                }
                case 16: {
                    while (n3 < n2) {
                        sArray[n3++] = dataInputStream.readShort();
                    }
                    break;
                }
                case 32: {
                    while (n3 < n2) {
                        sArray[n3++] = (short)dataInputStream.readInt();
                    }
                    break;
                }
                default: {
                    return sArray;
                }
            }
        }
        catch (IOException iOException) {
            throw new FitsException("Cannot convert data", 5);
        }
        if (this.scaling) {
            for (int i = 0; i < n3; ++i) {
                sArray[i] = (short)(this.scale * (double)sArray[i] + this.zero);
            }
        }
        return sArray;
    }

    public int[] getFloatValues(int n, int n2, int[] nArray) throws FitsException {
        if (n < 0 || n2 < 1) {
            return nArray;
        }
        if (this.noValues < n + n2) {
            n2 = this.noValues - n;
        }
        if (nArray == null || nArray.length < n2) {
            nArray = new int[n2];
        }
        int n3 = 0;
        DataInputStream dataInputStream = this.getStream(n, n2);
        try {
            switch (this.dataFormat) {
                case 8: {
                    while (n3 < n2) {
                        nArray[n3++] = dataInputStream.readUnsignedByte();
                    }
                    break;
                }
                case 16: {
                    while (n3 < n2) {
                        nArray[n3++] = dataInputStream.readShort();
                    }
                    break;
                }
                case 32: {
                    while (n3 < n2) {
                        nArray[n3++] = dataInputStream.readInt();
                    }
                    break;
                }
                default: {
                    return nArray;
                }
            }
        }
        catch (IOException iOException) {
            throw new FitsException("Cannot convert data", 5);
        }
        if (this.scaling) {
            for (int i = 0; i < n3; ++i) {
                nArray[i] = (int)(this.scale * (double)nArray[i] + this.zero);
            }
        }
        return nArray;
    }

    public float[] getFloatValues(int n, int n2, float[] fArray) throws FitsException {
        if (n < 0 || n2 < 1) {
            return fArray;
        }
        if (this.noValues < n + n2) {
            n2 = this.noValues - n;
        }
        if (fArray == null || fArray.length < n2) {
            fArray = new float[n2];
        }
        int n3 = 0;
        DataInputStream dataInputStream = this.getStream(n, n2);
        try {
            switch (this.dataFormat) {
                case 8: {
                    while (n3 < n2) {
                        fArray[n3++] = dataInputStream.readUnsignedByte();
                    }
                    break;
                }
                case 16: {
                    while (n3 < n2) {
                        fArray[n3++] = dataInputStream.readShort();
                    }
                    break;
                }
                case 32: {
                    while (n3 < n2) {
                        fArray[n3++] = dataInputStream.readInt();
                    }
                    break;
                }
                case -32: {
                    while (n3 < n2) {
                        fArray[n3++] = dataInputStream.readFloat();
                    }
                    break;
                }
                case -64: {
                    while (n3 < n2) {
                        fArray[n3++] = (float)dataInputStream.readDouble();
                    }
                    break;
                }
                default: {
                    return fArray;
                }
            }
        }
        catch (IOException iOException) {
            throw new FitsException("Cannot convert data", 5);
        }
        if (this.scaling) {
            for (int i = 0; i < n3; ++i) {
                fArray[i] = (float)(this.scale * (double)fArray[i] + this.zero);
            }
        }
        return fArray;
    }

    private DataInputStream getStream(int n, int n2) throws FitsException {
        DataInputStream dataInputStream;
        try {
            this.dataFile.seek(this.dataOffset + (long)(n * this.bytesPerData));
            if (this.noValues < n + n2) {
                n2 = this.noValues - n;
            }
            byte[] byArray = new byte[n2 * this.bytesPerData];
            this.dataFile.read(byArray);
            dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            throw new FitsException("Cannot read data", 5);
        }
        return dataInputStream;
    }

    public int getNoValues() {
        return this.noValues;
    }

    public double[] getCrpix() {
        return this.wcs.crpix;
    }

    public double[] getCrval() {
        return this.wcs.crval;
    }

    public double[] getCdelt() {
        return this.wcs.cdelt;
    }

    public FitsWCS getWCS() {
        return this.wcs;
    }

    public double[] toWCS(double[] dArray) {
        return this.wcs.toWCS(dArray);
    }

    public double[] toPixel(double[] dArray) {
        return this.wcs.toPixel(dArray);
    }
}

