/*
 * Decompiled with CFR 0.152.
 */
package org.eso.fits;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eso.fits.FitsData;
import org.eso.fits.FitsException;
import org.eso.fits.FitsHeader;
import org.eso.fits.FitsKeyword;
import org.eso.fits.FitsWCS;

public class FitsMatrix
extends FitsData {
    private int noValues;
    private int dataFormat = -32;
    private int bytesPerData = 4;
    private boolean scaling = false;
    private double zero = 0.0;
    private double scale = 1.0;
    private FitsWCS wcs;

    public FitsMatrix(FitsHeader fitsHeader, DataInput dataInput, boolean bl) throws FitsException {
        super(fitsHeader, dataInput, bl);
        if (this.type != 1) {
            throw new FitsException("Wrong header type", 4);
        }
        FitsKeyword fitsKeyword = fitsHeader.getKeyword("BITPIX");
        if (fitsKeyword == null || fitsKeyword.getType() != 4) {
            throw new FitsException("Invalid or missing BITPIX", 4);
        }
        this.dataFormat = fitsKeyword.getInt();
        this.bytesPerData = Math.abs(this.dataFormat) / 8;
        this.noValues = (int)(this.size / (long)this.bytesPerData);
        this.wcs = new FitsWCS(fitsHeader);
        fitsKeyword = fitsHeader.getKeyword("BSCALE");
        if (fitsKeyword != null) {
            this.scale = fitsKeyword.getReal();
            if (this.scale != 1.0) {
                this.scaling = true;
            }
        }
        if ((fitsKeyword = fitsHeader.getKeyword("BZERO")) != null) {
            this.zero = fitsKeyword.getReal();
            if (this.zero != 0.0) {
                this.scaling = true;
            }
        }
    }

    public FitsMatrix(int n, int[] nArray) throws FitsException {
        super(n, nArray);
        this.type = 1;
        this.dataFormat = n;
        this.bytesPerData = Math.abs(this.dataFormat) / 8;
        this.noValues = (int)(this.size / (long)this.bytesPerData);
        this.wcs = new FitsWCS(nArray.length);
    }

    @Override
    public FitsHeader getHeader() {
        FitsHeader fitsHeader = super.getHeader();
        fitsHeader.addKeyword(new FitsKeyword("", ""));
        for (int i = 1; i <= this.naxis.length; ++i) {
            fitsHeader.addKeyword(new FitsKeyword("CRPIX" + i, this.wcs.crpix[i - 1], "Reference pixel"));
            fitsHeader.addKeyword(new FitsKeyword("CRVAL" + i, this.wcs.crval[i - 1], "Coordinate at reference pixel"));
            fitsHeader.addKeyword(new FitsKeyword("CDELT" + i, this.wcs.cdelt[i - 1], "Coordinate increament per pixel"));
        }
        return fitsHeader;
    }

    public short[] getShortValues(int n, int n2, short[] sArray) throws FitsException {
        if (n < 0 || n2 < 1) {
            return sArray;
        }
        if (this.noValues < n + n2) {
            n2 = this.noValues - n;
        }
        if (sArray == null || sArray.length < n2) {
            sArray = new short[n2];
        }
        int n3 = 0;
        DataInputStream dataInputStream = this.getInStream(n, n2);
        try {
            switch (this.dataFormat) {
                case 8: {
                    while (n3 < n2) {
                        sArray[n3++] = (short)dataInputStream.readUnsignedByte();
                    }
                    break;
                }
                case 16: {
                    while (n3 < n2) {
                        sArray[n3++] = dataInputStream.readShort();
                    }
                    break;
                }
                case 32: {
                    while (n3 < n2) {
                        sArray[n3++] = (short)dataInputStream.readInt();
                    }
                    break;
                }
                default: {
                    return sArray;
                }
            }
        }
        catch (IOException iOException) {
            throw new FitsException("Cannot convert data", 5);
        }
        if (this.scaling) {
            for (int i = 0; i < n3; ++i) {
                sArray[i] = (short)(this.scale * (double)sArray[i] + this.zero);
            }
        }
        return sArray;
    }

    public int[] getIntValues(int n, int n2, int[] nArray) throws FitsException {
        if (n < 0 || n2 < 1) {
            return nArray;
        }
        if (this.noValues < n + n2) {
            n2 = this.noValues - n;
        }
        if (nArray == null || nArray.length < n2) {
            nArray = new int[n2];
        }
        int n3 = 0;
        DataInputStream dataInputStream = this.getInStream(n, n2);
        try {
            switch (this.dataFormat) {
                case 8: {
                    while (n3 < n2) {
                        nArray[n3++] = dataInputStream.readUnsignedByte();
                    }
                    break;
                }
                case 16: {
                    while (n3 < n2) {
                        nArray[n3++] = dataInputStream.readShort();
                    }
                    break;
                }
                case 32: {
                    while (n3 < n2) {
                        nArray[n3++] = dataInputStream.readInt();
                    }
                    break;
                }
                default: {
                    return nArray;
                }
            }
        }
        catch (IOException iOException) {
            throw new FitsException("Cannot read data", 5);
        }
        if (this.scaling) {
            for (int i = 0; i < n3; ++i) {
                nArray[i] = (int)(this.scale * (double)nArray[i] + this.zero);
            }
        }
        return nArray;
    }

    public float[] getFloatValues(int n, int n2, float[] fArray) throws FitsException {
        if (n < 0 || n2 < 1) {
            return fArray;
        }
        if (this.noValues < n + n2) {
            n2 = this.noValues - n;
        }
        if (fArray == null || fArray.length < n2) {
            fArray = new float[n2];
        }
        int n3 = 0;
        DataInputStream dataInputStream = this.getInStream(n, n2);
        try {
            switch (this.dataFormat) {
                case 8: {
                    while (n3 < n2) {
                        fArray[n3++] = dataInputStream.readUnsignedByte();
                    }
                    break;
                }
                case 16: {
                    while (n3 < n2) {
                        fArray[n3++] = dataInputStream.readShort();
                    }
                    break;
                }
                case 32: {
                    while (n3 < n2) {
                        fArray[n3++] = dataInputStream.readInt();
                    }
                    break;
                }
                case -32: {
                    while (n3 < n2) {
                        fArray[n3++] = dataInputStream.readFloat();
                    }
                    break;
                }
                case -64: {
                    while (n3 < n2) {
                        fArray[n3++] = (float)dataInputStream.readDouble();
                    }
                    break;
                }
                default: {
                    return fArray;
                }
            }
        }
        catch (IOException iOException) {
            throw new FitsException("Cannot read data", 5);
        }
        if (this.scaling) {
            for (int i = 0; i < n3; ++i) {
                fArray[i] = (float)(this.scale * (double)fArray[i] + this.zero);
            }
        }
        return fArray;
    }

    private DataInputStream getInStream(int n, int n2) throws FitsException {
        DataInputStream dataInputStream;
        try {
            this.dataFile.seek(this.dataOffset + (long)(n * this.bytesPerData));
            if (this.noValues < n + n2) {
                n2 = this.noValues - n;
            }
            byte[] byArray = new byte[n2 * this.bytesPerData];
            this.dataFile.read(byArray);
            dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            throw new FitsException("Cannot read InStream data", 5);
        }
        return dataInputStream;
    }

    public void setShortValues(int n, short[] sArray) throws FitsException {
        if (n < 0 || this.noValues <= n) {
            throw new FitsException("Invalid pixel offset", 5);
        }
        if (sArray == null) {
            throw new FitsException("Invalid data array", 5);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(sArray.length * this.bytesPerData);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        if (this.scaling) {
            throw new FitsException("Scaling of short not supported", 5);
        }
        int n2 = 0;
        try {
            switch (this.dataFormat) {
                case 8: {
                    throw new FitsException("Cannot convert data to BYTE", 5);
                }
                case 16: {
                    while (n2 < sArray.length) {
                        dataOutputStream.writeShort(sArray[n2++]);
                    }
                    break;
                }
                case 32: {
                    while (n2 < sArray.length) {
                        dataOutputStream.writeInt(sArray[n2++]);
                    }
                    break;
                }
                case -32: {
                    while (n2 < sArray.length) {
                        dataOutputStream.writeFloat(sArray[n2++]);
                    }
                    break;
                }
                case -64: {
                    while (n2 < sArray.length) {
                        dataOutputStream.writeDouble(sArray[n2++]);
                    }
                    break;
                }
                default: {
                    throw new FitsException("Invalid data format", 5);
                }
            }
            if (this.isRAFile) {
                this.dataFile.seek(this.dataOffset + (long)(n * this.bytesPerData));
                this.dataFile.write(byteArrayOutputStream.toByteArray());
            } else {
                byte[] byArray = byteArrayOutputStream.toByteArray();
                n2 = (int)(this.dataOffset * (long)this.bytesPerData);
                for (int i = 0; i < byArray.length; ++i) {
                    this.dataArray[n2++] = byArray[i];
                }
            }
        }
        catch (IOException iOException) {
            throw new FitsException("Cannot convert data", 5);
        }
    }

    public void setIntValues(int n, int[] nArray) throws FitsException {
        if (n < 0 || this.noValues <= n) {
            throw new FitsException("Invalid pixel offset", 5);
        }
        if (nArray == null) {
            throw new FitsException("Invalid data array", 5);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(nArray.length * this.bytesPerData);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        if (this.scaling) {
            throw new FitsException("Scaling of int not supported", 5);
        }
        int n2 = 0;
        try {
            switch (this.dataFormat) {
                case 8: {
                    throw new FitsException("Cannot convert data", 5);
                }
                case 16: {
                    while (n2 < nArray.length) {
                        dataOutputStream.writeShort((short)nArray[n2++]);
                    }
                    break;
                }
                case 32: {
                    while (n2 < nArray.length) {
                        dataOutputStream.writeInt(nArray[n2++]);
                    }
                    break;
                }
                case -32: {
                    while (n2 < nArray.length) {
                        dataOutputStream.writeFloat(nArray[n2++]);
                    }
                    break;
                }
                case -64: {
                    while (n2 < nArray.length) {
                        dataOutputStream.writeDouble(nArray[n2++]);
                    }
                    break;
                }
                default: {
                    throw new FitsException("Invalid data format", 5);
                }
            }
            if (this.isRAFile) {
                this.dataFile.seek(this.dataOffset + (long)(n * this.bytesPerData));
                this.dataFile.write(byteArrayOutputStream.toByteArray());
            } else {
                byte[] byArray = byteArrayOutputStream.toByteArray();
                n2 = (int)(this.dataOffset * (long)this.bytesPerData);
                for (int i = 0; i < byArray.length; ++i) {
                    this.dataArray[n2++] = byArray[i];
                }
            }
        }
        catch (IOException iOException) {
            throw new FitsException("Cannot write data", 5);
        }
    }

    public void setFloatValues(int n, float[] fArray) throws FitsException {
        int n2;
        if (n < 0 || this.noValues <= n) {
            throw new FitsException("Invalid pixel offset", 5);
        }
        if (fArray == null) {
            throw new FitsException("Invalid data array", 5);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(fArray.length * this.bytesPerData);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        if (this.scaling) {
            for (n2 = 0; n2 < fArray.length; ++n2) {
                fArray[n2] = (float)(((double)fArray[n2] - this.zero) / this.scale);
            }
        }
        n2 = 0;
        try {
            switch (this.dataFormat) {
                case 8: {
                    throw new FitsException("Cannot convert data", 5);
                }
                case 16: {
                    while (n2 < fArray.length) {
                        dataOutputStream.writeShort((short)fArray[n2++]);
                    }
                    break;
                }
                case 32: {
                    while (n2 < fArray.length) {
                        dataOutputStream.writeInt((int)fArray[n2++]);
                    }
                    break;
                }
                case -32: {
                    while (n2 < fArray.length) {
                        dataOutputStream.writeFloat(fArray[n2++]);
                    }
                    break;
                }
                case -64: {
                    while (n2 < fArray.length) {
                        dataOutputStream.writeDouble(fArray[n2++]);
                    }
                    break;
                }
                default: {
                    throw new FitsException("Invalid data format", 5);
                }
            }
            if (this.isRAFile) {
                this.dataFile.seek(this.dataOffset + (long)(n * this.bytesPerData));
                this.dataFile.write(byteArrayOutputStream.toByteArray());
            } else {
                byte[] byArray = byteArrayOutputStream.toByteArray();
                n2 = (int)(this.dataOffset * (long)this.bytesPerData);
                for (int i = 0; i < byArray.length; ++i) {
                    this.dataArray[n2++] = byArray[i];
                }
            }
        }
        catch (IOException iOException) {
            throw new FitsException("Cannot write data", 5);
        }
    }

    public int getNoValues() {
        return this.noValues;
    }

    public void setCrpix(double[] dArray) {
        this.wcs.crpix = new double[this.naxis.length];
        for (int i = 0; i < this.naxis.length; ++i) {
            this.wcs.crpix[i] = dArray != null && i < dArray.length ? dArray[i] : 1.0;
        }
    }

    public double[] getCrpix() {
        return this.wcs.crpix;
    }

    public void setCrval(double[] dArray) {
        this.wcs.crval = new double[this.naxis.length];
        for (int i = 0; i < this.naxis.length; ++i) {
            this.wcs.crval[i] = dArray != null && i < dArray.length ? dArray[i] : 1.0;
        }
    }

    public double[] getCrval() {
        return this.wcs.crval;
    }

    public void setCdelt(double[] dArray) {
        this.wcs.cdelt = new double[this.naxis.length];
        for (int i = 0; i < this.naxis.length; ++i) {
            this.wcs.cdelt[i] = dArray != null && i < dArray.length ? dArray[i] : 1.0;
        }
    }

    public double[] getCdelt() {
        return this.wcs.cdelt;
    }

    public FitsWCS getWCS() {
        return this.wcs;
    }

    public double[] toWCS(double[] dArray) {
        return this.wcs.toWCS(dArray);
    }

    public double[] toPixel(double[] dArray) {
        return this.wcs.toPixel(dArray);
    }
}

