/*
 * Decompiled with CFR 0.152.
 */
package org.eso.fits;

import java.io.IOException;
import java.util.Date;
import org.eso.fits.FitsColumn;
import org.eso.fits.FitsData;
import org.eso.fits.FitsException;
import org.eso.fits.FitsFile;
import org.eso.fits.FitsHDUnit;
import org.eso.fits.FitsHeader;
import org.eso.fits.FitsKeyword;
import org.eso.fits.FitsMatrix;

public class CreateFits {
    public static final int ROWS = 473;

    public static void main(String[] stringArray) {
        Object object;
        if (stringArray.length < 1) {
            System.err.println("Usage: java org.eso.fits.CreateFits file");
            System.exit(1);
        }
        System.out.println("Start CreateFits");
        int[] nArray = new int[]{251, 247};
        int n = nArray[0] * nArray[1];
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = i;
        }
        FitsHDUnit fitsHDUnit = null;
        Object var5_6 = null;
        FitsHDUnit fitsHDUnit2 = null;
        try {
            object = new FitsMatrix(-32, nArray);
            ((FitsMatrix)object).setFloatValues(0, fArray);
            double[] dArray = new double[]{234.02, -12.1};
            ((FitsMatrix)object).setCrpix(dArray);
            dArray[0] = -331.3;
            dArray[1] = 721.3;
            ((FitsMatrix)object).setCrval(dArray);
            dArray[0] = 0.214;
            dArray[1] = 0.331;
            ((FitsMatrix)object).setCdelt(dArray);
            FitsHeader fitsHeader = ((FitsMatrix)object).getHeader();
            fitsHeader.addKeyword(new FitsKeyword("", ""));
            fitsHeader.addKeyword(new FitsKeyword("DATE", new Date(), "Date of writing"));
            fitsHDUnit = new FitsHDUnit(fitsHeader, (FitsData)object);
            FitsColumn fitsColumn = new FitsColumn(32, "1I", "No", 473);
            FitsColumn fitsColumn2 = new FitsColumn(-64, "1D", "RA", 473);
            FitsColumn fitsColumn3 = new FitsColumn(-64, "1D", "Dec", 473);
            FitsColumn fitsColumn4 = new FitsColumn(-32, "1E", "Mag", 473);
            nArray = new int[]{64, 64, 3};
            n = nArray[0] * nArray[1] * nArray[2];
            short[] sArray = new short[n];
            for (int i = 0; i < n; ++i) {
                sArray[i] = (short)i;
            }
            FitsMatrix fitsMatrix = new FitsMatrix(16, nArray);
            fitsMatrix.setShortValues(0, sArray);
            FitsHeader fitsHeader2 = fitsMatrix.getHeader();
            fitsHeader2.setExtension(1);
            fitsHeader2.addKeyword(new FitsKeyword("", ""));
            fitsHeader2.addKeyword(new FitsKeyword("EXTNAME", "TEST", "Extension name"));
            fitsHeader2.addKeyword(new FitsKeyword("DATE", new Date(), "Date of writing"));
            fitsHDUnit2 = new FitsHDUnit(fitsHeader2, fitsMatrix);
        }
        catch (FitsException fitsException) {
            System.err.println("Error: cannot create HDU0;" + fitsException);
            System.exit(1);
        }
        object = new FitsFile();
        ((FitsFile)object).addHDUnit(fitsHDUnit);
        ((FitsFile)object).addHDUnit(fitsHDUnit2);
        int n2 = ((FitsFile)object).getNoHDUnits();
        System.out.println("FITS file has " + n2 + " HDUnits");
        try {
            ((FitsFile)object).writeFile(stringArray[0]);
        }
        catch (FitsException fitsException) {
            System.err.println("Error: FITS problem in writing >" + stringArray[0] + "<");
            System.exit(-1);
        }
        catch (IOException iOException) {
            System.err.println("Error: cannot write file >" + stringArray[0] + "<");
            System.exit(-1);
        }
        System.out.println("Finish CreateFits");
        System.exit(0);
    }
}

