/*
 * Decompiled with CFR 0.152.
 */
package org.eso.fits;

import java.io.IOException;
import org.eso.fits.FitsException;
import org.eso.fits.FitsFile;

public class CopyFits {
    public static void main(String[] stringArray) {
        System.out.println("Start CopyFits");
        if (stringArray.length != 2) {
            System.err.println("Error: must have two argument> input output");
            System.exit(1);
        }
        FitsFile fitsFile = null;
        try {
            fitsFile = new FitsFile(stringArray[0]);
        }
        catch (FitsException fitsException) {
            System.err.println("Error: is not a FITS file >" + stringArray[0] + "<");
            System.exit(-1);
        }
        catch (IOException iOException) {
            System.err.println("Error: cannot open file >" + stringArray[0] + "<");
            System.exit(-1);
        }
        int n = fitsFile.getNoHDUnits();
        System.out.println("FITS file has " + n + " HDUnits");
        try {
            fitsFile.writeFile(stringArray[1]);
        }
        catch (FitsException fitsException) {
            System.err.println("Error: FITS problem in writing >" + stringArray[1] + "<");
            System.exit(-1);
        }
        catch (IOException iOException) {
            System.err.println("Error: cannot write file >" + stringArray[1] + "<");
            System.exit(-1);
        }
        System.out.println("Finish CopyFits");
        System.exit(0);
    }
}

