/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.userdb.offline;

import alma.obsprep.ot.userdb.EmailAddress;
import alma.obsprep.ot.userdb.QueryResults;
import alma.obsprep.ot.userdb.User;
import alma.obsprep.ot.userdb.UserDatabase;
import alma.obsprep.ot.userdb.exceptions.InvalidArgumentException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class OfflineDatabase
implements UserDatabase {
    private static final List<User> db = new ArrayList<User>();
    private static final int MIN_NAME_LENGTH = 3;
    private static final int MIN_UID_MATCH = 3;

    public boolean isAlive() {
        return true;
    }

    public QueryResults matchEmail(String email) throws InvalidArgumentException {
        if (!EmailAddress.isValidText((String)email)) {
            throw new InvalidArgumentException("Invalid email address");
        }
        ArrayList<User> matches = new ArrayList<User>();
        for (User u : db) {
            if (!u.getEmail().equals(email)) continue;
            matches.add(u);
        }
        return new QueryResults(matches);
    }

    public QueryResults matchEmail(List<String> addresses) throws InvalidArgumentException {
        LinkedHashSet matches = new LinkedHashSet();
        for (String email : addresses) {
            matches.addAll(this.matchEmail(email).getMatches());
        }
        ArrayList asList = new ArrayList();
        asList.addAll(matches);
        return new QueryResults(asList);
    }

    public QueryResults matchName(String name) {
        String normalised = this.removeAccents(name);
        ArrayList<User> matches = new ArrayList<User>();
        for (User u : db) {
            if (!this.removeAccents(u.getFirstName()).contains(normalised) && !this.removeAccents(u.getSurname()).contains(normalised) && !this.removeAccents(u.getFullName()).contains(normalised)) continue;
            matches.add(u);
        }
        return new QueryResults(matches);
    }

    public QueryResults matchName(List<String> names) {
        LinkedHashSet matches = new LinkedHashSet();
        for (String name : names) {
            matches.addAll(this.matchName(name).getMatches());
        }
        ArrayList asList = new ArrayList();
        asList.addAll(matches);
        return new QueryResults(asList);
    }

    public QueryResults matchUid(String uid) {
        String normalised = this.removeAccents(uid);
        ArrayList<User> matches = new ArrayList<User>();
        for (User u : db) {
            if (!u.getUid().equalsIgnoreCase(normalised)) continue;
            matches.add(u);
        }
        return new QueryResults(matches);
    }

    public QueryResults matchUid(List<String> uids) {
        LinkedHashSet matches = new LinkedHashSet();
        for (String uid : uids) {
            matches.addAll(this.matchUid(uid).getMatches());
        }
        ArrayList asList = new ArrayList();
        asList.addAll(matches);
        return new QueryResults(asList);
    }

    private String removeAccents(String input) {
        String normalised = Normalizer.normalize(input, Normalizer.Form.NFKD);
        normalised = normalised.replaceAll("[^\\p{ASCII}]", "");
        return normalised.toLowerCase();
    }

    public static List<User> getUsers() {
        return db;
    }

    static {
        db.add(new User("nlorente", "Nuria Lorente", "Unknown Affiliation", "npfl@roe.ac.uk"));
        db.add(new User("pnapier", "Peter Napier", "Unknown Affiliation", "pnapier@nrao.edu"));
        db.add(new User("apeck", "Alison Peck", "Unknown Affiliation", "apeck@nrao.edu"));
        db.add(new User("jibsen", "Jorge Ibsen", "Unknown Affiliation", "jibsen@nrao.edu"));
        db.add(new User("bvila", "Vila vila", "Unknown Affiliation", "bvila@nrao.edu"));
        db.add(new User("srankin", "Scott Rankin", "Unknown Affiliation", "srankin@nrao.edu"));
        db.add(new User("jcaram", "Juan Pablo Caram", "Unknown Affiliation", "jcaram@nrao.edu"));
        db.add(new User("jkern", "Jeff Kern", "Unknown Affiliation", "jkern@nrao.edu"));
        db.add(new User("dshepher", "Debra Shepherd", "Unknown Affiliation", "dshepher@nrao.edu"));
        db.add(new User("tmatsui", "Matsui takayuki", "Unknown Affiliation", "takayuki.matsui@nao.ac.jp"));
        db.add(new User("agrimstr", "Arne Grimstrup", "Unknown Affiliation", "arne@ras.ucalgary.ca"));
        db.add(new User("gkosugi", "Kosugi unknown", "Unknown Affiliation", "notknown@nao.ac.jp"));
        db.add(new User("tshen", "Tzu Shen", "Unknown Affiliation", "tshen@alma.cl"));
        db.add(new User("ldiez", "Laura Diez", "Unknown Affiliation", "ldiez@eso.org"));
        db.add(new User("mschilli", "Marcus Schilling", "Unknown Affiliation", "mschilli@eso.org"));
        db.add(new User("sturolla", "Stefano Turolla", "Unknown Affiliation", "sturolla@nrao.edu"));
        db.add(new User("pmartinez", "Pascal Schilling", "Unknown Affiliation", "pmartinez@nrao.edu"));
        db.add(new User("mmenezes", "Manuel Menezes", "Unknown Affiliation", "mmenezes@eso.org"));
        db.add(new User("efomalon", "Ed Fomalont", "Unknown Affiliation", "efomalon@nrao.edu"));
        db.add(new User("ramestic", "Rodrigo Amestica", "Unknown Affiliation", "ramestic@nrao.edu"));
        db.add(new User("rolguin", "Rodrigo Olguin", "Unknown Affiliation", "rolguin@nrao.edu"));
        db.add(new User("rogasawa", "Ogasawara ryu", "Unknown Affiliation", "ryu.ogasawara@nao.ac.jp"));
        db.add(new User("mzambran", "Mauricio Zambrano", "Unknown Affiliation", "mzambran@alma.cl"));
        db.add(new User("rsoto", "Ruben Soto", "Unknown Affiliation", "rsoto@alma.cl"));
        db.add(new User("dhunter", "David Hunter", "Unknown Affiliation", "dhunter@nrao.edu"));
        db.add(new User("swilliam", "Stewart Williams", "Unknown Affiliation", "stewart.williams@stfc.ac.uk"));
        db.add(new User("tpowers", "Thomas Powers", "Unknown Affiliation", "tpowers@aoc.nrao.edu"));
        db.add(new User("mpasquat", "Moreno Pasquato", "Unknown Affiliation", "mpasquat@nrao.edu"));
        db.add(new User("dschieb", "Darrell Schiebel", "Unknown Affiliation", "drs@nrao.edu"));
        db.add(new User("nemerson", "Nick Emerson", "Unknown Affiliation", "nemerson@aoc.nrao.edu"));
        db.add(new User("eduvall", "Eugene Duvall", "Unknown Affiliation", "eduvall@nrao.edu"));
        db.add(new User("blopez", "Bernhard Lopez", "Unknown Affiliation", "blopez@alma.cl"));
        db.add(new User("awicenec", "Andreas Wicenec", "Unknown Affiliation", "awicenec@eso.org"));
        db.add(new User("acaproni", "ALessandro Caproni", "Unknown Affiliation", "acaproni@nrao.edu"));
        db.add(new User("dbroguier", "Dominique Broguiere", "Unknown Affiliation", "broguier@iram.fr"));
        db.add(new User("pmurphy", "Pat Murphy", "Unknown Affiliation", "pmurphy@nrao.edu"));
        db.add(new User("rridgewa", "Robert Ridgeway", "Unknown Affiliation", "rridgewa@nrao.edu"));
        db.add(new User("almaproc", "Alma Proc", "Unknown Affiliation", "almaproc@alma.cl"));
        db.add(new User("pgrosbol", "Preben Grosbol", "Unknown Affiliation", "pgrosbol@eso.org"));
        db.add(new User("aotarola", "Angel Otarola", "Unknown Affiliation", "aotarola@nrao.edu"));
        db.add(new User("awootten", "Alwyn Wootten", "Unknown Affiliation", "awootten@nrao.edu"));
        db.add(new User("ldavis", "Lindsey Davis", "Unknown Affiliation", "ldavis@nrao.edu"));
        db.add(new User("raraya", "Rodrigo Araya", "Unknown Affiliation", "raraya@alma.cl"));
        db.add(new User("ktatemat", "Tatematsu k", "Unknown Affiliation", "k.tatematsu@nao.ac.jp"));
        db.add(new User("raviles", "Roberto Aviles", "Unknown Affiliation", "raviles@nrao.edu"));
        db.add(new User("matsui", "Takayuki Matsui", "Unknown Affiliation", "takayuki.matsui@nao.ac.jp"));
        db.add(new User("rmurowin", "Richard Murowinski", "Unknown Affiliation", "rmurowin@nrao.edu"));
        db.add(new User("rmarson", "Ralph Marson", "Unknown Affiliation", "rmarson@nrao.edu"));
        db.add(new User("jmeadows", "Jack Meadows", "Unknown Affiliation", "jmeadows@nrao.edu"));
        db.add(new User("aremijan", "Tony Remijan", "Unknown Affiliation", "aremijan@nrao.edu"));
        db.add(new User("ntroncos", "Nicolas Troncoso", "Unknown Affiliation", "ntroncos@nrao.edu"));
        db.add(new User("bvilaro", "Baltasar Vila Vilaro", "Unknown Affiliation", "bvilaro@nrao.edu"));
        db.add(new User("cbrogan", "Crystal Brogan", "Unknown Affiliation", "cbrogan@nrao.edu"));
        db.add(new User("rlaing", "Robert Laing", "Unknown Affiliation", "rlaing@nrao.edu"));
        db.add(new User("sharring", "Steve Harrington", "Unknown Affiliation", "sharring@nrao.edu"));
        db.add(new User("jmcmulli", "Joseph Mcmullin", "Unknown Affiliation", "jmcmulli@aoc.nrao.edu"));
        db.add(new User("jperez", "Jesus Perez", "Unknown Affiliation", "jperez@nrao.edu"));
        db.add(new User("ahale", "Andy Hale", "Unknown Affiliation", "ahale@nrao.edu"));
        db.add(new User("nbarriga", "Nicolas Barriga", "Unknown Affiliation", "nbarriga@alma.cl"));
        db.add(new User("dpescoller", "Dietrich Pescoller", "Unknown Affiliation", "dpescoller@nrao.edu"));
        db.add(new User("rcirami", "Roberto Cirami", "Unknown Affiliation", "rcirami@eso.org"));
        db.add(new User("psalome", "Philippe Salome", "Unknown Affiliation", "psalome@nrao.edu"));
        db.add(new User("salbanna", "Sarmad Albanna", "Unknown Affiliation", "salbanna@nrao.edu"));
        db.add(new User("gchiozzi", "Gianluca Chiozzi", "Unknown Affiliation", "gchiozzi@nrao.edu"));
        db.add(new User("rlucas", "Robert Lucas", "Unknown Affiliation", "rlucas@nrao.edu"));
        db.add(new User("jgallard", "Juan Gallardo", "Unknown Affiliation", "jgallard@alma.cl"));
        db.add(new User("pdimarca", "Paolo di Marcantonio", "Unknown Affiliation", "pdimarca@eso.org"));
        db.add(new User("jpisano", "Jim Pisano", "Unknown Affiliation", "jpisano@nrao.edu"));
        db.add(new User("mcaillat", "Michel Caillat", "Unknown Affiliation", "Michel.Caillat@obspm.fr"));
        db.add(new User("jknudstr", "Jens Knudstrup", "Unknown Affiliation", "jknudstr@eso.org"));
        db.add(new User("mzaw", "Mich Zaw", "Unknown Affiliation", "mzaw@nrao.edu"));
        db.add(new User("rhiriart", "Rafael Hiriart", "Unknown Affiliation", "rhiriart@nrao.edu"));
        db.add(new User("pmetzner", "Paula Metzner", "Unknown Affiliation", "pmetzner@nrao.edu"));
        db.add(new User("idegrego", "Itziar de Gregorio", "Unknown Affiliation", "idegrego@eso.org"));
        db.add(new User("pramirez", "Pedro Ramirez", "Unknown Affiliation", "pramirez@nrao.edu"));
        db.add(new User("demerson", "Darrel Emerson", "Unknown Affiliation", "demerson@nrao.edu"));
        db.add(new User("psivera", "Paola Sivera", "Unknown Affiliation", "Paola.Sivera@eso.org"));
        db.add(new User("jschwarz", "Joe Schwarz", "Unknown Affiliation", "jschwarz@eso.org"));
        db.add(new User("bgustafs", "Birger Gustafson", "Unknown Affiliation", "bgustafs@nrao.edu"));
        db.add(new User("hmeuss", "Holger Meuss", "Unknown Affiliation", "hmeuss@eso.org"));
        db.add(new User("jmangum", "Jeff Mangum", "Unknown Affiliation", "jmangum@nrao.edu"));
        db.add(new User("dmedlin", "Drew Medlin", "Unknown Affiliation", "dmedlin@nrao.edu"));
        db.add(new User("ccarilli", "Chris Carilli", "Unknown Affiliation", "ccarilli@nrao.edu"));
        db.add(new User("ahales", "Antonio Hales", "Unknown Affiliation", "ahales@nrao.edu"));
        db.add(new User("tjuerges", "Tomas Juerges", "Unknown Affiliation", "tjuerges@nrao.edu"));
        db.add(new User("hhafok", "Heiko Hafok", "Unknown Affiliation", "hhafok@nrao.edu"));
        db.add(new User("abridger", "Alan Bridger", "Unknown Affiliation", "ab@roe.ac.uk"));
        db.add(new User("hsommer", "Heiko Sommer", "Unknown Affiliation", "hsommer@nrao.edu"));
        db.add(new User("sscott", "Steve Scott", "Unknown Affiliation", "sscott@nrao.edu"));
        db.add(new User("bmarx", "Beate Marx", "Unknown Affiliation", "bmarx@nrao.edu"));
        db.add(new User("jrobnett", "James Robnett", "Unknown Affiliation", "jrobnett@nrao.edu"));
        db.add(new User("smyers", "Steven Myers", "Unknown Affiliation", "smyers@nrao.edu"));
        db.add(new User("rreid", "Robert Reid", "Unknown Affiliation", "rreid@nrao.edu"));
        db.add(new User("molivare", "Manuel Olivares", "Unknown Affiliation", "molivare@nrao.edu"));
        db.add(new User("bjeram", "Bogdan Jeram", "Unknown Affiliation", "bjeram@nrao.edu"));
        db.add(new User("amchavan", "Maurizio Chavan", "Unknown Affiliation", "mchavan@eso.org"));
        db.add(new User("emichael", "Ernest Michael", "Unknown Affiliation", "emichael@alma.cl"));
        db.add(new User("jsalaman", "Juan Salamanca", "Unknown Affiliation", "jsalaman@alma.cl"));
        db.add(new User("pcampana", "Pedro Campana", "Unknown Affiliation", "pcampana@alma.cl"));
        db.add(new User("sdicesar", "Stephano Di Cesare", "Unknown Affiliation", "sdicesar@eso.org"));
        db.add(new User("nsaez", "Norman Saez", "Unknown Affiliation", "nsaez@alma.cl"));
        db.add(new User("aschemrl", "Anton Schemrl", "Unknown Affiliation", "aschemrl@alma.cl"));
        db.add(new User("jreveco", "Johnny Reveco", "Unknown Affiliation", "jreveco@alma.cl"));
        db.add(new User("vgonzale", "Victor Gonzalez", "Unknown Affiliation", "vgonzale@alma.cl"));
        db.add(new User("eallaert", "Erik Allaert", "Unknown Affiliation", "eallaert@eso.org"));
        db.add(new User("asaez", "Alejandro Saez", "Unknown Affiliation", "asaez@nrao.edu"));
        db.add(new User("bhoff", "Brian Hoff", "Unknown Affiliation", "bhoff@alma.cl"));
        db.add(new User("cpaillam", "Carlos Paillaman", "Unknown Affiliation", "cpaillam@alma.cl"));
        db.add(new User("dsramek", "Dick Sramek", "Unknown Affiliation", "dsramek@alma.cl"));
        db.add(new User("ebarrios", "Emilio Barrios", "Unknown Affiliation", "ebarrios@alma.cl"));
        db.add(new User("eduran", "Ernesto Duran", "Unknown Affiliation", "eduran@alma.cl"));
        db.add(new User("fcruzat", "Fabiola Cruzat", "Unknown Affiliation", "fcruzat@alma.cl"));
        db.add(new User("jnorambu", "Jorge Norambuena", "Unknown Affiliation", "jnorambu@alma.cl"));
        db.add(new User("jpgarcia", "Juan Pablo Garcia", "Unknown Affiliation", "jpgarcia@alma.cl"));
        db.add(new User("jpuga", "Jose Pablo Puga", "Unknown Affiliation", "jpuga@alma.cl"));
        db.add(new User("lknee", "Lewis Knee", "Unknown Affiliation", "lknee@alma.cl"));
        db.add(new User("lmconde", "Lorenzo Martinez-conde", "Unknown Affiliation", "lmconde@alma.cl"));
        db.add(new User("sargando", "Sebastian Argandona", "Unknown Affiliation", "sargando@alma.cl"));
        db.add(new User("pkratzer", "Peter Kratzer", "Unknown Affiliation", "pkratzer@eso.org"));
        db.add(new User("dpetry", "Dirk Petry", "Unknown Affiliation", "dpetry@eso.org"));
        db.add(new User("spinchei", "Sebastian Pincheira", "Unknown Affiliation", "spinchei@alma.cl"));
        db.add(new User("gortiz", "German Ortiz", "Unknown Affiliation", "gortiz@alma.cl"));
        db.add(new User("aperfett", "Antonio Perfetto", "Unknown Affiliation", "aperfett@nrao.edu"));
        db.add(new User("avaccari", "Andrea Vaccari", "Unknown Affiliation", "avaccari@nrao.edu"));
        db.add(new User("cholmste", "Christian Holmstedt", "Unknown Affiliation", "cholmste@nrao.edu"));
        db.add(new User("durbain", "Denis Urbain", "Unknown Affiliation", "durbain@nrao.edu"));
        db.add(new User("jcrabtre", "Joshua Crabtree", "Unknown Affiliation", "jcrabtre@nrao.edu"));
        db.add(new User("asymmes", "Art Symmes", "Unknown Affiliation", "asymmes@nrao.edu"));
        db.add(new User("halarcon", "Hector Alarcon", "Unknown Affiliation", "halarcon@alma.cl"));
        db.add(new User("ambmgr", "AMB Manager", "Unknown Affiliation", "ambmgr@alma.cl"));
        db.add(new User("wlin", "Wenhua Lin", "Unknown Affiliation", "wlin@nrao.edu"));
        db.add(new User("jsepulve", "Jorge Sepulveda", "Unknown Affiliation", "jsepulve@alma.cl"));
        db.add(new User("hye", "Honglin Ye", "Unknown Affiliation", "hye@nrao.edu"));
        db.add(new User("broguier", "Dominique Broguier", "Unknown Affiliation", "broguier@iram.fr"));
        db.add(new User("dbroguie", "Dominique Broguiere", "Unknown Affiliation", "broguier@iram.fr"));
        db.add(new User("jbenson", "John Benson", "Unknown Affiliation", "jbenson@nrao.edu"));
        db.add(new User("mmora", "Matias Mora", "Unknown Affiliation", "mmora@alma.cl"));
        db.add(new User("pburgos", "Pablo Burgos", "Unknown Affiliation", "pburgos@alma.cl"));
        db.add(new User("rmauersb", "Rainer Mauersberger", "Unknown Affiliation", "rmauersb@alma.cl"));
        db.add(new User("vsuorant", "Ville Suoranta", "Unknown Affiliation", "vsuorant@aoc.nrao.edu"));
        db.add(new User("dcastill", "Danilo Castillo", "Unknown Affiliation", "dcastill@alma.cl"));
        db.add(new User("pyagoubo", "Pavel Yagoubov", "Unknown Affiliation", "pyagoubo@eso.org"));
        db.add(new User("wyoung", "Wes Young", "Unknown Affiliation", "wyoung@aoc.nrao.edu"));
        db.add(new User("acheccuc", "Alessio Checcucci", "Unknown Affiliation", "acheccuc@eso.org"));
        db.add(new User("gmartine", "Gamel Martinez", "Unknown Affiliation", "gmartine@alma.cl"));
        db.add(new User("ckoko", "Ciccio Koko", "Unknown Affiliation", "ckoko@eso.org"));
        db.add(new User("scorder", "Stuartt Corder", "Unknown Affiliation", "scorder@alma.cl"));
        db.add(new User("tsawada", "Tsuyoshi Sawada", "Unknown Affiliation", "tsawada@alma.cl"));
        db.add(new User("jzivick", "Jeff Zivick", "Unknown Affiliation", "jzivick@nrao.edu"));
        db.add(new User("darredon", "Diego Arredondo", "Unknown Affiliation", "darredon@alma.cl"));
        db.add(new User("jmlarsen", "Jonas Larsen", "Unknown Affiliation", "jmlarsen@eso.org"));
        db.add(new User("dshutt", "Dean Shutt", "Unknown Affiliation", "dshutt@nrao.edu"));
        db.add(new User("jfcliche", "Jean Cliche", "Unknown Affiliation", "jfcliche@jfcliche.com"));
        db.add(new User("mbartsch", "Marcelo Bartsch", "Unknown Affiliation", "mbartsch@alma.cl"));
        db.add(new User("scistern", "Sandro Cisterna", "Unknown Affiliation", "scistern@alma.cl"));
        db.add(new User("bvilavil", "Baltazar Vila-Vilaro", "Unknown Affiliation", "bvilavil@alma.cl"));
        db.add(new User("pcortes", "Paulo Cortes", "Unknown Affiliation", "pcortes@alma.cl"));
        db.add(new User("dbarkats", "Denis Barkats", "Unknown Affiliation", "dbarkats@alma.cl"));
        db.add(new User("bdent", "Bill Dent", "Unknown Affiliation", "bdent@alma.cl"));
        db.add(new User("jcortes", "Juan Cortes", "Unknown Affiliation", "jcortes@alma.cl"));
        db.add(new User("rkneissl", "Ruediger Kneissl", "Unknown Affiliation", "rkneissl@alma.cl"));
        db.add(new User("mrawling", "Mark Rawlings", "Unknown Affiliation", "mrawling@alma.cl"));
        db.add(new User("dgarcia", "Diego Garcia", "Unknown Affiliation", "dgarcia@eso.org"));
        db.add(new User("rsramek", "Richard Sramek", "Unknown Affiliation", "rsramek@alma.cl"));
        db.add(new User("hafok", "Heiko Hafok", "Unknown Affiliation", "hafok@mpifr-bonn.mpg.de"));
        db.add(new User("fviallef", "Francois Viallefond", "Unknown Affiliation", "fviallef@maat.obspm.fr"));
        db.add(new User("gmoellen", "George Moellenbrock", "Unknown Affiliation", "gmoellen@nrao.edu"));
        db.add(new User("wdent", "Bill Dent", "Unknown Affiliation", "wdent@alma.cl"));
        db.add(new User("msaito", "Masao Saito", "Unknown Affiliation", "masao.saito@nao.ac.jp"));
        db.add(new User("dguo", "Dongshan Guo", "Unknown Affiliation", "dguo@nrao.edu"));
        db.add(new User("mmorales", "Mauricio Morales", "Unknown Affiliation", "mmorales@alma.cl"));
        db.add(new User("kflaim", "Kevin Flaim", "Unknown Affiliation", "kflaim@nrao.edu"));
        db.add(new User("sgonzale", "Sergio Gonzalez", "Unknown Affiliation", "sgonzale@alma.cl"));
        db.add(new User("scomboy", "Steve Comboy", "Unknown Affiliation", "scomboy@alma.cl"));
        db.add(new User("rromero", "Rodrigo Romero", "Unknown Affiliation", "rromero@alma.cl"));
        db.add(new User("sconboy", "Steve Conboy", "Unknown Affiliation", "sconboy@alma.cl"));
        db.add(new User("fschwab", "Fred Schwab", "Unknown Affiliation", "fschwab@nrao.edu"));
        db.add(new User("jcastill", "Jorge Castillo", "Unknown Affiliation", "jcastill@alma.cl"));
        db.add(new User("graffi", "Gianni Raffi", "Unknown Affiliation", "graffi@eso.org"));
        db.add(new User("jmurray", "Jim Murray", "Unknown Affiliation", "jmurray@alma.cl"));
        db.add(new User("laravena", "Leonardo Aravena", "Unknown Affiliation", "laravena@alma.cl"));
        db.add(new User("jocortes", "Jose Cortes", "Unknown Affiliation", "jcortes@alma.cl"));
        db.add(new User("wgrammer", "Wes Grammer", "Unknown Affiliation", "wgrammer@alma.cl"));
        db.add(new User("bnikolic", "Bojan Nikolic", "Unknown Affiliation", "b.nikolic@mrao.cam.ac.uk"));
        db.add(new User("rhills", "Richard Hills", "Unknown Affiliation", "rhills@alma.cl"));
        db.add(new User("ereynold", "Eric Reynolds", "Unknown Affiliation", "ereynold@alma.cl"));
        db.add(new User("sasayama", "Shinichiro Asayama", "Unknown Affiliation", "sasayama@alma.cl"));
        db.add(new User("rbrito", "Rodrigo Brito", "Unknown Affiliation", "rbrito@nrao.edu"));
        db.add(new User("rscott", "chip scott", "Unknown Affiliation", "rscott@nrao.edu"));
        db.add(new User("jortiz", "Jose Ortiz", "Unknown Affiliation", "jortiz@alma.cl"));
        db.add(new User("vmedina", "Valentin Medina", "Unknown Affiliation", "vmedina@alma.cl"));
        db.add(new User("aquitan", "Alvaro Quintana", "Unknown Affiliation", "aquintan@alma.cl"));
        db.add(new User("cfollert", "Claudio Follert", "Unknown Affiliation", "cfollert@alma.cl"));
        db.add(new User("aquintan", "Alvaro Quintana", "Unknown Affiliation", "aquintan@alma.cl"));
        db.add(new User("nakanisi", "Kouichiro Nakanishi", "Unknown Affiliation", "nakanisi@nro.nao.ac.jp"));
        db.add(new User("ajbaker", "Andrew Baker", "Unknown Affiliation", "ajbaker@physics.rutgers.edu"));
        db.add(new User("knaka", "Kyoko Nakamura", "Unknown Affiliation", "kyoko.nakamura@nao.ac.jp"));
        db.add(new User("javarias", "Jorge avarias", "Unknown Affiliation", "MAIL"));
        db.add(new User("kyoko", "Kyoko Ashitagawa", "Unknown Affiliation", "kyoko.ashi@nao.ac.jp"));
        db.add(new User("jwagg", "Jeff Wagg", "Unknown Affiliation", "jwagg@eso.org"));
        db.add(new User("ksheth", "Kartik Sheth", "Unknown Affiliation", "ksheth@nrao.edu"));
        db.add(new User("mzwaan", "Marin Zwaan", "Unknown Affiliation", "mzwaan@eso.org"));
        db.add(new User("rkurowsk", "robert kurowski", "Unknown Affiliation", "rkurowsk@eso.org"));
        db.add(new User("fjulbe", "francesc julbe", "Unknown Affiliation", "fjulbe@eso.org"));
        db.add(new User("jroche", "Jean-Christophe Roche", "Unknown Affiliation", "roche@iram.fr"));
        db.add(new User("rtobar", "Rodrigo Tobar", "Unknown Affiliation", "rtobar@eso.org"));
        db.add(new User("ktachihara", "Kengo Tachihara", "Unknown Affiliation", "k.tachihara@nao.ac.jp"));
        db.add(new User("sfuica", "Soledad Fuica", "Unknown Affiliation", "sole_suke@yahoo.com"));
        db.add(new User("dclarke", "David Clarke", "Unknown Affiliation", "dclarke@nrao.edu"));
        db.add(new User("panta", "Bhola Panta", "Unknown Affiliation", "bhola.panta@nao.ac.jp"));
        db.add(new User("lcortez", "Luis Cortez", "Unknown Affiliation", "lcortez@alma.cl"));
        db.add(new User("ecurtis", "Emily Curtis", "Unknown Affiliation", "eic22@mrao.cam.ac.uk"));
        db.add(new User("smartin", "Sergio Marin", "Unknown Affiliation", "smartin@eso.org"));
        db.add(new User("evillard", "Eric Villard", "Unknown Affiliation", "evillard@alma.cl"));
        db.add(new User("mtasaki", "Masahiko Tasaki", "Unknown Affiliation", "tasaki.masahiko@nao.ac.jp"));
        db.add(new User("jagonzal", "Justo Gonzalez", "Unknown Affiliation", "jagonzal@eso.org"));
        db.add(new User("lsimms", "Lance Simms", "Unknown Affiliation", "lsmimms@alma.cl"));
        db.add(new User("dfulla", "Daniel Fulla", "Unknown Affiliation", "dfulla@alma.cl"));
        db.add(new User("epietrig", "Emmanuel Pietriga", "Unknown Affiliation", "epietrig@eso.org"));
        db.add(new User("bpanta", "Panta Bhola", "Unknown Affiliation", "bhola.panta@nao.ac.jp"));
        db.add(new User("rrao", "Ramprasad Rao", "Unknown Affiliation", "rrao@sma.hawaii.edu"));
        db.add(new User("twilson", "Tom Wilson", "Unknown Affiliation", "twilson@alma.cl"));
        db.add(new User("dmuders", "Dirk Muders", "Unknown Affiliation", "dmuders@mpifr-bonn.mpg.de"));
        db.add(new User("twiklind", "Thomas Wiklind", "Unknown Affiliation", "twiklind@alma.cl"));
        db.add(new User("sleon", "Stephane Leon", "Unknown Affiliation", "sleon@alma.cl"));
        db.add(new User("pcalisse", "Paolo Calisse", "Unknown Affiliation", "pcalisse@alma.cl"));
        db.add(new User("dgunawan", "Diah Gunawan", "Unknown Affiliation", "dgunawan@alma.cl"));
        db.add(new User("hyatagai", "Hiroshi Yatagai", "Unknown Affiliation", "yatagai.hiroshi@nao.ac.jp"));
        db.add(new User("htischer", "Helmut Tischer", "Unknown Affiliation", "htischer@eso.org"));
        db.add(new User("dschiebel", "Darrel Schiebel", "Unknown Affiliation", "drs@nrao.edu"));
        db.add(new User("novando", "Nicolas Ovando", "Unknown Affiliation", "novando@alma.cl"));
        db.add(new User("emorita", "Eisuke Morita", "Unknown Affiliation", "Eisuke.Morita@nao.ac.jp"));
        db.add(new User("rbhatia", "Ravinder Bhatia", "Unknown Affiliation", "rbhatia@alma.cl"));
        db.add(new User("jmarti", "Javier Martin", "Unknown Affiliation", "jmarti@alma.cl"));
        db.add(new User("wsnow", "William Snow", "Unknown Affiliation", "wsnow@alma.cl"));
        db.add(new User("msugimot", "Masahiro Sugimoto", "Unknown Affiliation", "masahiro.sugimoto@nao.ac.jp"));
        db.add(new User("satoki", "Satoki Matsushita", "Unknown Affiliation", "satoki@asiaa.sinica.edu.tw"));
        db.add(new User("chaupt", "Cristoph Haupt", "Unknown Affiliation", "chaupt@eso.org"));
        db.add(new User("abiggs", "Andrew Biggs", "Unknown Affiliation", "abiggs@eso.org"));
        db.add(new User("opanic", "Olja Panic", "Unknown Affiliation", "opanic@eso.org"));
        db.add(new User("hliszt", "Harvey Liszt", "Unknown Affiliation", "hliszt@nrao.edu"));
        db.add(new User("fjkitayama", "Yuichiro Kitayama", "Unknown Affiliation", "y-kitayama@jp.fujitsu.com"));
        db.add(new User("mwatanabe", "Manabu Watanabe", "Unknown Affiliation", "watanabe.manabu@nao.ac.jp"));
        db.add(new User("mkohichi", "Morita Koh-Ichiro", "Unknown Affiliation", "morita@nro.nao.ac.jp"));
        db.add(new User("kmorita", "Koh-Ichiro Morita", "Unknown Affiliation", "morita@nro.nao.ac.jp"));
        db.add(new User("fjtsutsumi", "Jumpei Tsutsumi", "Unknown Affiliation", "tsutsumi.junpei@jp.fujitsu.com"));
    }
}

