/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xframe.xsddoc;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.xframe.ex.ExceptionUtil;
import net.sf.xframe.xsddoc.ProcessorException;
import net.sf.xframe.xsddoc.ProcessorListener;
import net.sf.xframe.xsddoc.SchemaException;
import net.sf.xframe.xsddoc.util.BrowserLauncher;
import net.sf.xframe.xsddoc.util.DomUtil;
import net.sf.xframe.xsddoc.util.FileUtil;
import net.sf.xframe.xsddoc.util.StringUtil;
import net.sf.xframe.xsddoc.util.XMLUtil;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public final class Processor {
    private static final String XSDDOCID_ATTR = "xsddocid";
    public static final String XSDDOC_PREFIX = "net.sf.xframe.xsddoc";
    public static final String NAMESPACE_NAMESPACE = "http://www.w3.org/2000/xmlns/";
    public static final String XMLSCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    public static final String XSDDOC_NAMESPACE = "http://xframe.sf.net/xsddoc/doc";
    public static final String TARGETNAMESPACE = "targetNamespace";
    public static final String NO_NAMESPACE = "noNamespace";
    public static final String RESOURCE_PROTOCOL = "resource:";
    private static final String HTML_EXT = ".html";
    private static final String XML_EXT = ".xml";
    private static final String FILE_SEP = File.separator;
    private static final String DOM_PROTOCOL = "temp:";
    private final String resourcePrefix = StringUtil.replace(this.getClass().getPackage().getName(), '.', '/');
    private DocumentBuilderFactory builderFactory = null;
    private DocumentBuilder builder = null;
    private TransformerFactory tFactory = null;
    private Transformer tIndexAll = null;
    private Transformer tIndex = null;
    private Transformer tOverviewAll = null;
    private Transformer tOverviewNamespaces = null;
    private Transformer tOverviewNamespace = null;
    private Transformer tSchemaSummary = null;
    private Transformer tSchemaIndex = null;
    private Transformer tComponent = null;
    private Transformer tHtml = null;
    private Transformer tHelp = null;
    private Map schemaCache = new HashMap();
    private Map sourceCache = new HashMap();
    private Map importCache = new HashMap();
    private String mainSchemaLocation = "";
    private Document mainSchema = null;
    private String footer = "";
    private String doctitle;
    private String header = "";
    private String bottom = "";
    private String out = ".";
    private String xsddocHome = ".";
    private String css = null;
    private boolean verbose = true;
    private boolean debug = false;
    private boolean launch = false;
    private boolean createFolder = false;
    private boolean xml = false;
    private boolean hideSubTypes = false;
    private boolean hideLocalUsage = false;
    private boolean hideTypes = false;
    private boolean hideAttributes = false;
    private boolean hideGroups = false;
    private String proxyHost;
    private String proxyPort;
    private boolean initialized = false;
    private Map schemaLocationProcessedMap = new HashMap();
    private ProcessorListener listener = new ConsoleListener();

    public void setHeader(String string) {
        this.header = string;
    }

    public void setFooter(String string) {
        this.footer = string;
    }

    public void setBottom(String string) {
        this.bottom = string;
    }

    public void setDoctitle(String string) {
        this.doctitle = string;
    }

    public void setSchemaLocation(String string) {
        this.mainSchemaLocation = string;
    }

    public void setMainSchema(Document document) {
        this.mainSchema = document;
    }

    public void setOut(String string) {
        this.out = string;
    }

    public void setCss(String string) {
        this.css = string;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
        if (this.debug) {
            this.verbose = true;
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    protected boolean isCreateFolder() {
        return this.createFolder;
    }

    protected void setCreateFolder(boolean bl) {
        this.createFolder = bl;
    }

    protected boolean isLaunch() {
        return this.launch;
    }

    protected void setLaunch(boolean bl) {
        this.launch = bl;
    }

    public void setXml(boolean bl) {
        this.xml = bl;
    }

    public void setHideLocalUsage(boolean bl) {
        this.hideLocalUsage = bl;
    }

    public void setHideSubTypes(boolean bl) {
        this.hideSubTypes = bl;
    }

    public void setHideAttributes(boolean bl) {
        this.hideAttributes = bl;
    }

    public void setHideGroups(boolean bl) {
        this.hideGroups = bl;
    }

    public void setHideTypes(boolean bl) {
        this.hideTypes = bl;
    }

    public void setProxyHost(String string) {
        this.proxyHost = string;
    }

    public void setProxyPort(String string) {
        this.proxyPort = string;
    }

    public ProcessorListener getListener() {
        return this.listener;
    }

    public void setListener(ProcessorListener processorListener) {
        this.listener = processorListener;
    }

    private String getExtension() {
        return this.xml ? XML_EXT : HTML_EXT;
    }

    public void execute() throws ProcessorException {
        if (this.out == null) {
            throw new ProcessorException("output folder is null");
        }
        File file = new File(this.out);
        if (!file.exists()) {
            if (this.createFolder) {
                file.mkdirs();
            } else {
                throw new ProcessorException("output folder doesn't exist: " + file);
            }
        }
        if (!file.exists()) {
            throw new ProcessorException("output folder doesn't exist: " + file);
        }
        if (this.debug) {
            this.status();
        }
        try {
            if (!this.initialized) {
                this.initProxy();
                this.initBuilder();
                this.initTransformers();
            }
            this.process();
            if (this.launch) {
                BrowserLauncher.openURL(this.out + FILE_SEP + "index" + this.getExtension());
            }
        }
        catch (Exception exception) {
            throw new ProcessorException(exception.getLocalizedMessage(), exception);
        }
    }

    public String run() {
        ByteArrayOutputStream byteArrayOutputStream;
        PrintStream printStream;
        PrintStream printStream2;
        block2: {
            printStream2 = System.out;
            printStream = System.err;
            byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream3 = new PrintStream(byteArrayOutputStream);
            System.setOut(printStream3);
            System.setErr(printStream3);
            try {
                this.execute();
            }
            catch (Throwable throwable) {
                System.out.println("xsddoc failed with exception: " + throwable.getLocalizedMessage());
                if (!this.isDebug()) break block2;
                System.out.println(ExceptionUtil.printStackTrace(throwable));
            }
        }
        System.setOut(printStream2);
        System.setErr(printStream);
        return byteArrayOutputStream.toString();
    }

    private void status() {
        this.getListener().debug("xsddoc.home: " + this.xsddocHome);
        this.getListener().debug("out.folder: " + this.out);
        this.getListener().debug("schema.location: " + this.mainSchemaLocation);
    }

    private void initProxy() {
        if (this.proxyHost != null) {
            System.setProperty("http.proxySet", "true");
            System.setProperty("http.proxyHost", this.proxyHost);
            System.setProperty("http.proxyPort", this.proxyPort);
        }
    }

    private void initBuilder() throws ParserConfigurationException {
        if (this.debug) {
            this.getListener().debug("create document builder");
        }
        this.builderFactory = DocumentBuilderFactory.newInstance();
        this.builderFactory.setNamespaceAware(true);
        this.builder = this.builderFactory.newDocumentBuilder();
    }

    private void initTransformers() throws TransformerConfigurationException, IOException {
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.tFactory = TransformerFactory.newInstance();
        this.tFactory.setErrorListener(new ProcessorErrorListener());
        this.tFactory.setURIResolver(new ResourceResolver());
        this.tOverviewAll = this.createTransformer("overview-all.xsl");
        this.tOverviewNamespaces = this.createTransformer("overview-namespaces.xsl");
        this.tOverviewNamespace = this.createTransformer("overview-namespace.xsl");
        this.tSchemaSummary = this.createTransformer("schema-summary.xsl");
        this.tSchemaIndex = this.createTransformer("schema-index.xsl");
        this.tComponent = this.createTransformer("component.xsl");
        this.tIndexAll = this.createTransformer("index-all.xsl");
        this.tIndex = this.createTransformer("index.xsl");
        this.tHtml = this.createTransformer("xml2html.xsl");
        this.tHelp = this.createTransformer("help-doc.xsl");
    }

    private Transformer createTransformer(String string) throws TransformerConfigurationException, IOException {
        if (this.debug) {
            this.getListener().debug("create transformer for " + string);
        }
        String string2 = "/" + this.resourcePrefix + "/xslt/" + string;
        Source source = this.getResourceSource(string2, RESOURCE_PROTOCOL + string2);
        Transformer transformer = this.tFactory.newTransformer(source);
        transformer.setErrorListener(this.tFactory.getErrorListener());
        if (transformer == null) {
            throw new TransformerConfigurationException("Cannot create transformer for " + string);
        }
        return transformer;
    }

    private void process() throws TransformerException, SAXException, IOException, SchemaException {
        if (this.debug) {
            this.getListener().debug("start processing...");
        }
        FileUtil.copyFile(this.getResource("/" + this.resourcePrefix + "/css/stylesheet.css"), this.out + FILE_SEP + "stylesheet.css");
        if (this.css != null) {
            try {
                FileUtil.copyFile(this.css, this.out + FILE_SEP + "stylesheet.css");
            }
            catch (IOException iOException) {
                this.getListener().error("CSS file not found: " + this.css);
            }
        }
        String string = this.getSystemId(this.mainSchemaLocation);
        Document document = this.mainSchema == null ? (this.mainSchema = this.getDocument(string)) : this.mainSchema;
        Source source = this.getSource(document, string);
        this.transform(source, this.tIndex, this.out + FILE_SEP + "index" + this.getExtension());
        this.transform(source, this.tOverviewAll, this.out, "overview-all");
        this.transform(source, this.tOverviewNamespaces, this.out, "overview-namespaces");
        this.transform(source, this.tSchemaSummary, this.out, "schema-summary");
        this.transform(source, this.tIndexAll, this.out, "index-all");
        this.transform(source, this.tHelp, this.out, "help-doc");
        this.process(document, this.mainSchemaLocation);
    }

    private void process(Document document, String string) throws TransformerException, SAXException, IOException, SchemaException {
        if (this.debug) {
            this.getListener().debug("process schema " + string);
        }
        String string2 = this.getTargetNamespace(document);
        String string3 = this.out + FILE_SEP + this.getFolderFromURI(string2.equals("") ? NO_NAMESPACE : string2);
        new File(string3).mkdir();
        Source source = this.getSource(document, this.getSystemId(string));
        this.transform(source, this.tOverviewNamespace, string3, "overview-namespace");
        this.transform(source, this.tSchemaIndex, string3, "index");
        this.schemaLocationProcessedMap.clear();
        this.processComponents(document, string);
    }

    private void processComponents(Document document, String string) throws TransformerException, SAXException, IOException, SchemaException {
        if (this.debug) {
            this.getListener().debug("process components of schema " + string);
        }
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            this.processComponent(document, string, node, node, "");
        }
    }

    private void processComponent(Document document, String string, Node node, Node node2, String string2) throws TransformerException, SAXException, IOException, SchemaException {
        String string3 = node.getLocalName();
        String string4 = this.getTargetNamespace(document);
        String string5 = this.out + FILE_SEP + this.getFolderFromURI(string4.equals("") ? NO_NAMESPACE : string4);
        if ("import".equals(string3)) {
            this.processImport(node2, string);
        } else if ("include".equals(string3)) {
            this.processInclude(document, node2, string);
        } else {
            if ("annotation".equals(string3)) {
                return;
            }
            if ("redefine".equals(string3)) {
                this.processInclude(document, node2, string);
            } else {
                String string6;
                block16: {
                    Object object;
                    String string7 = DomUtil.getAttributeValue(node2, "name");
                    string6 = string2 == null || "".equals(string2) ? string7 : string2 + "." + string7;
                    if (string6 == null) {
                        this.getListener().info("Ignoring unnamed component " + string3);
                        return;
                    }
                    if (this.verbose) {
                        object = DomUtil.getAttributeValue(document.getDocumentElement(), TARGETNAMESPACE);
                        this.getListener().info("process " + string3 + " {" + (String)object + "}" + string6 + " from file " + string);
                    }
                    new File(string5).mkdir();
                    new File(string5 + FILE_SEP + string3).mkdir();
                    object = this.getSource(document, this.getSystemId(string));
                    if (!"".equals(string2)) {
                        ((Element)node2).setAttributeNS(NAMESPACE_NAMESPACE, "xmlns:net.sf.xframe.xsddoc", XSDDOC_NAMESPACE);
                        ((Element)node2).setAttributeNS(XSDDOC_NAMESPACE, "net.sf.xframe.xsddoc:xsddocid", "a");
                    }
                    try {
                        if (this.xml) {
                            this.transform((Source)object, this.tComponent, node2, string5 + FILE_SEP + string3 + FILE_SEP + string6 + this.getExtension(), string4, string3, string6);
                        } else {
                            Node node3 = this.transform((Source)object, this.tComponent, node2, string4, string3, string6);
                            this.transform(new DOMSource(node3, DOM_PROTOCOL), this.tHtml, string5 + FILE_SEP + string3 + FILE_SEP + string6 + this.getExtension());
                        }
                    }
                    catch (Throwable throwable) {
                        Node node4 = this.createError(string4, string3, string6, throwable);
                        this.transform(new DOMSource(node4, DOM_PROTOCOL), this.tHtml, string5 + FILE_SEP + string3 + FILE_SEP + string6 + this.getExtension());
                        this.getListener().error("xsddoc caused an error: " + ExceptionUtil.getMessage(throwable));
                        if (!this.isDebug()) break block16;
                        this.getListener().debug(ExceptionUtil.printStackTrace(throwable));
                    }
                }
                if (!"".equals(string2)) {
                    ((Element)node2).removeAttributeNS(XSDDOC_NAMESPACE, XSDDOCID_ATTR);
                }
                if ("element".equals(string3) || "complexType".equals(string3) || "group".equals(string3)) {
                    this.searchLocalElementDeclarations(document, string, node, node2, string6);
                }
            }
        }
    }

    private Node createError(String string, String string2, String string3, Throwable throwable) {
        DOMImplementation dOMImplementation = this.builder.getDOMImplementation();
        Document document = dOMImplementation.createDocument(XSDDOC_NAMESPACE, "xsddoc", null);
        Element element = document.getDocumentElement();
        Element element2 = document.createElementNS(XSDDOC_NAMESPACE, "component");
        element2.setAttributeNS(null, "namespace", string);
        element2.setAttributeNS(null, "name", string3);
        element2.setAttributeNS(null, "type", string2);
        element.appendChild(element2);
        Element element3 = document.createElementNS(XSDDOC_NAMESPACE, "error");
        element2.appendChild(element3);
        Text text = document.createTextNode(ExceptionUtil.printStackTrace(throwable));
        element3.appendChild(text);
        return document;
    }

    private void searchLocalElementDeclarations(Document document, String string, Node node, Node node2, String string2) throws TransformerException, SAXException, IOException, SchemaException {
        NodeList nodeList = node2.getChildNodes();
        Node node3 = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node3 = nodeList.item(i);
            if (node3.getNodeType() != 1) continue;
            if ("element".equals(node3.getLocalName())) {
                String string3 = DomUtil.getAttributeValue(node3, "ref");
                String string4 = DomUtil.getAttributeValue(node3, "type");
                if (string3 != null || string4 != null) continue;
                this.processComponent(document, string, node, node3, string2);
                continue;
            }
            this.searchLocalElementDeclarations(document, string, node, node3, string2);
        }
    }

    private void processInclude(Document document, Node node, String string) throws SAXException, IOException, TransformerException, SchemaException {
        String string2 = DomUtil.getAttributeValue(node, "schemaLocation");
        if (string2 == null || "".equals(string2)) {
            this.getListener().error("included schema without schemaLocation");
            return;
        }
        if (this.schemaLocationProcessedMap.containsKey(string2)) {
            return;
        }
        this.schemaLocationProcessedMap.put(string2, Boolean.TRUE);
        String string3 = FileUtil.getLocation(string, string2);
        if (this.debug) {
            this.getListener().debug("process included schema " + string3);
        }
        Document document2 = this.getDocument(this.getSystemId(string3));
        boolean bl = false;
        if ("".equals(this.getTargetNamespace(document2))) {
            bl = true;
            this.setTargetNamespace(document2, this.getTargetNamespace(document));
        }
        this.processComponents(document2, string3);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            this.processComponent(document, string, node2, node2, "");
        }
        if (bl) {
            this.setTargetNamespace(document2, "");
        }
    }

    private void processImport(Node node, String string) throws SAXException, IOException, TransformerException, SchemaException {
        String string2 = DomUtil.getAttributeValue(node, "schemaLocation");
        String string3 = DomUtil.getAttributeValue(node, "namespace");
        if (string2 == null || "".equals(string2)) {
            this.getListener().error("imported schema without schemaLocation: " + string3);
            return;
        }
        if (this.schemaLocationProcessedMap.containsKey(string2)) {
            return;
        }
        this.schemaLocationProcessedMap.put(string2, Boolean.TRUE);
        String string4 = FileUtil.getLocation(string, string2);
        if (this.debug) {
            this.getListener().info("process imported schema " + string4);
        }
        if (!this.importCache.containsKey(string4)) {
            this.importCache.put(string4, string4);
            Document document = this.getDocument(this.getSystemId(string4));
            this.process(document, string4);
        } else if (this.debug) {
            this.getListener().debug("Abort import (already processed): " + string4);
        }
    }

    private void transform(Source source, Transformer transformer, String string, String string2) throws IOException, TransformerException {
        if (this.xml) {
            this.transform(source, transformer, string + FILE_SEP + string2 + this.getExtension());
        } else {
            Node node = this.transform(source, transformer);
            DomUtil.removeDuplicates(DomUtil.getFirstElementChild(node));
            this.transform(new DOMSource(node, DOM_PROTOCOL), this.tHtml, string + FILE_SEP + string2 + this.getExtension());
        }
    }

    private Node transform(Source source, Transformer transformer, Node node, String string, String string2, String string3) throws TransformerException {
        transformer.setParameter("component", node);
        transformer.setParameter("namespace", string);
        transformer.setParameter("type", string2);
        transformer.setParameter("name", string3);
        return this.transform(source, transformer);
    }

    private void transform(Source source, Transformer transformer, Node node, String string, String string2, String string3, String string4) throws FileNotFoundException, TransformerException {
        transformer.setParameter("component", node);
        transformer.setParameter("namespace", string2);
        transformer.setParameter("type", string3);
        transformer.setParameter("name", string4);
        this.transform(source, transformer, string);
    }

    private Node transform(Source source, Transformer transformer) throws TransformerException {
        DOMResult dOMResult = new DOMResult();
        this.setParameters(transformer);
        transformer.transform(source, dOMResult);
        return dOMResult.getNode();
    }

    private void transform(Source source, Transformer transformer, String string) throws FileNotFoundException, TransformerException {
        if (this.debug) {
            this.getListener().debug("create " + string);
        }
        this.setParameters(transformer);
        transformer.transform(source, new StreamResult(new FileOutputStream(string)));
    }

    private void setParameters(Transformer transformer) {
        transformer.setParameter("schemaLocation", this.mainSchemaLocation);
        transformer.setParameter("doctitle", this.doctitle);
        if (this.header != null) {
            transformer.setParameter("header", this.header);
        } else {
            transformer.setParameter("header", this.doctitle);
        }
        if (this.footer != null) {
            transformer.setParameter("footer", this.footer);
        } else {
            transformer.setParameter("footer", "");
        }
        if (this.bottom != null) {
            transformer.setParameter("bottom", this.bottom);
        } else {
            transformer.setParameter("bottom", "");
        }
        transformer.setParameter("hideSubTypes", this.hideSubTypes ? "true" : "false");
        transformer.setParameter("hideLocalUsage", this.hideLocalUsage ? "true" : "false");
        transformer.setParameter("hideTypes", this.hideTypes ? "true" : "false");
        transformer.setParameter("hideAttributes", this.hideAttributes ? "true" : "false");
        transformer.setParameter("hideGroups", this.hideGroups ? "true" : "false");
        NodeList nodeList = this.mainSchema.getChildNodes();
        transformer.setParameter("mainSchema", nodeList);
    }

    private String getSystemId(String string) throws MalformedURLException {
        if (string.indexOf(58) > 0) {
            return string;
        }
        File file = new File(string).getAbsoluteFile();
        URL uRL = file.toURL();
        String string2 = uRL.toExternalForm();
        return string2;
    }

    String getTargetNamespace(Document document) {
        String string = DomUtil.getAttributeValue(document.getDocumentElement(), TARGETNAMESPACE);
        return string == null ? "" : string;
    }

    void setTargetNamespace(Document document, String string) {
        Element element = (Element)DomUtil.getFirstElementChild(document);
        element.setAttributeNS(NAMESPACE_NAMESPACE, "xmlns", string);
        element.setAttribute(TARGETNAMESPACE, string == null ? NO_NAMESPACE : string);
    }

    private String getFolderFromURI(String string) {
        return StringUtil.replace(string, ":/\\#?&!", '_');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getResource(String string) throws IOException {
        if (this.debug) {
            this.getListener().debug("Loading resource " + string);
        }
        Processor processor = this;
        synchronized (processor) {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream == null) {
                throw new IOException("could not find resource " + string);
            }
            return inputStream;
        }
    }

    Document getDocument(String string) throws SAXException, IOException {
        String string2;
        Document document = (Document)this.schemaCache.get(string);
        if (document == null && (document = this.builder.parse(string)) != null && (string2 = this.getTargetNamespace(document)) != null && !"".equals(string2)) {
            this.schemaCache.put(string, document);
        }
        return document;
    }

    Source getSource(Document document, String string) throws SAXException, IOException {
        DOMSource dOMSource = null;
        if (dOMSource == null) {
            dOMSource = document == null ? new DOMSource(this.getDocument(string), string) : new DOMSource(document, string);
            this.sourceCache.put(string, dOMSource);
        }
        return dOMSource;
    }

    Source getResourceSource(String string, String string2) throws IOException {
        return new StreamSource(this.getResource(string), string2);
    }

    public final class ConsoleListener
    implements ProcessorListener {
        @Override
        public void debug(String string) {
            System.out.println(string);
        }

        @Override
        public void info(String string) {
            System.out.println(string);
        }

        @Override
        public void warn(String string) {
            System.out.println(string);
        }

        @Override
        public void error(String string) {
            System.out.println(string);
        }

        @Override
        public void fatal(String string) {
            System.out.println(string);
        }
    }

    private final class ProcessorErrorListener
    implements ErrorListener {
        private ProcessorErrorListener() {
        }

        @Override
        public void warning(TransformerException transformerException) {
            Processor.this.getListener().warn("xsddoc caused a warning: " + XMLUtil.getLocallizedMessageAndLocation(transformerException));
        }

        @Override
        public void error(TransformerException transformerException) {
            Processor.this.getListener().error("xsddoc caused an error: " + XMLUtil.getLocallizedMessageAndLocation(transformerException));
        }

        @Override
        public void fatalError(TransformerException transformerException) {
            Processor.this.getListener().fatal("xsddoc caused a fatal error: " + XMLUtil.getLocallizedMessageAndLocation(transformerException));
            if (Processor.this.isDebug()) {
                Processor.this.getListener().debug(ExceptionUtil.printStackTrace(transformerException));
            }
        }
    }

    private final class SchemaResolver
    implements URIResolver {
        private SchemaResolver() {
        }

        @Override
        public Source resolve(String string, String string2) throws TransformerException {
            try {
                Document document = Processor.this.getDocument(XMLUtil.getAbsoluteURI(string, string2));
                if ("".equals(Processor.this.getTargetNamespace(document))) {
                    Document document2 = Processor.this.getDocument(string2);
                    String string3 = Processor.this.getTargetNamespace(document2);
                    Processor.this.setTargetNamespace(document, string3);
                    return Processor.this.getSource(document, XMLUtil.getAbsoluteURI(string, string2));
                }
                return Processor.this.getSource(null, XMLUtil.getAbsoluteURI(string, string2));
            }
            catch (SAXException sAXException) {
                throw new TransformerException("Cannot resolve schema URI " + string + " for base URI " + string2, sAXException);
            }
            catch (IOException iOException) {
                throw new TransformerException("Cannot resolve schema URI " + string + " for base URI " + string2, iOException);
            }
        }
    }

    private final class ResourceResolver
    implements URIResolver {
        private final URIResolver schemaResolver;

        private ResourceResolver() {
            this.schemaResolver = new SchemaResolver();
        }

        @Override
        public Source resolve(String string, String string2) throws TransformerException {
            try {
                if (string == null || "".equals(string)) {
                    return null;
                }
                if (string.indexOf(":") > 0) {
                    if (string.startsWith(Processor.RESOURCE_PROTOCOL)) {
                        String string3 = string.substring(string2.indexOf(":") + 1);
                        return Processor.this.getResourceSource(string3, string);
                    }
                } else if (string2 != null && string2.startsWith(Processor.RESOURCE_PROTOCOL)) {
                    String string4 = string2.substring(string2.indexOf(":") + 1);
                    String string5 = string4.substring(0, string4.lastIndexOf("/") + 1) + string;
                    return Processor.this.getResourceSource(string5, Processor.RESOURCE_PROTOCOL + string5);
                }
                return this.schemaResolver.resolve(string, string2);
            }
            catch (IOException iOException) {
                throw new TransformerException("Cannot resolve URI " + string + " for base URI " + string2, iOException);
            }
        }
    }
}

