/* $Id: color.h,v 1.27 2005/07/29 16:50:30 ellson Exp $ $Revision: 1.27 $ */
/* vim:set shiftwidth=4 ts=8: */

/**********************************************************
*      This software is part of the graphviz package      *
*                http://www.graphviz.org/                 *
*                                                         *
*            Copyright (c) 1994-2004 AT&T Corp.           *
*                and is licensed under the                *
*            Common Public License, Version 1.0           *
*                      by AT&T Corp.                      *
*                                                         *
*        Information and Software Systems Research        *
*              AT&T Research, Florham Park NJ             *
**********************************************************/

#ifndef GV_COLOR_H
#define GV_COLOR_H

#include "arith.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct hsbcolor_t {
    char *name;
    unsigned char h, s, b;
} hsbcolor_t;

/* possible representations of color in color_t */
typedef enum { HSV_DOUBLE, RGBA_BYTE, RGBA_WORD, CMYK_BYTE,
		RGBA_DOUBLE, COLOR_STRING, COLOR_INDEX } color_type_t;

/* color_t can hold a color spec in a choice or representations */
typedef struct color_s {
    union {
	double RGBA[4];
	double HSV[3];
	unsigned char rgba[4];
	unsigned char cmyk[4];
	int rrggbbaa[4];
	char *string;
	int index;
    } u;
    color_type_t type;
} color_t;

#define COLOR_MALLOC_FAIL -1
#define COLOR_UNKNOWN 1
#define COLOR_OK 0

#ifdef __cplusplus
}
#endif
#endif
