/******************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: lcubootAutoLcc.c,v 1.2 2008/10/27 14:53:57 bjeram Exp $"
*
* who       when      what
* --------  --------  ----------------------------------------------
* bgustafs 2002-07-08 corrected previous change
* bgustafs 2002-07-05 Register only existing devices
* S.Sandrock 23.04.1995 New
*/

/************************************************************************
*   NAME
*	lcubootAutoLcc,
*	lcubootAutoLccRegisterDevs
*	- Automatic LCU Installation Support Facility for LCC
*
*   SYNOPSIS
*	int lcubootAutoLccRegisterDevs(void)
*
*   DESCRIPTION
*	These functions support the automatic installation of LCC,
*	especially for devices. All functions are intended to be
*	used directly from the VxWorks shell in a boot-script.
*
*	The script is aborted when a fatal error condition occurs, which
*	is signalled as a log message in the form:
*
*	<tid> (tShell): lcuboot: <message>: <faulty item>:<errno | faulty item>
*	<tid> (tShell): --- SCRIPT ABORTED ---
*
*	lcubootAutoLccRegisterDevs - register all devices under LCC that were 
*		previously announced with `lcubootAutoDevRegister'.
*
*		The number of registered devices is returned.
*		The script is aborted when a call to `lccRegisterDevice' fails.
*
*   VARIABLES
*
*   FILES
*
*   ENVIRONMENT
*
*   COMMANDS
*
*   RETURN VALUES
*
*   CAUTIONS 
*	Most functions are not reentrant and should therefore only be used
*	from LCU boot-scripts, where reentrancy is not important!
*
*   EXAMPLES
*
*   SEE ALSO
*	lcubootAutoEnv(1), lcubootAutoGen(1), lcubootAutoDrv(1), 
*	loadLib(1), symLib(1),
*	ld(2)
*
*   BUGS   
* 
*------------------------------------------------------------------------
*/

#include "lcubootPrivate.h"

#include "ccs.h" /* only necessary for SUCCESS macro and ccsERROR */


int lcubootAutoLccRegisterDevs(void)
{
    lcubootDEV_LIST *p;
    ccsERROR error;
    int i, regCount = 0;
    int fd;

    for (i=0; i<lcubootAutoDevListCount; i++)
	{
	p = &lcubootAutoDevList[i];

	/*
	 * Open device to check if the device exists
	 * Open-mode corresponds to lcudrvOPEN_READONLY
	 */
	fd = open(p->devName, 1, 0644);
	if (fd > 0)
	  {
	    close(fd);
	  }

	if (p->devName != NULL && 
	    lcubootProbeAddress(p->probeAddr) == lcubootOK &&
	    fd > 0)
	    {
	    if (lcubootAutoExec(1, "lccRegisterDevice", 
				(int)(p->devName), (int)(p->probeAddr),
				p->lccArg1, p->lccArg2, p->lccArg3, 
				(int)&error, 0, 0)
		!= SUCCESS)
		RETURN_ABORT("could not register device in LCC", p->devName);
	    ++regCount;
	    }
	}
    return regCount;
}


/*___oOo___*/
