/*****************************************************************************
**
* E.S.O. - VLT project
*
* @(#) $ID: $
*
* who       when      what
* --------  --------  ----------------------------------------------
* mnastvog  27/06/95  created
*/
/*************************************************************************/
#include "vltPort.h"


static char *rcsId="@(#) $Id: x_one.c,v 1.1.1.1 2003/05/28 16:58:56 gchiozzi Exp $";
static void *use_rcsId = (&use_rcsId,(void *) &rcsId);
/* file: x_pm.c
** sccs: @(#)x_pm.c UW-SAL 1.1 (1/2/94)
** Copyright 1992,1993 University of Wisconsin
** *******************************************************************
** Space Astronomy Laboratory
** University of Wisconsin
** 1150 University Avenue
** Madison, WI 53706 USA
** *******************************************************************
** Do not use this software without permission.
** Do not use this software without attribution.
** Do not remove or alter any of the lines above.
** *******************************************************************
*/
#ifndef lint
static char *sccs = "@(#)x_pm.c UW-SAL 1.1 (1/2/94)";
#endif

/*
** *******************************************************************
** x_pm - test the pointing machine
** *******************************************************************
*/

#define _INCLUDE_HPUX_SOURCE
/*#include "time.h"*/
/*#include "timexLib.h"*/
#undef _INCLUDE_HPUX_SOURCE
#include "astro.h"
#include "slalib.h"
#include "slamac.h"
/*#define DEBUG*/
#undef DEBUG
#undef TIMER 
#define TIMER

double amprms[21]; /* global data array */
double aoprms[14]; /* global data array */

void loop_mapqk(double * rm,double * dm,double * ra,double * da)
    {
    slaMapqk(*rm,*dm,0.0,0.0,0.0,0.0,amprms,ra,da);
    }
void loop_aoppat(struct s_tstate * p)
    {
    slaAoppat(p->utc,aoprms);
    }
void loop_aopqk(double * ra,double * da)
    {
    double aob,hob,zob,rob,dob;

    slaAopqk(*ra,*da,aoprms,&aob,&zob,&hob,&dob,&rob);
    }

void
get_tstate(p)
struct s_tstate *p;
{
#ifdef MAKE_VXWORKS
    time_t tv;
#else
    struct timeval tv;
    struct timezone tz;
#endif
#ifdef DEBUG
    (void)fprintf(stdout, "x_pm: compute the tstate\n");
#endif

    /*************************/
    /* fetch the current UTC */
    /*************************/
    time(&tv);
/* ??? */
    (void)fprintf(stdout, "x_pm: time: %d\n",tv);
    /*  constant for 1 Jan 1970! */
    p->utc = 2440587.5 + ((double)tv / 86400) - 2400000.5;
/*    p->utc = 49328.0 + 2400000.5;*/ /*mjd???*/
    /* 1984.5 as MJD*/
    p->utc = slaEpj2d(1984.5);
/*    p->utc = 2445882.5 - 2400000.5; */
#if 1
    (void)fprintf(stdout, "x_pm: tstate %7s: %.15e %s\n",
	"utc", p->utc, fmt_j(p->utc));
#endif

    /*******************************/
    /* compute the dynamical times */
    /*******************************/
    p->tai = p->utc + (p->delta_at/86400.0);
    p->tdt = p->tai + (32.184/86400);
    p->tdb = tdt2tdb(p->tdt);  
    (void)fprintf(stdout, "x_pm: tdb: %f\n",p->tdb);
/*    p->tdb = p->tdt;  is this allowed?*/ 
#ifdef DEBUG
    (void)fprintf(stdout, "x_pm: tstate %7s: %.15e %s\n",
	"tai", p->tai, fmt_j(p->tai));
    (void)fprintf(stdout, "x_pm: tstate %7s: %.15e %s\n",
	"tdt", p->tdt, fmt_j(p->tdt));
    (void)fprintf(stdout, "x_pm: tstate %7s: %.15e %s\n",
	"tdb", p->tdb, fmt_j(p->tdb));
#endif

    /**************************************/
    /* compute the geometrical quantities */
    /**************************************/
    (void)fprintf(stdout, "x_pm: timing slaMappa, time %f\n",slaEpj2d(2000.0));
    slaMappa(2000.0,p->tdb,amprms);
    (void)fprintf(stdout, "x_pm: timing slaAoppa,tdb = %f, delta = %f\n",
               p->tdb,p->delta_ut);
    slaAoppa(p->utc,p->delta_ut,p->lon,p->lat,p->alt,p->xpole,p->ypole,
             p->T,p->P,p->H,p->wavelength,0.0065,aoprms);
#if 1
    (void)fprintf(stdout, "x_pm: tstate %7s: %.15e %s\n",
	"gast", aoprms[12], fmt_j(aoprms[12]));
    (void)fprintf(stdout, "x_pm: tstate %7s: %.15e %s\n",
	"last", aoprms[13], fmt_j(aoprms[13]));
#endif
    return;
}


#ifdef MAKE_VXWORKS
x_pm()
#else
main()
#endif
{
    double ep;
    double eq;
#ifdef TIMER 
#ifdef MAKE_VXWORKS
    time_t tv;
    char timeBuffer[80];
#else
    struct timeval tv;
    struct timezone tz;
#endif
#endif
    int i;
    int s1;	/* start state */
    int s2;	/* end state */
    struct s_tstate tstate;
    struct s_v6 pvec[N_PM_STATES];
    struct s_v6 targ;
    int status;
    char sign;
    int idmsf[4];
    double rm,dm,ra,da,aob,hob,zob,rob,dob;
    /**********************/
    /* compute the tstate */
    /**********************/
    tstate.delta_at = 28;
    tstate.delta_ut = 0.5;
    tstate.lon = -1.5;
    tstate.lat = 0.8;
    tstate.alt = 359.0;
    tstate.xpole = 0.0;
    tstate.ypole = 0.0;
    tstate.T = 273.0;
    tstate.P = 960.0;
    tstate.H = 0.1;
    tstate.wavelength = 0.55;
#ifdef DEBUG
    (void)fprintf(stdout, "x_pm: delta_at %d\n", tstate.delta_at);
    (void)fprintf(stdout, "x_pm: delta_ut %.15e\n", tstate.delta_ut);
    (void)fprintf(stdout, "x_pm: lon %.15e\n", tstate.lon);
    (void)fprintf(stdout, "x_pm: lat %.15e\n", tstate.lat);
    (void)fprintf(stdout, "x_pm: alt %.15e\n", tstate.alt);
    (void)fprintf(stdout, "x_pm: xpole %.15e\n", tstate.xpole);
    (void)fprintf(stdout, "x_pm: ypole %.15e\n", tstate.ypole);
    (void)fprintf(stdout, "x_pm: T %.15e\n", tstate.T);
    (void)fprintf(stdout, "x_pm: P %.15e\n", tstate.P);
    (void)fprintf(stdout, "x_pm: H %.15e\n", tstate.H);
    (void)fprintf(stdout, "x_pm: wavelength %.15e\n", tstate.wavelength);
#endif
#ifdef TIMER 
    (void)fprintf(stdout, "x_pm: Measurement of timing slalib\n");
    (void)fprintf(stdout, "x_pm:  ...get_tstate function\n");
#endif
    get_tstate(&tstate);
    targ = v6init(POLAR);
    v6SetR(targ, 206265.0);	/* 1 pc for now */
    v6SetAlpha(targ, 2.0);
    v6SetDelta(targ, 1.0);
    eq = y2j(1995.5); /* to get the actual value */
    ep = eq;

    s1 = PM_S02;
    s2 = PM_S19;
 
#ifdef TIMER 
    (void)fprintf(stdout, "x_pm: timing slaMapqk\n");
#endif
#if 0
    slaDtf2r(0,48,40.95,&rm,&status); /*delta pisc*/
    slaDaf2r(7,35,6.14,&dm,&status);
#else
    slaDtf2r(0,11,44.014,&rm,&status); /*theta scl*/
    slaDaf2r(35,7,59.17,&dm,&status);
    dm = dm - 2 * DPI;
#endif
    timexN(loop_mapqk,&rm,&dm,&ra,&da,NULL,NULL,NULL,NULL);
    (void)fprintf(stdout, "x_pm: timing slaAoppat\n");
    timexN(loop_aoppat,&tstate,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
    (void)fprintf(stdout, "x_pm: timing slaAopqk\n");
    timexN(loop_aopqk,&ra,&da,NULL,NULL,NULL,NULL,NULL,NULL);
#if 1
    (void)fprintf(stdout, "x_pm: refa: %e refb: %e\n",
             aoprms[10],aoprms[11]);
    slaMapqk(rm,dm,0.0,0.0,0.0,0.0,amprms,&ra,&da);
    slaDr2tf(3,ra,&sign,idmsf);
    (void)fprintf(stdout, "x_pm: mean: %e %e,last %e\n",rm,dm,aoprms[13]);
    slaAoppat(tstate.utc,aoprms);
    (void)fprintf(stdout, "x_pm: tstate %7s: %.15e %s\n",
	"last", aoprms[13], fmt_j(aoprms[13]));
    (void)fprintf(stdout, "x_pm: apparent d %f %c%02dd %02dm %02ds.%03d\n",
                  ra,sign,idmsf[0],idmsf[1],idmsf[2],idmsf[3]);
    slaDr2af(3,da,&sign,idmsf);
    (void)fprintf(stdout, 
                  "x_pm: apparent r %f %c%02dd %02dm %02ds.%03d\n",
                  da,sign,idmsf[0],idmsf[1],idmsf[2],idmsf[3]);
    (void)fprintf(stdout, "x_pm: timing slaAopqk\n");
        slaAopqk(ra,da,aoprms,&aob,&zob,&hob,&dob,&rob);
    (void)fprintf(stdout, "x_pm: az %f,zd %f, ha %f, d %f r %f\n",
		aob,zob,hob,dob,rob);
#endif
    return(0);
}




