/*******************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: rtlogTimeDataThread.cpp,v 1.6 2009/10/07 09:31:36 bjeram Exp $"
*
* who       when        what
* --------  ----------  ----------------------------------------------
* bjeram  yyyy-mm-dd  created 
*/

#define _POSIX_SOURCE 1
#include "vltPort.h"

static char *rcsId="@(#) $Id: rtlogTimeDataThread.cpp,v 1.6 2009/10/07 09:31:36 bjeram Exp $"; 
static void *use_rcsId = ((void)&use_rcsId,(void *) &rcsId);

#include "rtlogTimeDataThread.h"
#include <ACSErrTypeCommon.h>

//--------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------
/// implementation of TimeDataThread

TimeDataThread::TimeDataThread(const ACE_CString &_name)
  : ACS::Thread(_name, 200*1000*1000/*20s*/, 100*1000*1000/*=10s*/)
{
    ACS_TRACE("TimeDataThread::TimeDataThread");

    m_timeData.cpu_on_last_te = 0;
    m_timeData.cpu_hz = 0;
    m_timeData.ticks = 0;
    m_timeData.t0 =0;

    // here we check if RT task with _name already exist
    if (rt_get_adr(nam2num(_name.c_str())))
	{
	throw ACSErrTypeCommon::CouldntCreateThreadExImpl(__FILE__, __LINE__, "TimeDataThread::TimeDataThread");
	}
}//TimeDataThread

void TimeDataThread::onStart()
{
    ACS_TRACE("TimeDataThread::onStart");
 
    rt_allow_nonroot_hrt();
    /*    if ( mlockall(MCL_CURRENT) != 0)
	{
	// here we can just log error message
	ACS_LOG(LM_FULL_INFO, "TimeDataThread::onStart", (LM_ERROR, "Problem locking memory"));
	}
    */

    if (!(m_task = rt_task_init_schmod(nam2num(getName().c_str()), 10, 0, 0, SCHED_FIFO, 0xFF)))
	{
	ACS_LOG(LM_SOURCE_INFO, "TimeDataThread::runLoop",
		(LM_ERROR, "can not create LXRT task")); //TBD: replace with AES ?
	return;
	};//if
}//onStart

void TimeDataThread::onStop()
{
 ACS_TRACE("TimeDataThread::onStop");
 
 rt_task_delete(m_task);
}//onStop


void TimeDataThread::setTimeData(rtLogTimeData_t &td)
{
    ACE_Guard<ACE_Recursive_Thread_Mutex> guard(m_TDMutex);

    m_timeData = td; // mutex is automatically released
}//setTimeData

rtLogTimeData_t TimeDataThread::getTimeData()
{
    ACE_Guard<ACE_Recursive_Thread_Mutex> guard(m_TDMutex);

    return m_timeData; // mutex is automatically released
}//getTimeData

void TimeDataThread::runLoop()
{
   
    rtlogGetTimeData(&m_timeData); // call to kernel space using LXRT
    
/*  printf("X==> cpu_on_last_te: %lld cpu_hz: %d ticks: %d t0: %lld \n",
		   m_timeData.cpu_on_last_te,
		   m_timeData.cpu_hz,
		   m_timeData.ticks,
		   m_timeData.t0);
*/
    setTimeData(m_timeData);
}//TimeDataThread::runLoop

/*___oOo___*/
