/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 *
 * File CorbaPublisher.java
 */
 
//package alma.scheduling.define.nc;
package alma.acs.nc;

import org.omg.CORBA.portable.IDLEntity;

import alma.acs.container.ContainerServicesBase;
import alma.acs.exceptions.AcsJException;

/**
 * The CorbaPublisher class implements those methods needed to craft a publisher
 * that publishes events to a CORBA notification channel.
 * 
 * @deprecated since ACS 8.0.1, see COMP-1786. This class adds no functionality to SimpleSupplier and will be removed later.
 * @version 1.00 Apr 10, 2003
 * @author Allen Farris
 */
public class CorbaPublisher extends SimpleSupplier {
	
	/**
	 * The parameters are:
	 * @param channelName
	 *            the name of the channel -- e.g., Progress
	 * @param cs
	 *            container services
	 * @throws AcsJException
	 */
	public CorbaPublisher(String channelName, ContainerServicesBase cs) throws AcsJException {
		super(channelName, cs);
	}

	/**
	 * The parameters are:
	 * 
	 * @param channelName
	 *            the name of the channel -- e.g., Progress
	 * @param channelNotifyDomaiName
	 *            the name of notify. service domain -- e.g., ALARMSYSTEM
	 * @param cs
	 *            container services
	 * @throws AcsJException
	 */
	public CorbaPublisher(String channelName, String channelNotifyDomaiName, ContainerServicesBase cs)
			throws AcsJException {
		super(channelName, channelNotifyDomaiName, cs);
	}

	/**
	 * This is the main method for publishing an event. The IDLEntity must be the IDL structure that defines the event
	 * data. It must match the names of the events in the list when the channel was created.
	 * 
	 * @param event
	 *            an IDLEntity to publish
	 * @throws AcsJException 
	 */
	public final void publish(IDLEntity event) throws AcsJException {
		super.publishEvent(event);
	}

	/**
	 * Returns the name of the channel.
	 * @return Name of the channel.
	 */
	public String getChannelName() {
		return m_channelName;
	}

}
