package alma.test.corbareftest;

import si.ijs.maci.ClientInfo;
import si.ijs.maci.ComponentInfo;
import si.ijs.maci.ContainerInfo;

/**
 * The listener of events generated by the administrator client
 * 
 * @author almadev
 *
 */
public interface AdministratorListener {

	/**
	 * Called if container logged in
	 * 
	 * @param contInfo The container 
	 */
	public void containerLoggedIn(ContainerInfo contInfo);
	
	/**
	 * Called if container logged out
	 * 
	 * @param contHandle The handle of the container 
Ha chiama	 */
	public void containerLoggedOut(int conthandle);
	
	/**
	 * Called if a component logged in or when a client requested
	 * a component
	 * 
	 * @param contInfo The component
	 */
	public void componentLoggedIn(ComponentInfo compInfo);
	
	/**
	 * Called when a client released a component.
	 * If this method is called it means that the component
	 * is still alive (used by some client)
	 * 
	 * @param compInfo The released component
	 */
	public void componentReleased(ComponentInfo compInfo);
	
	/**
	 * Called if component logged out
	 * 
	 * @param comphandle The handle of the component
	 */
	public void componentLoggedOut(int comphandle);
	
	/**
	 * Called if a client logged in
	 * 
	 * @param contInfo The container 
	 */
	public void clientLoggedIn(ClientInfo clientInfo);
	
	/**
	 * Called if a client logged in
	 * 
	 * @param clientHandle The handle of the client 
	 */
	public void clientLoggedOut(int clientHandle);
}
