package cern.laser.guiplatform.windows.search;

import java.util.Arrays;
import java.util.Iterator;

import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

import cern.laser.client.LaserException;
import cern.laser.client.LaserTimeOutException;
import cern.laser.client.data.Category;
import cern.laser.client.impl.services.selection.CategorySelectionImpl;
import cern.laser.client.impl.services.selection.SelectionImpl;
import cern.laser.client.services.selection.AlarmSelectionHandler;
import cern.laser.client.services.selection.CategorySelection;
import cern.laser.client.services.selection.Selection;
import cern.laser.guiplatform.alarms.AlarmBean;
import cern.laser.guiplatform.alarms.AlarmContainer;
import cern.laser.guiplatform.alarms.AlarmNodeManager;
import cern.laser.guiplatform.alarms.AlarmSelectionHandlerFactory;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.Constants;
import cern.laser.guiplatform.util.SearchProxyBuffer;
import cern.laser.guiplatform.windows.ActiveListExplorerPanel;

// As needed:
/*
import java.io.*;
import java.net.*;
import org.openide.ErrorManager;
import org.openide.actions.*;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.actions.*;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.io.*;
 */

/** An openable window available to the IDE's window manager.
 *
 * @author woloszyn
 */
public class SearchWindow extends TopComponent /* or CloneableTopComponent */ {
    
	Selection selection; // selection used by BL to perform search
    int windowMode; // search window mode
    SearchWindowSettings settings; // search window settings
    
    Logger logger = Logger.getLogger(this.getClass().getName());
    
    /**
     * Default constructor
     */
    public SearchWindow() {
        this(Constants.SEARCH_WINDOW_MODE_SEARCH_ACTIVE_LIST, null);
        
    }
    /** Constructor
     * @param windowMode mode of window, can be: Constants.SEARCH_WINDOW_MODE_ARCHIVE_SEARCH
     * SEARCH_WINDOW_MODE_GET_ALARMINFO, SEARCH_WINDOW_MODE_SEARCH_ACTIVE_LIST
     * @param selection collection of CategoryBeans used by BL to perform search
     */
    public SearchWindow(int windowMode, Category [] choosenCategories) {
        // mm Selection object FIXED
    	this.selection = new SelectionImpl();
        CategorySelection cs = new CategorySelectionImpl();
        cs.addAll(Arrays.asList(choosenCategories));
        selection.setCategorySelection(cs);
        
        this.windowMode = windowMode;
        this.settings = AppRegister.getInstance().getSearchWindowSettings(windowMode);
        
        initComponents();
        setCloseOperation(CLOSE_LAST);
        switch( windowMode ) {
            case Constants.SEARCH_WINDOW_MODE_ARCHIVE_SEARCH :
                setName(NbBundle.getMessage(SearchWindow.class, "LBL_search_component_name_archive"));
                break;
            case Constants.SEARCH_WINDOW_MODE_GET_ALARMINFO :
                setName(NbBundle.getMessage(SearchWindow.class, "LBL_search_component_name_alarminfo"));
                break;
            case Constants.SEARCH_WINDOW_MODE_SEARCH_ACTIVE_LIST :
                setName(NbBundle.getMessage(SearchWindow.class, "LBL_search_component_name_search"));
                break;
            default:
                setName("No label found, check Bundle file!");
        }
    }
    
    
    public HelpCtx getHelpCtx() {
        return new HelpCtx(SearchWindow.class);
    }
    
    
    /*
    // If you are using CloneableTopComponent, probably you should override:
    protected CloneableTopComponent createClonedObject() {
        return new SearchWindow();
    }
    protected boolean closeLast() {
        // You might want to prompt the user first and maybe return false:
        return true;
    }
     */
    
    // APPEARANCE
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        SNFFbuttonGroup = new javax.swing.ButtonGroup();
        IFMbuttonGroup = new javax.swing.ButtonGroup();
        PDFCbuttonGroup = new javax.swing.ButtonGroup();
        sortOptionButtonGroup = new javax.swing.ButtonGroup();
        hostNameButtonGroup = new javax.swing.ButtonGroup();
        buttonsPanel = new javax.swing.JPanel();
        searchButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        mainPanel = new javax.swing.JPanel();
        upperMainPanel = new javax.swing.JPanel();
        SNFFpanel = new javax.swing.JPanel();
        SNFFallRadioButton = new javax.swing.JRadioButton();
        SNFFequalsRadioButton = new javax.swing.JRadioButton();
        SNFFcontainsRadioButton = new javax.swing.JRadioButton();
        SNFFtextField = new javax.swing.JTextField();
        IFMpanel = new javax.swing.JPanel();
        IFMallRadioButton = new javax.swing.JRadioButton();
        IFMequalsRadioButton = new javax.swing.JRadioButton();
        IFMcontainsRadioButton = new javax.swing.JRadioButton();
        IFMtextField = new javax.swing.JTextField();
        PDFCpanel = new javax.swing.JPanel();
        PDFCallRadioButton = new javax.swing.JRadioButton();
        PDFCequalsRadioButton = new javax.swing.JRadioButton();
        PDFCcontainsRadioButton = new javax.swing.JRadioButton();
        PDFCtextField = new javax.swing.JTextField();
        priorityPanel = new javax.swing.JPanel();
        priorityLevel0checkBox = new javax.swing.JCheckBox();
        priorityLevel1checkBox = new javax.swing.JCheckBox();
        priorityLevel2checkBox = new javax.swing.JCheckBox();
        priorityLevel3checkBox = new javax.swing.JCheckBox();
        bottomMainPanel = new javax.swing.JPanel();
        timestampPanel = new javax.swing.JPanel();
        timestampLabel1 = new javax.swing.JLabel();
        timestampAfterTextField = new javax.swing.JTextField();
        timestampLabel2 = new javax.swing.JLabel();
        timestampBeforeTextField = new javax.swing.JTextField();
        statusPanel = new javax.swing.JPanel();
        statusActiveCheckBox = new javax.swing.JCheckBox();
        statusAcknowledgedCheckBox = new javax.swing.JCheckBox();
        statusHighlightedCheckBox = new javax.swing.JCheckBox();
        statusMaskedCheckBox = new javax.swing.JCheckBox();
        statusTerminatedCheckBox = new javax.swing.JCheckBox();
        sortOptionPanel = new javax.swing.JPanel();
        sortByTimeRadioButton = new javax.swing.JRadioButton();
        sortByPriorityRadioButton = new javax.swing.JRadioButton();
        sortGroupNTRadioButton = new javax.swing.JRadioButton();
        sortGroupNTbyPriorityRadioButton = new javax.swing.JRadioButton();
        hostNamePanel = new javax.swing.JPanel();
        hostNameAllRadioButton = new javax.swing.JRadioButton();
        hostNameEqualsRadioButton = new javax.swing.JRadioButton();
        hostNameTextField = new javax.swing.JTextField();

        setLayout(new java.awt.BorderLayout());

        setMinimumSize(new java.awt.Dimension(400, 277));
        setPreferredSize(new java.awt.Dimension(630, 380));
        addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentShown(java.awt.event.ComponentEvent evt) {
                formComponentShown(evt);
            }
        });

        buttonsPanel.setToolTipText("");
        searchButton.setFont(new java.awt.Font("Dialog", 0, 12));
        searchButton.setText("Search");
        searchButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                searchButtonActionPerformed(evt);
            }
        });

        buttonsPanel.add(searchButton);

        cancelButton.setFont(new java.awt.Font("Dialog", 0, 12));
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        buttonsPanel.add(cancelButton);

        jButton1.setFont(new java.awt.Font("Dialog", 0, 12));
        jButton1.setText("Switch");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        buttonsPanel.add(jButton1);

        jButton2.setText("TEST IT");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        buttonsPanel.add(jButton2);

        add(buttonsPanel, java.awt.BorderLayout.SOUTH);

        mainPanel.setLayout(new java.awt.GridLayout(0, 1));

        mainPanel.setBorder(new javax.swing.border.TitledBorder(""));
        upperMainPanel.setLayout(new java.awt.GridLayout(1, 0));

        SNFFpanel.setLayout(new java.awt.GridLayout(0, 1));

        SNFFpanel.setBorder(new javax.swing.border.TitledBorder("System Name"));
        SNFFallRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        SNFFallRadioButton.setText("All");
        SNFFbuttonGroup.add(SNFFallRadioButton);
        if( settings.getSNFFState() == SearchWindowSettings.ID_ALL ) {
            SNFFallRadioButton.setSelected(true);
        }
        else {
            SNFFallRadioButton.setSelected(false);
        }
        SNFFallRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                SNFFallRadioButtonActionPerformed(evt);
            }
        });

        SNFFpanel.add(SNFFallRadioButton);

        SNFFequalsRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        SNFFequalsRadioButton.setText("Equals");
        SNFFbuttonGroup.add(SNFFequalsRadioButton);
        if( settings.getSNFFState() == SearchWindowSettings.ID_EQUAL ) {
            SNFFequalsRadioButton.setSelected(true);
        }
        else {
            SNFFequalsRadioButton.setSelected(false);
        }
        SNFFequalsRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                SNFFequalsRadioButtonActionPerformed(evt);
            }
        });

        SNFFpanel.add(SNFFequalsRadioButton);

        SNFFcontainsRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        SNFFcontainsRadioButton.setText("Contains");
        SNFFbuttonGroup.add(SNFFcontainsRadioButton);
        if( settings.getSNFFState() == SearchWindowSettings.ID_CONTAINS ) {
            SNFFcontainsRadioButton.setSelected(true);
        }
        else {
            SNFFcontainsRadioButton.setSelected(false);
        }
        SNFFcontainsRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                SNFFcontainsRadioButtonActionPerformed(evt);
            }
        });

        SNFFpanel.add(SNFFcontainsRadioButton);

        SNFFtextField.setText(settings.getSNFFContains());
        if( SNFFcontainsRadioButton.isSelected() || SNFFequalsRadioButton.isSelected() ) {
            SNFFtextField.setEnabled(true);
        }
        else {
            SNFFtextField.setEnabled(false);
        }
        SNFFtextField.addCaretListener(new javax.swing.event.CaretListener() {
            public void caretUpdate(javax.swing.event.CaretEvent evt) {
                SNFFtextFieldCaretUpdate(evt);
            }
        });

        SNFFpanel.add(SNFFtextField);

        upperMainPanel.add(SNFFpanel);

        IFMpanel.setLayout(new java.awt.GridLayout(0, 1));

        IFMpanel.setBorder(new javax.swing.border.TitledBorder("Identifier"));
        IFMallRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        IFMallRadioButton.setText("All");
        IFMbuttonGroup.add(IFMallRadioButton);
        if( settings.getIFMState() == SearchWindowSettings.ID_ALL ) {
            IFMallRadioButton.setSelected(true);
        }
        else {
            IFMallRadioButton.setSelected(false);
        }
        IFMallRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                IFMallRadioButtonActionPerformed(evt);
            }
        });

        IFMpanel.add(IFMallRadioButton);

        IFMequalsRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        IFMequalsRadioButton.setText("Equals");
        IFMbuttonGroup.add(IFMequalsRadioButton);
        if( settings.getIFMState() == SearchWindowSettings.ID_EQUAL ) {
            IFMequalsRadioButton.setSelected(true);
        }
        else {
            IFMequalsRadioButton.setSelected(false);
        }
        IFMequalsRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                IFMequalsRadioButtonActionPerformed(evt);
            }
        });

        IFMpanel.add(IFMequalsRadioButton);

        IFMcontainsRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        IFMcontainsRadioButton.setText("Contains");
        IFMbuttonGroup.add(IFMcontainsRadioButton);
        if( settings.getIFMState() == SearchWindowSettings.ID_CONTAINS ) {
            IFMcontainsRadioButton.setSelected(true);
        }
        else {
            IFMcontainsRadioButton.setSelected(false);
        }
        IFMcontainsRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                IFMcontainsRadioButtonActionPerformed(evt);
            }
        });

        IFMpanel.add(IFMcontainsRadioButton);

        IFMtextField.setText(settings.getIFMContains());
        if( IFMcontainsRadioButton.isSelected() || IFMequalsRadioButton.isSelected() ) {
            IFMtextField.setEnabled(true);
        }
        else {
            IFMtextField.setEnabled(false);
        }
        IFMtextField.addCaretListener(new javax.swing.event.CaretListener() {
            public void caretUpdate(javax.swing.event.CaretEvent evt) {
                IFMtextFieldCaretUpdate(evt);
            }
        });

        IFMpanel.add(IFMtextField);

        upperMainPanel.add(IFMpanel);

        PDFCpanel.setLayout(new java.awt.GridLayout(0, 1));

        PDFCpanel.setBorder(new javax.swing.border.TitledBorder("Problem description"));
        PDFCallRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        PDFCallRadioButton.setText("All");
        PDFCbuttonGroup.add(PDFCallRadioButton);
        if( settings.getPDFCState() == SearchWindowSettings.ID_ALL ) {
            PDFCallRadioButton.setSelected(true);
        }
        else {
            PDFCallRadioButton.setSelected(false);
        }
        PDFCallRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                PDFCallRadioButtonActionPerformed(evt);
            }
        });

        PDFCpanel.add(PDFCallRadioButton);

        PDFCequalsRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        PDFCequalsRadioButton.setText("Equals");
        PDFCbuttonGroup.add(PDFCequalsRadioButton);
        if( settings.getPDFCState() == SearchWindowSettings.ID_EQUAL ) {
            PDFCequalsRadioButton.setSelected(true);
        }
        else {
            PDFCequalsRadioButton.setSelected(false);
        }
        PDFCequalsRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                PDFCequalsRadioButtonActionPerformed(evt);
            }
        });

        PDFCpanel.add(PDFCequalsRadioButton);

        PDFCcontainsRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        PDFCcontainsRadioButton.setText("Contains");
        PDFCbuttonGroup.add(PDFCcontainsRadioButton);
        if( settings.getPDFCState() == SearchWindowSettings.ID_CONTAINS ) {
            PDFCcontainsRadioButton.setSelected(true);
        }
        else {
            PDFCcontainsRadioButton.setSelected(false);
        }
        PDFCcontainsRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                PDFCcontainsRadioButtonActionPerformed(evt);
            }
        });

        PDFCpanel.add(PDFCcontainsRadioButton);

        PDFCtextField.setText(settings.getPDFCContains());
        if( PDFCcontainsRadioButton.isSelected() || PDFCequalsRadioButton.isSelected() ) {
            PDFCtextField.setEnabled(true);
        }
        else {
            PDFCtextField.setEnabled(false);
        }
        PDFCtextField.addCaretListener(new javax.swing.event.CaretListener() {
            public void caretUpdate(javax.swing.event.CaretEvent evt) {
                PDFCtextFieldCaretUpdate(evt);
            }
        });

        PDFCpanel.add(PDFCtextField);

        upperMainPanel.add(PDFCpanel);

        priorityPanel.setLayout(new java.awt.GridLayout(0, 1));

        priorityPanel.setBorder(new javax.swing.border.TitledBorder("Priority"));
        priorityLevel0checkBox.setFont(new java.awt.Font("Dialog", 0, 12));
        priorityLevel0checkBox.setText("Level 0");
        if ( settings.getPriority_0() ) {
            priorityLevel0checkBox.setSelected(true);
        }
        else {
            priorityLevel0checkBox.setSelected(false);
        }
        priorityLevel0checkBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                priorityLevel0checkBoxActionPerformed(evt);
            }
        });

        priorityPanel.add(priorityLevel0checkBox);

        priorityLevel1checkBox.setFont(new java.awt.Font("Dialog", 0, 12));
        priorityLevel1checkBox.setText("Level 1");
        if ( settings.getPriority_1() ) {
            priorityLevel1checkBox.setSelected(true);
        }
        else {
            priorityLevel1checkBox.setSelected(false);
        }
        priorityLevel1checkBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                priorityLevel1checkBoxActionPerformed(evt);
            }
        });

        priorityPanel.add(priorityLevel1checkBox);

        priorityLevel2checkBox.setFont(new java.awt.Font("Dialog", 0, 12));
        priorityLevel2checkBox.setText("Level 2");
        if ( settings.getPriority_2() ) {
            priorityLevel2checkBox.setSelected(true);
        }
        else {
            priorityLevel2checkBox.setSelected(false);
        }
        priorityLevel2checkBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                priorityLevel2checkBoxActionPerformed(evt);
            }
        });

        priorityPanel.add(priorityLevel2checkBox);

        priorityLevel3checkBox.setFont(new java.awt.Font("Dialog", 0, 12));
        priorityLevel3checkBox.setText("Level 3");
        if ( settings.getPriority_3() ) {
            priorityLevel3checkBox.setSelected(true);
        }
        else {
            priorityLevel3checkBox.setSelected(false);
        }
        priorityLevel3checkBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                priorityLevel3checkBoxActionPerformed(evt);
            }
        });

        priorityPanel.add(priorityLevel3checkBox);

        upperMainPanel.add(priorityPanel);

        mainPanel.add(upperMainPanel);

        bottomMainPanel.setLayout(new java.awt.GridLayout(1, 0));

        timestampPanel.setLayout(new java.awt.GridLayout(4, 1));

        timestampPanel.setBorder(new javax.swing.border.TitledBorder("Time Stamp"));
        timestampLabel1.setFont(new java.awt.Font("Dialog", 0, 12));
        timestampLabel1.setText("After :");
        timestampPanel.add(timestampLabel1);

        timestampAfterTextField.setPreferredSize(new java.awt.Dimension(69, 13));
        timestampAfterTextField.setText(settings.getTimeStampAfter());
        if ( settings.isTimeStampEnabled() ) {
            timestampAfterTextField.setEditable(true);
        }
        else {
            timestampAfterTextField.setEditable(false);
        }
        timestampAfterTextField.addCaretListener(new javax.swing.event.CaretListener() {
            public void caretUpdate(javax.swing.event.CaretEvent evt) {
                timestampAfterTextFieldCaretUpdate(evt);
            }
        });

        timestampPanel.add(timestampAfterTextField);

        timestampLabel2.setFont(new java.awt.Font("Dialog", 0, 12));
        timestampLabel2.setText("Before :");
        timestampPanel.add(timestampLabel2);

        timestampBeforeTextField.setText(settings.getTimeStampBefore());
        if ( settings.isTimeStampEnabled() ) {
            timestampBeforeTextField.setEditable(true);
        }
        else {
            timestampBeforeTextField.setEditable(false);
        }
        timestampBeforeTextField.addCaretListener(new javax.swing.event.CaretListener() {
            public void caretUpdate(javax.swing.event.CaretEvent evt) {
                timestampBeforeTextFieldCaretUpdate(evt);
            }
        });

        timestampPanel.add(timestampBeforeTextField);

        bottomMainPanel.add(timestampPanel);

        statusPanel.setLayout(new java.awt.GridLayout(5, 0));

        statusPanel.setBorder(new javax.swing.border.TitledBorder("Status"));
        statusActiveCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        statusActiveCheckBox.setText("Active");
        statusActiveCheckBox.setSelected(settings.getStatusActive());
        statusActiveCheckBox.setEnabled(settings.isStatusActiveEnabled());
        statusActiveCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                statusActiveCheckBoxActionPerformed(evt);
            }
        });

        statusPanel.add(statusActiveCheckBox);

        statusAcknowledgedCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        statusAcknowledgedCheckBox.setText("Acknowledged");
        statusAcknowledgedCheckBox.setSelected(settings.getStatusAcknowledged());
        statusAcknowledgedCheckBox.setEnabled(settings.isStatusAcknowledgedEnabled());
        statusAcknowledgedCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                statusAcknowledgedCheckBoxActionPerformed(evt);
            }
        });

        statusPanel.add(statusAcknowledgedCheckBox);

        statusHighlightedCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        statusHighlightedCheckBox.setText("Highlighted");
        statusHighlightedCheckBox.setSelected(settings.getStatusHighlighted());
        statusHighlightedCheckBox.setEnabled(settings.isStatusHighlightedEnabled());
        statusHighlightedCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                statusHighlightedCheckBoxActionPerformed(evt);
            }
        });

        statusPanel.add(statusHighlightedCheckBox);

        statusMaskedCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        statusMaskedCheckBox.setText("Masked");
        statusMaskedCheckBox.setSelected(settings.getStatusMasked());
        statusMaskedCheckBox.setEnabled(settings.isStatusMaskedEnabled());
        statusMaskedCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                statusMaskedCheckBoxActionPerformed(evt);
            }
        });

        statusPanel.add(statusMaskedCheckBox);

        statusTerminatedCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        statusTerminatedCheckBox.setText("Terminated");
        statusTerminatedCheckBox.setSelected(settings.getStatusTerminated());
        statusTerminatedCheckBox.setEnabled(settings.isStatusTerminatedEnabled());
        statusTerminatedCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                statusTerminatedCheckBoxActionPerformed(evt);
            }
        });

        statusPanel.add(statusTerminatedCheckBox);

        bottomMainPanel.add(statusPanel);

        sortOptionPanel.setLayout(new java.awt.GridLayout(4, 0));

        sortOptionPanel.setBorder(new javax.swing.border.TitledBorder("Sort option"));
        sortByTimeRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        sortByTimeRadioButton.setText("by time");
        sortOptionButtonGroup.add(sortByTimeRadioButton);
        if( settings.getSortState() == SearchWindowSettings.SORT_BY_TIME ) {
            sortByTimeRadioButton.setSelected(true);
        }
        else {
            sortByTimeRadioButton.setSelected(false);
        }
        sortByTimeRadioButton.setEnabled( settings.isSortByTimeEnabled() );
        sortByTimeRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sortByTimeRadioButtonActionPerformed(evt);
            }
        });

        sortOptionPanel.add(sortByTimeRadioButton);

        sortByPriorityRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        sortByPriorityRadioButton.setText("by priority");
        sortOptionButtonGroup.add(sortByPriorityRadioButton);
        if( settings.getSortState() == SearchWindowSettings.SORT_BY_PRIORITY ) {
            sortByPriorityRadioButton.setSelected(true);
        }
        else {
            sortByPriorityRadioButton.setSelected(false);
        }
        sortByPriorityRadioButton.setEnabled( settings.isSortByPriorityEnabled() );
        sortByPriorityRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sortByPriorityRadioButtonActionPerformed(evt);
            }
        });

        sortOptionPanel.add(sortByPriorityRadioButton);

        sortGroupNTRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        sortGroupNTRadioButton.setText("group N&T");
        sortOptionButtonGroup.add(sortGroupNTRadioButton);
        if( settings.getSortState() == SearchWindowSettings.SORT_BY_GROUP_NT ) {
            sortGroupNTRadioButton.setSelected(true);
        }
        else {
            sortGroupNTRadioButton.setSelected(false);
        }
        sortGroupNTRadioButton.setEnabled( settings.isSortGroupNTEnabled() );
        sortGroupNTRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sortGroupNTRadioButtonActionPerformed(evt);
            }
        });

        sortOptionPanel.add(sortGroupNTRadioButton);

        sortGroupNTbyPriorityRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        sortGroupNTbyPriorityRadioButton.setText("group N&T by prior.");
        sortOptionButtonGroup.add(sortGroupNTbyPriorityRadioButton);
        if( settings.getSortState() == SearchWindowSettings.SORT_BY_GROUP_NT_BY_PR ) {
            sortGroupNTbyPriorityRadioButton.setSelected(true);
        }
        else {
            sortGroupNTbyPriorityRadioButton.setSelected(false);
        }
        sortGroupNTbyPriorityRadioButton.setEnabled( settings.isSortGroupNTByPriorityEnabled() );
        sortGroupNTbyPriorityRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sortGroupNTbyPriorityRadioButtonActionPerformed(evt);
            }
        });

        sortOptionPanel.add(sortGroupNTbyPriorityRadioButton);

        bottomMainPanel.add(sortOptionPanel);

        hostNamePanel.setLayout(new java.awt.GridLayout(4, 1));

        hostNamePanel.setBorder(new javax.swing.border.TitledBorder("Host name"));
        hostNameAllRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        hostNameAllRadioButton.setText("All");
        hostNameButtonGroup.add(hostNameAllRadioButton);
        if( settings.getCAPHostNameState() == SearchWindowSettings.CAP_HOST_NAME_ALL ) {
            hostNameAllRadioButton.setSelected(true);
        }
        else {
            hostNameAllRadioButton.setSelected(false);
        }
        hostNameAllRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                hostNameAllRadioButtonActionPerformed(evt);
            }
        });

        hostNamePanel.add(hostNameAllRadioButton);

        hostNameEqualsRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        hostNameEqualsRadioButton.setText("Equals");
        hostNameButtonGroup.add(hostNameEqualsRadioButton);
        if( settings.getCAPHostNameState() == SearchWindowSettings.CAP_HOST_NAME_EQUALS ) {
            hostNameEqualsRadioButton.setSelected(true);
        }
        else {
            hostNameEqualsRadioButton.setSelected(false);
        }
        hostNameEqualsRadioButton.setEnabled( settings.isCAPHostNameEqualsEnabled() );
        hostNameEqualsRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                hostNameEqualsRadioButtonActionPerformed(evt);
            }
        });

        hostNamePanel.add(hostNameEqualsRadioButton);

        hostNameTextField.setText(settings.getCAPHostNameEquals());
        if( hostNameEqualsRadioButton.isSelected() ) {
            hostNameTextField.setEnabled(true);
        }
        else {
            hostNameTextField.setEnabled(false);
        }
        hostNameTextField.setEnabled( settings.isCAPHostNameEqualsEnabled() && hostNameEqualsRadioButton.isEnabled() && hostNameEqualsRadioButton.isSelected() );
        hostNameTextField.addCaretListener(new javax.swing.event.CaretListener() {
            public void caretUpdate(javax.swing.event.CaretEvent evt) {
                hostNameTextFieldCaretUpdate(evt);
            }
        });

        hostNamePanel.add(hostNameTextField);

        bottomMainPanel.add(hostNamePanel);

        mainPanel.add(bottomMainPanel);

        add(mainPanel, java.awt.BorderLayout.NORTH);

    }//GEN-END:initComponents

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        // get alarms from active list manager
        
        AlarmNodeManager nodeManager = AlarmContainer.getDefault().getAlarmNodeManager(Constants.ACTIVE_LISTENER_KEY);
        for(Iterator iter = nodeManager.getMap().keySet().iterator(); iter.hasNext(); ) {
            String alarmId = (String) iter.next(); // mm String instead of Integer
            AlarmBean alarmBean = nodeManager.getAlarm(alarmId);
            SearchProxyBuffer.getDefault().onSearchAlarm(alarmBean.getCommentedAlarm().getAlarm());            
        }
        SearchProxyBuffer.getDefault().searchFinished();
        
    }//GEN-LAST:event_jButton2ActionPerformed
    
    private void searchButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_searchButtonActionPerformed
        // create ProgressDialog
        ProgressDialog progressDialog = new ProgressDialog();
                
        // create SearchExplorer (or reopen it + clean)
        
        SearchProxyBuffer.getDefault().close();
        SearchProxyBuffer.getDefault().disable();
        
        // SearchProxyBuffer.registerSearchListener(AlarmContainer)
        SearchProxyBuffer.getDefault().registerAlarmSearchListener(progressDialog);
        SearchProxyBuffer.getDefault().registerAlarmSearchListener(AlarmContainer.getDefault());

        // remove previous search result from node manager
        AlarmContainer.getDefault().clearSearchList();
        
        // prepare Selection with Filters from SearchWindowSettings ( correct for windowMode )
        // TODO
        
        try {
			AlarmSelectionHandler selectionHandler = AlarmSelectionHandlerFactory.getHandler();
			selectionHandler.search(selection, 10, AlarmContainer.getDefault());
		} catch (LaserTimeOutException e) {
			// TODO Auto-generated catch block
			logger.debug("LaserTimeOutException");
			e.printStackTrace();
		} catch (LaserException e) {
			// TODO Auto-generated catch block
			logger.debug("LaserException");
			e.printStackTrace();
		}
        
        // show SearchExplorer (TODO: check if it is opened)

        String searchListCompName = NbBundle.getMessage(cern.laser.guiplatform.windows.ActiveListExplorerPanel.class,"LBL_Search_list_component_name");
        AlarmNodeManager searchListManager = AlarmContainer.getDefault().getAlarmNodeManager(Constants.SEARCH_LISTENER_KEY);
        String [] columnToDisplay = Constants.getColumnsToDisplayInSearch();
        ActiveListExplorerPanel searchList = new ActiveListExplorerPanel(searchListManager, searchListCompName, columnToDisplay);
        searchList.open();
        
        // show ProgressDialog
        progressDialog.open();
        
        SearchProxyBuffer.getDefault().enable();
        
        // close Search Window
        
        close();        
        
    }//GEN-LAST:event_searchButtonActionPerformed
    
    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        close();
    }//GEN-LAST:event_cancelButtonActionPerformed
    
    private void formComponentShown(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentShown
        updateBorderNames();
    }//GEN-LAST:event_formComponentShown
    
    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        doSwitch();
    }//GEN-LAST:event_jButton1ActionPerformed
    
    private void hostNameTextFieldCaretUpdate(javax.swing.event.CaretEvent evt) {//GEN-FIRST:event_hostNameTextFieldCaretUpdate
        settings.setCAPHostNameEquals( hostNameTextField.getText() );
    }//GEN-LAST:event_hostNameTextFieldCaretUpdate
    
    private void hostNameEqualsRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_hostNameEqualsRadioButtonActionPerformed
        if ( hostNameEqualsRadioButton.isSelected() ) {
            settings.setCAPHostNameState(SearchWindowSettings.CAP_HOST_NAME_EQUALS);
            hostNameTextField.setEnabled(true);
        }
    }//GEN-LAST:event_hostNameEqualsRadioButtonActionPerformed
    
    private void hostNameAllRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_hostNameAllRadioButtonActionPerformed
        if ( hostNameAllRadioButton.isSelected() ) {
            settings.setCAPHostNameState(SearchWindowSettings.CAP_HOST_NAME_ALL);
            hostNameTextField.setEnabled(false);
        }
    }//GEN-LAST:event_hostNameAllRadioButtonActionPerformed
    
    private void sortGroupNTbyPriorityRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sortGroupNTbyPriorityRadioButtonActionPerformed
        if ( sortGroupNTbyPriorityRadioButton.isSelected() ) {
            settings.setSortState(SearchWindowSettings.SORT_BY_GROUP_NT_BY_PR);
        }
    }//GEN-LAST:event_sortGroupNTbyPriorityRadioButtonActionPerformed
    
    private void sortGroupNTRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sortGroupNTRadioButtonActionPerformed
        if ( sortGroupNTRadioButton.isSelected() ) {
            settings.setSortState(SearchWindowSettings.SORT_BY_GROUP_NT);
        }
    }//GEN-LAST:event_sortGroupNTRadioButtonActionPerformed
    
    private void sortByPriorityRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sortByPriorityRadioButtonActionPerformed
        if ( sortByPriorityRadioButton.isSelected() ) {
            settings.setSortState(SearchWindowSettings.SORT_BY_PRIORITY);
        }
    }//GEN-LAST:event_sortByPriorityRadioButtonActionPerformed
    
    private void sortByTimeRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sortByTimeRadioButtonActionPerformed
        if ( sortByTimeRadioButton.isSelected() ) {
            settings.setSortState(SearchWindowSettings.SORT_BY_TIME);
        }
    }//GEN-LAST:event_sortByTimeRadioButtonActionPerformed
    
    private void statusTerminatedCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_statusTerminatedCheckBoxActionPerformed
        settings.setStatusTerminated( statusTerminatedCheckBox.isSelected() );
    }//GEN-LAST:event_statusTerminatedCheckBoxActionPerformed
    
    private void statusMaskedCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_statusMaskedCheckBoxActionPerformed
        settings.setStatusMasked( statusMaskedCheckBox.isSelected() );
    }//GEN-LAST:event_statusMaskedCheckBoxActionPerformed
    
    private void statusHighlightedCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_statusHighlightedCheckBoxActionPerformed
        settings.setStatusHighlighted( statusHighlightedCheckBox.isSelected() );
    }//GEN-LAST:event_statusHighlightedCheckBoxActionPerformed
    
    private void statusAcknowledgedCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_statusAcknowledgedCheckBoxActionPerformed
        settings.setStatusAcknowledged( statusAcknowledgedCheckBox.isSelected() );
    }//GEN-LAST:event_statusAcknowledgedCheckBoxActionPerformed
    
    private void statusActiveCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_statusActiveCheckBoxActionPerformed
        settings.setStatusActive( statusActiveCheckBox.isSelected() );
    }//GEN-LAST:event_statusActiveCheckBoxActionPerformed
    
    private void timestampBeforeTextFieldCaretUpdate(javax.swing.event.CaretEvent evt) {//GEN-FIRST:event_timestampBeforeTextFieldCaretUpdate
        settings.setTimeStampBefore( timestampBeforeTextField.getText() );
    }//GEN-LAST:event_timestampBeforeTextFieldCaretUpdate
    
    private void timestampAfterTextFieldCaretUpdate(javax.swing.event.CaretEvent evt) {//GEN-FIRST:event_timestampAfterTextFieldCaretUpdate
        settings.setTimeStampAfter( timestampAfterTextField.getText() );
    }//GEN-LAST:event_timestampAfterTextFieldCaretUpdate
    
    private void priorityLevel3checkBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_priorityLevel3checkBoxActionPerformed
        settings.setPriority_3(priorityLevel3checkBox.isSelected());
    }//GEN-LAST:event_priorityLevel3checkBoxActionPerformed
    
    private void priorityLevel2checkBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_priorityLevel2checkBoxActionPerformed
        settings.setPriority_2(priorityLevel2checkBox.isSelected());
    }//GEN-LAST:event_priorityLevel2checkBoxActionPerformed
    
    private void priorityLevel1checkBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_priorityLevel1checkBoxActionPerformed
        settings.setPriority_1(priorityLevel1checkBox.isSelected());
    }//GEN-LAST:event_priorityLevel1checkBoxActionPerformed
    
    private void priorityLevel0checkBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_priorityLevel0checkBoxActionPerformed
        settings.setPriority_0(priorityLevel0checkBox.isSelected());
    }//GEN-LAST:event_priorityLevel0checkBoxActionPerformed
    
    private void PDFCtextFieldCaretUpdate(javax.swing.event.CaretEvent evt) {//GEN-FIRST:event_PDFCtextFieldCaretUpdate
        settings.setPDFCContains( PDFCtextField.getText() );
    }//GEN-LAST:event_PDFCtextFieldCaretUpdate
    
    private void IFMtextFieldCaretUpdate(javax.swing.event.CaretEvent evt) {//GEN-FIRST:event_IFMtextFieldCaretUpdate
        settings.setIFMContains( IFMtextField.getText() );
    }//GEN-LAST:event_IFMtextFieldCaretUpdate
    
    private void SNFFtextFieldCaretUpdate(javax.swing.event.CaretEvent evt) {//GEN-FIRST:event_SNFFtextFieldCaretUpdate
        settings.setSNFFContains( SNFFtextField.getText() );
    }//GEN-LAST:event_SNFFtextFieldCaretUpdate
    
    private void PDFCcontainsRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_PDFCcontainsRadioButtonActionPerformed
        if ( PDFCcontainsRadioButton.isSelected() ) {
            settings.setPDFCState(SearchWindowSettings.ID_CONTAINS);
            PDFCtextField.setEnabled(true);
        }
    }//GEN-LAST:event_PDFCcontainsRadioButtonActionPerformed
    
    private void IFMcontainsRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_IFMcontainsRadioButtonActionPerformed
        if ( IFMcontainsRadioButton.isSelected() ) {
            settings.setIFMState(SearchWindowSettings.ID_CONTAINS);
            IFMtextField.setEnabled(true);
        }
    }//GEN-LAST:event_IFMcontainsRadioButtonActionPerformed
    
    private void SNFFcontainsRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SNFFcontainsRadioButtonActionPerformed
        if ( SNFFcontainsRadioButton.isSelected() ) {
            settings.setSNFFState(SearchWindowSettings.ID_CONTAINS);
            SNFFtextField.setEnabled(true);
        }
    }//GEN-LAST:event_SNFFcontainsRadioButtonActionPerformed
    
    private void PDFCequalsRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_PDFCequalsRadioButtonActionPerformed
        if ( PDFCequalsRadioButton.isSelected() ) {
            settings.setPDFCState(SearchWindowSettings.ID_EQUAL);
            PDFCtextField.setEnabled(true);
        }
    }//GEN-LAST:event_PDFCequalsRadioButtonActionPerformed
    
    private void IFMequalsRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_IFMequalsRadioButtonActionPerformed
        if ( IFMequalsRadioButton.isSelected() ) {
            settings.setIFMState(SearchWindowSettings.ID_EQUAL);
            IFMtextField.setEnabled(true);
        }
    }//GEN-LAST:event_IFMequalsRadioButtonActionPerformed
    
    private void SNFFequalsRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SNFFequalsRadioButtonActionPerformed
        if ( SNFFequalsRadioButton.isSelected() ) {
            settings.setSNFFState(SearchWindowSettings.ID_EQUAL);
            SNFFtextField.setEnabled(true);
        }
    }//GEN-LAST:event_SNFFequalsRadioButtonActionPerformed
    
    private void PDFCallRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_PDFCallRadioButtonActionPerformed
        if ( PDFCallRadioButton.isSelected() ) {
            settings.setPDFCState(SearchWindowSettings.ID_ALL);
            PDFCtextField.setEnabled(false);
        }
    }//GEN-LAST:event_PDFCallRadioButtonActionPerformed
    
    private void IFMallRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_IFMallRadioButtonActionPerformed
        if ( IFMallRadioButton.isSelected() ) {
            settings.setIFMState(SearchWindowSettings.ID_ALL);
            IFMtextField.setEnabled(false);
        }
    }//GEN-LAST:event_IFMallRadioButtonActionPerformed
    
    private void SNFFallRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SNFFallRadioButtonActionPerformed
        if ( SNFFallRadioButton.isSelected() ) {
            settings.setSNFFState(SearchWindowSettings.ID_ALL);
            SNFFtextField.setEnabled(false);
        }
    }//GEN-LAST:event_SNFFallRadioButtonActionPerformed
    
    private void updateBorderNames() {
        if ( settings.getSwitchMode() == SearchWindowSettings.SWITCH_MODE_FF_FM_FC) {
            SNFFpanel.setBorder( new TitledBorder( NbBundle.getMessage( SearchWindow.class, "LBL_border_system_name") ));
            IFMpanel.setBorder( new TitledBorder( NbBundle.getMessage( SearchWindow.class, "LBL_border_identifier") ));
            PDFCpanel.setBorder( new TitledBorder( NbBundle.getMessage( SearchWindow.class, "LBL_border_problem_description") ));
        }
        else {
            SNFFpanel.setBorder( new TitledBorder( NbBundle.getMessage( SearchWindow.class, "LBL_border_FF") ));
            IFMpanel.setBorder( new TitledBorder( NbBundle.getMessage( SearchWindow.class, "LBL_border_FM") ));
            PDFCpanel.setBorder( new TitledBorder( NbBundle.getMessage( SearchWindow.class, "LBL_border_FC") ));
        }
    }
    /**
     * Switch between SystemName/Identifier/ProblemDescription and FF/FM/FC window mode
     */
    private void doSwitch() {
        if ( settings.getSwitchMode() == SearchWindowSettings.SWITCH_MODE_FF_FM_FC )
            settings.setSwitchMode( SearchWindowSettings.SWITCH_MODE_SN_I_PD );
        else
            settings.setSwitchMode( SearchWindowSettings.SWITCH_MODE_FF_FM_FC );
        updateBorderNames();
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JRadioButton IFMallRadioButton;
    private javax.swing.ButtonGroup IFMbuttonGroup;
    private javax.swing.JRadioButton IFMcontainsRadioButton;
    private javax.swing.JRadioButton IFMequalsRadioButton;
    private javax.swing.JPanel IFMpanel;
    private javax.swing.JTextField IFMtextField;
    private javax.swing.JRadioButton PDFCallRadioButton;
    private javax.swing.ButtonGroup PDFCbuttonGroup;
    private javax.swing.JRadioButton PDFCcontainsRadioButton;
    private javax.swing.JRadioButton PDFCequalsRadioButton;
    private javax.swing.JPanel PDFCpanel;
    private javax.swing.JTextField PDFCtextField;
    private javax.swing.JRadioButton SNFFallRadioButton;
    private javax.swing.ButtonGroup SNFFbuttonGroup;
    private javax.swing.JRadioButton SNFFcontainsRadioButton;
    private javax.swing.JRadioButton SNFFequalsRadioButton;
    private javax.swing.JPanel SNFFpanel;
    private javax.swing.JTextField SNFFtextField;
    private javax.swing.JPanel bottomMainPanel;
    private javax.swing.JPanel buttonsPanel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JRadioButton hostNameAllRadioButton;
    private javax.swing.ButtonGroup hostNameButtonGroup;
    private javax.swing.JRadioButton hostNameEqualsRadioButton;
    private javax.swing.JPanel hostNamePanel;
    private javax.swing.JTextField hostNameTextField;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JPanel mainPanel;
    private javax.swing.JCheckBox priorityLevel0checkBox;
    private javax.swing.JCheckBox priorityLevel1checkBox;
    private javax.swing.JCheckBox priorityLevel2checkBox;
    private javax.swing.JCheckBox priorityLevel3checkBox;
    private javax.swing.JPanel priorityPanel;
    private javax.swing.JButton searchButton;
    private javax.swing.JRadioButton sortByPriorityRadioButton;
    private javax.swing.JRadioButton sortByTimeRadioButton;
    private javax.swing.JRadioButton sortGroupNTRadioButton;
    private javax.swing.JRadioButton sortGroupNTbyPriorityRadioButton;
    private javax.swing.ButtonGroup sortOptionButtonGroup;
    private javax.swing.JPanel sortOptionPanel;
    private javax.swing.JCheckBox statusAcknowledgedCheckBox;
    private javax.swing.JCheckBox statusActiveCheckBox;
    private javax.swing.JCheckBox statusHighlightedCheckBox;
    private javax.swing.JCheckBox statusMaskedCheckBox;
    private javax.swing.JPanel statusPanel;
    private javax.swing.JCheckBox statusTerminatedCheckBox;
    private javax.swing.JTextField timestampAfterTextField;
    private javax.swing.JTextField timestampBeforeTextField;
    private javax.swing.JLabel timestampLabel1;
    private javax.swing.JLabel timestampLabel2;
    private javax.swing.JPanel timestampPanel;
    private javax.swing.JPanel upperMainPanel;
    // End of variables declaration//GEN-END:variables
    
    // MODES AND WORKSPACES
    
    /*
    // If you want it to open in a specific mode:
    public static final String SearchWindow_MODE = "SearchWindow";
    public void open(Workspace ws) {
        super.open(ws);
        if (ws == null) ws = WindowManager.getDefault().getCurrentWorkspace();
        Mode m = ws.findMode(SearchWindow_MODE);
        if (m == null) {
            try {
                m = ws.createMode(SearchWindow_MODE, // code name
                                   NbBundle.getMessage(SearchWindow.class, "LBL_mode_name"), // display name
                                   new URL("nbresloc:/cern/laser/guiplatform/windows/search/SearchWindowIcon.gif"));
            } catch (MalformedURLException mfue) {
                ErrorManager.getDefault().notify(mfue);
                return;
            }
            // If you want it in a specific position:
            // m.setBounds(...ws.getBounds()...);
        }
        m.dockInto(this);
    }
     */
    
    /*
    // If you are not specifying a mode you may wish to use:
    public Dimension getPreferredSize() {
        return ...WindowManager.getDefault().getCurrentWorkspace().getBounds()...;
    }
     */
    
    /*
    // If you want it to open on a specific workspace:
    public static final String SearchWindow_WORKSPACE = NbBundle.getMessage(SearchWindow.class, "LBL_workspace_name");
    public void open() {
        WindowManager wm = WindowManager.getDefault();
        Workspace ws = wm.findWorkspace(SearchWindow_WORKSPACE);
        if (ws == null)
            ws = wm.createWorkspace(SearchWindow_WORKSPACE);
        open(ws);
        ws.activate();
    }
     */
    
    // PERSISTENCE
    
    private static final long serialVersionUID = 1L;
    
    /*
    // If you wish to keep any state between IDE restarts, put it here:
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        setSomeState((SomeType)in.readObject());
    }
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(getSomeState());
    }
     */
    
    /*
    // The above assumes that the SomeType is safely serializable, e.g. String or Date.
    // If it is some class of your own that might change incompatibly, use e.g.:
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        NbMarshalledObject read = (NbMarshalledObject)in.readObject();
        if (read != null) {
            try {
                setSomeState((SomeType)read.get());
            } catch (Exception e) {
                ErrorManager.getDefault().notify(e);
                // If the problem would make this component inconsistent, use:
                // throw new SafeException(e);
            }
        }
    }
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        Object toWrite;
        try {
            toWrite = new NbMarshalledObject(getSomeState());
        } catch (Exception e) {
            ErrorManager.getDefault().notify(e);
            toWrite = null;
            // Again you may prefer to use:
            // throw new SafeException(e);
        }
        out.writeObject(toWrite);
    }
     */
    
    /*
    // Use this to discard the component after restarts (make it nonpersistent):
    private Object readResolve() throws ObjectStreamException {
        return null;
        // If you wish to conditionally discard it, make readExternal set
        // or clear some flag acc. to the condition, then use:
        // return discardFlag ? null : this;
        // Singleton component using private static SearchWindow theInstance:
        // if (theInstance == null) theInstance = this;
        // return theInstance;
    }
     */
    
    // ACTIONS
    
    /*
    // If you wish to have extra actions appear in the window's
    // popup menu, they can go here:
    public SystemAction[] getSystemActions() {
        SystemAction[] supe = super.getSystemActions();
        SystemAction[] mine = new SystemAction[supe.length + 1];
        System.arraycopy(supe, 0, mine, 0, supe.length);
        mine[supe.length] = SystemAction.get(SomeActionOfMine.class);
        return mine;
    }
     */
    
    /*
    // Associate implementations with copying, searching, etc.:
    protected void componentActivated() {
        ((CallbackSystemAction)SystemAction.get(FindAction.class)).setActionPerformer(new ActionPerformer() {
                public void performAction(SystemAction action) {
                    // search this component somehow
                }
            });
        // similar for CopyAction, CutAction, DeleteAction, GotoAction, ReplaceAction, etc.
        // for PasteAction, use:
        // ((PasteAction)SystemAction.get(PasteAction.class)).setPasteTypes(new PasteType[] {...});
    }
    protected void componentDeactivated() {
        // FindAction will be turned off by itself
        // ((PasteAction)SystemAction.get(PasteAction.class)).setPasteTypes(null);
    }
     */
    
    /*
    // If you want UndoAction and RedoAction to be enabled on this component:
    public UndoRedo getUndoRedo() {
        return new MyUndoRedo(this);
    }
     */
    
    // Printing, saving, compiling, etc.: use cookies on some appropriate node and
    // use this node as the node selection.
    
}
