package cern.laser.guiplatform.windows.alarms;

import java.awt.Dimension;
import java.util.List;

import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

import cern.laser.guiplatform.util.LabelValueBean;

// As needed:
/*
import java.io.*;
import java.net.*;
import org.openide.ErrorManager;
import org.openide.actions.*;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.actions.*;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.io.*;
 */

/** An openable window available to the IDE's window manager.
 *
 * @author Bartlomiej Pawlowski <Bartlomiej.Pawlowski@cern.ch>
 */
public class AlarmTimestampsPanel extends TopComponent /* or CloneableTopComponent */ {
    
    // REMEMBER: You should have a public default constructor!
    // This is for externalization. If you have a nondefault
    // constructor for normal creation of the component, leave
    // in a default constructor that will put the component into
    // a consistent but unconfigured state, and make sure readExternal
    // initializes it properly. Or, be creative with writeReplace().
    /** @deprecated do not use it, this is only for NB purposes */
    public AlarmTimestampsPanel() {
        initComponents();
        setCloseOperation(CLOSE_LAST); // or CLOSE_EACH
        // Display name of this window (not needed if you use the DataObject constructor):
        setName(NbBundle.getMessage(AlarmTimestampsPanel.class, "LBL_ALARM_TIMESTAMP_PANEL_component_name"));
        // You may set the icon, but often it is better to set the icon for an associated mode instead:
        // setIcon(Utilities.loadImage("cern/laser/guiplatform/windows/alarms/AlarmTimestampsPanelIcon.gif", true));
        // Use the Component Inspector to set tool-tip text. This will be saved
        // automatically. Other JComponent properties you may need to save yuorself.
        // At any time you can affect the node selection:
        // setActivatedNodes(new Node[] {...});

        putClientProperty("PersistenceType", "Never");
        putClientProperty("TabPolicy", "HideWhenAlone");

    }
  
    /** 
     * @param timestamps <code>List</code> with <code>LabelValueBean</code>objects
     * @param fsName fault state name
     */ 
    public AlarmTimestampsPanel(List timestamps, String fsName) {
        initComponents();
        setCloseOperation(CLOSE_LAST); // or CLOSE_EACH
        setName(NbBundle.getMessage(AlarmTimestampsPanel.class, 
                                    "LBL_ALARM_TIMESTAMP_PANEL_component_name"));

        putClientProperty("PersistenceType", "Never");
        putClientProperty("TabPolicy", "HideWhenAlone");

        postInitComponents();
        updatePanel(timestamps, fsName);
    }
   
    private void postInitComponents() {
        labels[0][0] = userTimeLabel;
        labels[0][1] = userTimeValueLabel;
        
        labels[1][0] = sourceTimeLabel;
        labels[1][1] = sourceTimeValueLabel;
        
        labels[2][0] = blTimeLabel;
        labels[2][1] = blTimeValueLabel;

        labels[3][0] = consoleTimeLabel;
        labels[3][1] = consoleTimeValueLabel;
    } 

    /** 
     * @param timestamps <code>List</code> with <code>LabelValueBean</code>objects
     * @param fsName fault state name
     */ 
    public void updatePanel(List timeststamps, String fsName) {
        fsNameLabel.setText(fsName);
        LabelValueBean lbBean = null; 

        for (int i = 0; i < TIMESTAMPS_NO; i++) {
            lbBean = (LabelValueBean) timeststamps.get(i);
            labels[i][0].setText(lbBean.getLabel());
            labels[i][1].setText(lbBean.getValue());

        }
    }

    /*
    public HelpCtx getHelpCtx() {
        return new HelpCtx(AlarmTimestampsPanel.class);
    }
     */
    
    /*
    // If you are using CloneableTopComponent, probably you should override:
    protected CloneableTopComponent createClonedObject() {
        return new AlarmTimestampsPanel();
    }
    protected boolean closeLast() {
        // You might want to prompt the user first and maybe return false:
        return true;
    }
     */
    
    // APPEARANCE
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        headerPanel = new javax.swing.JPanel();
        titleLabel = new javax.swing.JLabel();
        fsNameLabel = new javax.swing.JLabel();
        middlePanel = new javax.swing.JPanel();
        userTimeLabel = new javax.swing.JLabel();
        userTimeValueLabel = new javax.swing.JLabel();
        sourceTimeLabel = new javax.swing.JLabel();
        sourceTimeValueLabel = new javax.swing.JLabel();
        blTimeLabel = new javax.swing.JLabel();
        blTimeValueLabel = new javax.swing.JLabel();
        consoleTimeLabel = new javax.swing.JLabel();
        consoleTimeValueLabel = new javax.swing.JLabel();
        buttonPanel = new javax.swing.JPanel();
        closeButton = new javax.swing.JButton();

        setLayout(new java.awt.BorderLayout());

        headerPanel.setBorder(new javax.swing.border.EtchedBorder(javax.swing.border.EtchedBorder.RAISED));
        titleLabel.setText("Timestamps for fault state:");
        headerPanel.add(titleLabel);

        fsNameLabel.setText("fsNameLabel");
        headerPanel.add(fsNameLabel);

        add(headerPanel, java.awt.BorderLayout.NORTH);

        middlePanel.setLayout(new java.awt.GridBagLayout());

        middlePanel.setBorder(new javax.swing.border.EtchedBorder(javax.swing.border.EtchedBorder.RAISED));
        userTimeLabel.setText("user timestamp");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(9, 10, 4, 8);
        middlePanel.add(userTimeLabel, gridBagConstraints);

        userTimeValueLabel.setText("2003-11-12 16:15:46.001");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(9, 8, 4, 10);
        middlePanel.add(userTimeValueLabel, gridBagConstraints);

        sourceTimeLabel.setText("Source timestamp");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 10, 4, 8);
        middlePanel.add(sourceTimeLabel, gridBagConstraints);

        sourceTimeValueLabel.setText("2003-11-12 16:15:46.001");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 8, 4, 10);
        middlePanel.add(sourceTimeValueLabel, gridBagConstraints);

        blTimeLabel.setText("Business layer timestamp");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 10, 4, 8);
        middlePanel.add(blTimeLabel, gridBagConstraints);

        blTimeValueLabel.setText("2003-11-12 16:15:46.001");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 8, 4, 10);
        middlePanel.add(blTimeValueLabel, gridBagConstraints);

        consoleTimeLabel.setText("Console timestamp");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 10, 10, 8);
        middlePanel.add(consoleTimeLabel, gridBagConstraints);

        consoleTimeValueLabel.setText("2003-11-12 16:15:46.001");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 7, 10, 10);
        middlePanel.add(consoleTimeValueLabel, gridBagConstraints);

        add(middlePanel, java.awt.BorderLayout.CENTER);

        buttonPanel.setLayout(new java.awt.BorderLayout());

        closeButton.setText("Close");
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeButtonActionPerformed(evt);
            }
        });

        buttonPanel.add(closeButton, java.awt.BorderLayout.EAST);

        add(buttonPanel, java.awt.BorderLayout.SOUTH);

    }//GEN-END:initComponents

    private void closeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeButtonActionPerformed
        // Add your handling code here:
        close();
    }//GEN-LAST:event_closeButtonActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel blTimeLabel;
    private javax.swing.JLabel blTimeValueLabel;
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JButton closeButton;
    private javax.swing.JLabel consoleTimeLabel;
    private javax.swing.JLabel consoleTimeValueLabel;
    private javax.swing.JLabel fsNameLabel;
    private javax.swing.JPanel headerPanel;
    private javax.swing.JPanel middlePanel;
    private javax.swing.JLabel sourceTimeLabel;
    private javax.swing.JLabel sourceTimeValueLabel;
    private javax.swing.JLabel titleLabel;
    private javax.swing.JLabel userTimeLabel;
    private javax.swing.JLabel userTimeValueLabel;
    // End of variables declaration//GEN-END:variables

    private final int TIMESTAMPS_NO = 4;
    private javax.swing.JLabel [][] labels = new javax.swing.JLabel[TIMESTAMPS_NO][2];

 
    /** default dimension */ 
    private final static Dimension defaultDimension = new Dimension(417, 246);


    // MODES AND WORKSPACES
    
    /*
    // If you want it to open in a specific mode:
    public static final String AlarmTimestampsPanel_MODE = "AlarmTimestampsPanel";
    public void open(Workspace ws) {
        super.open(ws);
        if (ws == null) ws = WindowManager.getDefault().getCurrentWorkspace();
        Mode m = ws.findMode(AlarmTimestampsPanel_MODE);
        if (m == null) {
            try {
                m = ws.createMode(AlarmTimestampsPanel_MODE, // code name
                                   NbBundle.getMessage(AlarmTimestampsPanel.class, "LBL_mode_name"), // display name
                                   new URL("nbresloc:/cern/laser/guiplatform/windows/alarms/AlarmTimestampsPanelIcon.gif"));
            } catch (MalformedURLException mfue) {
                ErrorManager.getDefault().notify(mfue);
                return;
            }
            // If you want it in a specific position:
            // m.setBounds(...ws.getBounds()...);
        }
        m.dockInto(this);
    }
     */
    
    
    // If you are not specifying a mode you may wish to use:
    public Dimension getPreferredSize() {
        return defaultDimension;
        //return ...WindowManager.getDefault().getCurrentWorkspace().getBounds()...;
    }
     
    
    /*
    // If you want it to open on a specific workspace:
    public static final String AlarmTimestampsPanel_WORKSPACE = NbBundle.getMessage(AlarmTimestampsPanel.class, "LBL_workspace_name");
    public void open() {
        WindowManager wm = WindowManager.getDefault();
        Workspace ws = wm.findWorkspace(AlarmTimestampsPanel_WORKSPACE);
        if (ws == null)
            ws = wm.createWorkspace(AlarmTimestampsPanel_WORKSPACE);
        open(ws);
        ws.activate();
    }
     */
    
    // PERSISTENCE
    
    private static final long serialVersionUID = 1L;
    
    /*
    // If you wish to keep any state between IDE restarts, put it here:
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        setSomeState((SomeType)in.readObject());
    }
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(getSomeState());
    }
     */
    
    /*
    // The above assumes that the SomeType is safely serializable, e.g. String or Date.
    // If it is some class of your own that might change incompatibly, use e.g.:
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        NbMarshalledObject read = (NbMarshalledObject)in.readObject();
        if (read != null) {
            try {
                setSomeState((SomeType)read.get());
            } catch (Exception e) {
                ErrorManager.getDefault().notify(e);
                // If the problem would make this component inconsistent, use:
                // throw new SafeException(e);
            }
        }
    }
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        Object toWrite;
        try {
            toWrite = new NbMarshalledObject(getSomeState());
        } catch (Exception e) {
            ErrorManager.getDefault().notify(e);
            toWrite = null;
            // Again you may prefer to use:
            // throw new SafeException(e);
        }
        out.writeObject(toWrite);
    }
     */
    
    /*
    // Use this to discard the component after restarts (make it nonpersistent):
    private Object readResolve() throws ObjectStreamException {
        return null;
        // If you wish to conditionally discard it, make readExternal set
        // or clear some flag acc. to the condition, then use:
        // return discardFlag ? null : this;
        // Singleton component using private static AlarmTimestampsPanel theInstance:
        // if (theInstance == null) theInstance = this;
        // return theInstance;
    }
     */
    
    // ACTIONS
    
    /*
    // If you wish to have extra actions appear in the window's
    // popup menu, they can go here:
    public SystemAction[] getSystemActions() {
        SystemAction[] supe = super.getSystemActions();
        SystemAction[] mine = new SystemAction[supe.length + 1];
        System.arraycopy(supe, 0, mine, 0, supe.length);
        mine[supe.length] = SystemAction.get(SomeActionOfMine.class);
        return mine;
    }
     */
    
    /*
    // Associate implementations with copying, searching, etc.:
    protected void componentActivated() {
        ((CallbackSystemAction)SystemAction.get(FindAction.class)).setActionPerformer(new ActionPerformer() {
                public void performAction(SystemAction action) {
                    // search this component somehow
                }
            });
        // similar for CopyAction, CutAction, DeleteAction, GotoAction, ReplaceAction, etc.
        // for PasteAction, use:
        // ((PasteAction)SystemAction.get(PasteAction.class)).setPasteTypes(new PasteType[] {...});
    }
    protected void componentDeactivated() {
        // FindAction will be turned off by itself
        // ((PasteAction)SystemAction.get(PasteAction.class)).setPasteTypes(null);
    }
     */
    
    /*
    // If you want UndoAction and RedoAction to be enabled on this component:
    public UndoRedo getUndoRedo() {
        return new MyUndoRedo(this);
    }
     */
    
    // Printing, saving, compiling, etc.: use cookies on some appropriate node and
    // use this node as the node selection.
    
}
