package cern.laser.guiplatform.windows.alarms;

import java.awt.Dimension;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

import cern.gp.nodes.GPNode;
import cern.gp.nodes.NodeFactory;
import cern.gp.nodes.children.ChildrenMapManager;
import cern.gp.nodes.children.NodeMap;
import cern.laser.guiplatform.alarms.AlarmBean;
import cern.laser.guiplatform.alarms.InfoAlarmBean;
import cern.laser.guiplatform.util.LogFactory;

// As needed:
/*
import java.io.*;
import java.net.*;
import org.openide.ErrorManager;
import org.openide.actions.*;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.actions.*;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.io.*;
 */

/** An openable window available to the IDE's window manager.
 *
 * This explorer should be used to display list like Node Children Alarms,
 * MultiplicityChildren Alarms, Alarm which belongs to given category, etc
 * 
 *
 * @author Bartlomiej Pawlowski <Bartlomiej.Pawlowski@cern.ch>
 */
//public class AlarmInfoExplorer extends TopComponent /* or CloneableTopComponent */ {
public class AlarmInfoExplorer extends cern.gp.explorer.ListTableExplorer {
    
    // REMEMBER: You should have a public default constructor!
    // This is for externalization. If you have a nondefault
    // constructor for normal creation of the component, leave
    // in a default constructor that will put the component into
    // a consistent but unconfigured state, and make sure readExternal
    // initializes it properly. Or, be creative with writeReplace().
    /*
    public AlarmInfoExplorer() {
        initComponents();
        setCloseOperation(CLOSE_LAST); // or CLOSE_EACH
        // Display name of this window (not needed if you use the DataObject constructor):
        setName(NbBundle.getMessage(AlarmInfoExplorer.class, "LBL_component_name"));
        // You may set the icon, but often it is better to set the icon for an associated mode instead:
        // setIcon(Utilities.loadImage("cern/laser/guiplatform/windows/alarms/AlarmInfoExplorerIcon.gif", true));
        // Use the Component Inspector to set tool-tip text. This will be saved
        // automatically. Other JComponent properties you may need to save yuorself.
        // At any time you can affect the node selection:
        // setActivatedNodes(new Node[] {...});
        putClientProperty("PersistenceType", "Never");
        putClientProperty("TabPolicy", "HideWhenAlone");

    }
    */

    /**
     * @param <code>List</code> with <code>InfoAlarmBean</code>objcets to be dispalyed
     * @param labelText (i. e. Alarms belong to TEST category, FF FM 1 node children, etc
     * @param columnsToDisplay 
     */
    public AlarmInfoExplorer(List alarms, String labelText, String [] columnsToDisplay) {
        initComponents();
        setCloseOperation(CLOSE_LAST); // or CLOSE_EACH
        setName(componentName);

        putClientProperty("PersistenceType", "Never");
        putClientProperty("TabPolicy", "HideWhenAlone");
        
        nManager = new NodeManager(alarms);

        try {
            Object alarm = new Object();
            GPNode root = NodeFactory.createNode(alarm, nManager);            
            this.setRootNode(root); 
            setTableColumns(new AlarmBean(), columnsToDisplay);
        } catch (java.beans.IntrospectionException ie) {
            logger.error(ie.getMessage(), ie);
        }
        titleLabel.setText(labelText);
        alarmNoValLabel.setText("" + alarms.size());
    } 

    public void update(List newAlarms, String newLabelText) {
        titleLabel.setText(newLabelText);
        alarmNoValLabel.setText("" + newAlarms.size());
        nManager.updateManager(newAlarms);
    }
    /*
    public HelpCtx getHelpCtx() {
        return new HelpCtx(AlarmInfoExplorer.class);
    }
     */
    
    /*
    // If you are using CloneableTopComponent, probably you should override:
    protected CloneableTopComponent createClonedObject() {
        return new AlarmInfoExplorer();
    }
    protected boolean closeLast() {
        // You might want to prompt the user first and maybe return false:
        return true;
    }
     */
    public String getName() {
        return componentName;
    }

    
    // APPEARANCE
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        infoPanel = new javax.swing.JPanel();
        titleLabel = new javax.swing.JLabel();
        alarmNoLabel = new javax.swing.JLabel();
        alarmNoValLabel = new javax.swing.JLabel();

        infoPanel.setLayout(new java.awt.GridBagLayout());

        titleLabel.setFont(new java.awt.Font("Dialog", 1, 14));
        titleLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        titleLabel.setText("Alarms belong to TEST category");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(7, 0, 5, 0);
        infoPanel.add(titleLabel, gridBagConstraints);

        alarmNoLabel.setText("Alarm No:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 8, 6, 0);
        infoPanel.add(alarmNoLabel, gridBagConstraints);

        alarmNoValLabel.setText("1000");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        infoPanel.add(alarmNoValLabel, gridBagConstraints);

        add(infoPanel, java.awt.BorderLayout.NORTH);

    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel alarmNoLabel;
    private javax.swing.JLabel alarmNoValLabel;
    private javax.swing.JPanel infoPanel;
    private javax.swing.JLabel titleLabel;
    // End of variables declaration//GEN-END:variables

    /** logger */
    private static final Logger logger = 
            LogFactory.getLogger(AlarmInfoExplorer.class.getName());
   
    /** node manager */
    private NodeManager nManager = null;

    private static final String componentName = 
        NbBundle.getMessage(AlarmInfoExplorer.class, "LBL_AlarmInfoExplorer_component_name");

    /** default dimension, used by InhibitList, etc */ 
    private Dimension defaultDimension = new Dimension(
            (int) (WindowManager.getDefault().getCurrentWorkspace().getBounds().width / 1.5) , 
            WindowManager.getDefault().getCurrentWorkspace().getBounds().height / 3);


    //
    // -- netbeans specific methods --------------------
    //


    // MODES AND WORKSPACES
    
    /*
    // If you want it to open in a specific mode:
    public static final String AlarmInfoExplorer_MODE = "AlarmInfoExplorer";
    public void open(Workspace ws) {
        super.open(ws);
        if (ws == null) ws = WindowManager.getDefault().getCurrentWorkspace();
        Mode m = ws.findMode(AlarmInfoExplorer_MODE);
        if (m == null) {
            try {
                m = ws.createMode(AlarmInfoExplorer_MODE, // code name
                                   NbBundle.getMessage(AlarmInfoExplorer.class, "LBL_mode_name"), // display name
                                   new URL("nbresloc:/cern/laser/guiplatform/windows/alarms/AlarmInfoExplorerIcon.gif"));
            } catch (MalformedURLException mfue) {
                ErrorManager.getDefault().notify(mfue);
                return;
            }
            // If you want it in a specific position:
            // m.setBounds(...ws.getBounds()...);
        }
        m.dockInto(this);
    }
     */
    
    
    // If you are not specifying a mode you may wish to use:
    public Dimension getPreferredSize() {
    //    return ...WindowManager.getDefault().getCurrentWorkspace().getBounds()...;
        return defaultDimension;
    }
     
    
    /*
    // If you want it to open on a specific workspace:
    public static final String AlarmInfoExplorer_WORKSPACE = NbBundle.getMessage(AlarmInfoExplorer.class, "LBL_workspace_name");
    public void open() {
        WindowManager wm = WindowManager.getDefault();
        Workspace ws = wm.findWorkspace(AlarmInfoExplorer_WORKSPACE);
        if (ws == null)
            ws = wm.createWorkspace(AlarmInfoExplorer_WORKSPACE);
        open(ws);
        ws.activate();
    }
     */
    
    // PERSISTENCE
    
    private static final long serialVersionUID = 1L;
    
    /*
    // If you wish to keep any state between IDE restarts, put it here:
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        setSomeState((SomeType)in.readObject());
    }
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(getSomeState());
    }
     */
    
    /*
    // The above assumes that the SomeType is safely serializable, e.g. String or Date.
    // If it is some class of your own that might change incompatibly, use e.g.:
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        NbMarshalledObject read = (NbMarshalledObject)in.readObject();
        if (read != null) {
            try {
                setSomeState((SomeType)read.get());
            } catch (Exception e) {
                ErrorManager.getDefault().notify(e);
                // If the problem would make this component inconsistent, use:
                // throw new SafeException(e);
            }
        }
    }
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        Object toWrite;
        try {
            toWrite = new NbMarshalledObject(getSomeState());
        } catch (Exception e) {
            ErrorManager.getDefault().notify(e);
            toWrite = null;
            // Again you may prefer to use:
            // throw new SafeException(e);
        }
        out.writeObject(toWrite);
    }
     */
    
    /*
    // Use this to discard the component after restarts (make it nonpersistent):
    private Object readResolve() throws ObjectStreamException {
        return null;
        // If you wish to conditionally discard it, make readExternal set
        // or clear some flag acc. to the condition, then use:
        // return discardFlag ? null : this;
        // Singleton component using private static AlarmInfoExplorer theInstance:
        // if (theInstance == null) theInstance = this;
        // return theInstance;
    }
     */
    
    // ACTIONS
    
    /*
    // If you wish to have extra actions appear in the window's
    // popup menu, they can go here:
    public SystemAction[] getSystemActions() {
        SystemAction[] supe = super.getSystemActions();
        SystemAction[] mine = new SystemAction[supe.length + 1];
        System.arraycopy(supe, 0, mine, 0, supe.length);
        mine[supe.length] = SystemAction.get(SomeActionOfMine.class);
        return mine;
    }
     */
    
    /*
    // Associate implementations with copying, searching, etc.:
    protected void componentActivated() {
        ((CallbackSystemAction)SystemAction.get(FindAction.class)).setActionPerformer(new ActionPerformer() {
                public void performAction(SystemAction action) {
                    // search this component somehow
                }
            });
        // similar for CopyAction, CutAction, DeleteAction, GotoAction, ReplaceAction, etc.
        // for PasteAction, use:
        // ((PasteAction)SystemAction.get(PasteAction.class)).setPasteTypes(new PasteType[] {...});
    }
    protected void componentDeactivated() {
        // FindAction will be turned off by itself
        // ((PasteAction)SystemAction.get(PasteAction.class)).setPasteTypes(null);
    }
     */
    
    /*
    // If you want UndoAction and RedoAction to be enabled on this component:
    public UndoRedo getUndoRedo() {
        return new MyUndoRedo(this);
    }
     */
    
    // Printing, saving, compiling, etc.: use cookies on some appropriate node and
    // use this node as the node selection.
   


    //
    // -- private node manager ---------------------------------
    //
    private class NodeManager implements ChildrenMapManager {

        /** logger */ 
        private Logger logger = 
            LogFactory.getLogger(NodeManager.class.getName()); 

        private List list = null;

        private NodeMap nodeMap = null;

        public NodeManager(List alarms) {
            list = alarms;
        }


        public java.util.Comparator getComparator() {
            return null; //do not compare
        }
        
        public void initChildrenMap(cern.gp.nodes.children.NodeMap nodeMap) {
           
            this.nodeMap = nodeMap; 
            try {
                for (Iterator iter = list.iterator(); iter.hasNext(); ){
                    InfoAlarmBean alarmBean = (InfoAlarmBean) iter.next();
                    nodeMap.addNode(alarmBean.getAlarmId(), 
                                    NodeFactory.createNode(alarmBean));
                }
            } catch (java.beans.IntrospectionException ie) {
                logger.error(ie.getMessage(), ie);
            } 

        }
       
        public void updateManager(List newList) {
            list = newList;
            nodeMap.removeNodes(nodeMap.keySet().toArray()); 
            for (Iterator iter = list.iterator(); iter.hasNext(); ) {
                InfoAlarmBean ab = (InfoAlarmBean) iter.next(); 
                try {
                    nodeMap.addNode(ab.getAlarmId(), NodeFactory.createNode(ab));
                } catch (java.beans.IntrospectionException ie) {
                    logger.error(ie.getMessage(), ie);
                }
            }
        } 
    }


}
