/*
 * AlarmCommentPanel.java
 *
 * Created on September 2, 2003, 11:46 AM
 */

package cern.laser.guiplatform.windows.alarms;

/**
 *
 * @author  Bartlomiej Pawlowski <Bartlomiej.Pawlowski@cern.ch>
 */
public class AlarmCommentPanel extends javax.swing.JPanel {
    
    /** Creates new form AlarmCommentPanel */
    public AlarmCommentPanel() {
        this("", "");
    } 
    /** Creates new form AlarmCommentPanel */
    public AlarmCommentPanel(String operatorName, String commentText) {
        initComponents();
        postInitComponents(operatorName, commentText);
    }
   
    private void postInitComponents(String operatorName, String commentText) {
        operNameTextField.setText(operatorName);
        commentTextArea.setText(commentText);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        operatorNamePanel = new javax.swing.JPanel();
        operatorNameLabel = new javax.swing.JLabel();
        operNameTextField = new javax.swing.JTextField();
        recallButton = new javax.swing.JButton();
        commentPanel = new javax.swing.JPanel();
        commentLabel = new javax.swing.JLabel();
        commentTextArea = new javax.swing.JTextArea();

        setLayout(new java.awt.BorderLayout());

        operatorNamePanel.setLayout(new java.awt.GridBagLayout());

        operatorNamePanel.setBorder(new javax.swing.border.EtchedBorder());
        operatorNameLabel.setText("Operator's name:");
        operatorNamePanel.add(operatorNameLabel, new java.awt.GridBagConstraints());

        operNameTextField.setPreferredSize(new java.awt.Dimension(140, 19));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        operatorNamePanel.add(operNameTextField, gridBagConstraints);

        recallButton.setText("Recall");
        recallButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                recallButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        operatorNamePanel.add(recallButton, gridBagConstraints);

        add(operatorNamePanel, java.awt.BorderLayout.NORTH);

        commentPanel.setLayout(new java.awt.GridBagLayout());

        commentPanel.setBorder(new javax.swing.border.EtchedBorder());
        commentLabel.setText("Comments:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);

        commentPanel.add(commentLabel, gridBagConstraints);

        commentTextArea.setPreferredSize(new java.awt.Dimension(350, 200));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 9, 5);

        commentPanel.add(commentTextArea, gridBagConstraints);

        add(commentPanel, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents

    private void recallButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_recallButtonActionPerformed
        // Add your handling code here:
        operNameTextField.setText("");
        commentTextArea.setText("");
    }//GEN-LAST:event_recallButtonActionPerformed


    public String getOperatorName() {
        return operNameTextField.getText();
    }

    public String getCommnet() {
        return commentTextArea.getText();
    }    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel commentLabel;
    private javax.swing.JPanel commentPanel;
    private javax.swing.JTextArea commentTextArea;
    private javax.swing.JTextField operNameTextField;
    private javax.swing.JLabel operatorNameLabel;
    private javax.swing.JPanel operatorNamePanel;
    private javax.swing.JButton recallButton;
    // End of variables declaration//GEN-END:variables
    
}
