/*
 * DisplayableColumnExplorer.java
 *
 * Created on April 11, 2003, 3:01 PM
 */

package cern.laser.guiplatform.windows;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import javax.swing.JButton;

import org.apache.log4j.Logger;
import org.openide.actions.MoveDownAction;
import org.openide.actions.MoveUpAction;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

import cern.gp.nodes.GPNode;
import cern.gp.nodes.NodeFactory;
import cern.gp.nodes.children.ChildrenListManager;
import cern.gp.nodes.children.NodeList;
import cern.gp.windows.WindowUtils;
import cern.laser.guiplatform.actions.DisableColumnAction;
import cern.laser.guiplatform.actions.EnableColumnAction;
import cern.laser.guiplatform.beans.DisplayColumnBean;
import cern.laser.guiplatform.util.Constants;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.util.actions.ActionUtils;
import cern.laser.guiplatform.windowmanager.AcWindowManager;


/**
 * This explorers show column
 * These columns can be displayed on alarm console  
 *
 * @author  pawlowsk
 */
public class DisplayableColumnExplorer 
    //extends cern.gp.explorer.ListTableExplorer {
    extends cern.gp.explorer.ListExplorer {
    //extends cern.gp.explorer.TreeExplorer {
    //extends org.openide.windows.TopComponent {


    /** logger */
    private static final Logger logger =
        LogFactory.getLogger(DisplayableColumnExplorer.class.getName());

    /** user property names */
    private String [] userProperties = null;


    /** Creates new form DisplayableColumnExplorer 
     * @param userProperties user properties 
     * @param withOkButtons indicates whether this explorer should contain
     *          panel with OK, Apply, Cancel buttons,
     *          true if should contain
     *          false if not
     */
    public DisplayableColumnExplorer(String [] userProperties,
                                    /**
                                    boolean withActionButtons
                                      */
                                    boolean withOkButtons
                                    ) {
        this.userProperties = userProperties;
        withOkCancelButtonPanel = withOkButtons;
        initComponents();
        postInitComponents();
    }
    /**
     * Creates DisplayableColumnExplorer with OK, apply, cancel buttons 
     * @param userProperties user properties names 
     */
    public DisplayableColumnExplorer(String [] userProperties) {
        this(userProperties, true);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        eastPanel = new javax.swing.JPanel();
        actionButtonPanel = new javax.swing.JPanel();
        upButton = new JButton(ActionUtils.createActionForComp(this,SystemAction.get(MoveUpAction.class)));
        downButton = new JButton(ActionUtils.createActionForComp(this,
            SystemAction.get(MoveDownAction.class)));
        enableButton = new JButton(ActionUtils.createActionForComp(this,
            SystemAction.get(EnableColumnAction.class)));
        disableButton = new JButton(ActionUtils.createActionForComp(this,
            SystemAction.get(DisableColumnAction.class)));

        eastPanel.setLayout(new java.awt.BorderLayout());

        actionButtonPanel.setLayout(new java.awt.GridBagLayout());

        upButton.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        upButton.setMaximumSize(new java.awt.Dimension(88, 25));
        upButton.setPreferredSize(new java.awt.Dimension(110, 25));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 6, 2, 4);
        actionButtonPanel.add(upButton, gridBagConstraints);

        downButton.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        downButton.setPreferredSize(new java.awt.Dimension(110, 25));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 7, 4);
        actionButtonPanel.add(downButton, gridBagConstraints);

        enableButton.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        enableButton.setPreferredSize(new java.awt.Dimension(110, 25));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(7, 6, 2, 4);
        actionButtonPanel.add(enableButton, gridBagConstraints);

        disableButton.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        disableButton.setPreferredSize(new java.awt.Dimension(110, 25));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 5, 4);
        actionButtonPanel.add(disableButton, gridBagConstraints);

        eastPanel.add(actionButtonPanel, java.awt.BorderLayout.NORTH);

        add(eastPanel, java.awt.BorderLayout.EAST);

    }//GEN-END:initComponents
    
    /** postInitComponents */
    private void postInitComponents() {
      
        initNodeManager();
      
        // start: southButton
        if ( withOkCancelButtonPanel ) {
            // pre-creation southButtonPanel
            southButtonPanel = new javax.swing.JPanel();
            // post-creation southButtonPanel
            okCancelButtonPanel = new javax.swing.JPanel();
            okButton = new javax.swing.JButton();
            applyButton = new javax.swing.JButton();
            cancelButton = new javax.swing.JButton();

            southButtonPanel.setLayout(new java.awt.BorderLayout());

            // pre-init sounthButtonPanel
            // post-init southButtonPanel
            okButton.setText(NbBundle.getMessage(DisplayableColumnExplorer.class,
                                                "LBL_OK_label"));
            okButton.setPreferredSize(new java.awt.Dimension(75, 25));
            okCancelButtonPanel.add(okButton);

            applyButton.setText(NbBundle.getMessage(DisplayableColumnExplorer.class,
                                                     "LBL_Apply_label"));
            applyButton.setPreferredSize(new java.awt.Dimension(75, 25));
            okCancelButtonPanel.add(applyButton);

            cancelButton.setText(NbBundle.getMessage(DisplayableColumnExplorer.class,
                                                     "LBL_Cancel_label"));
            okCancelButtonPanel.add(cancelButton);

            southButtonPanel.add(okCancelButtonPanel, java.awt.BorderLayout.EAST);

            add(southButtonPanel, java.awt.BorderLayout.SOUTH);

            // end: southButton
     
            cancelButton.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    cancelButtonActionPerformed(evt);
                }
            });
            
            okButton.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    okButtonActionPerformed(evt);
                }
            });

            applyButton.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    applyButtonActionPerformed(evt);
                }
            });
        }  
    }
   


    /** Init mode manger, used for creation nodeManager, and when this
     * explorer should be reset
     */
    private void initNodeManager() {
        nodeManager = new DisplayableColumnNodeManager(
                            Constants.getPropertyNames(),
                            Constants.getDisplayColumnNames(),
                            userProperties
                            );
        //rootNode = new Object(); 
        rootNode = new DisplayColumnBean(); 
        try {
            setRootNode(NodeFactory.createNode(rootNode, nodeManager));
        } catch (IntrospectionException ie) { 
            logger.error(ie, ie.fillInStackTrace()); 
        }
    }
    /** from TopComponent */
    public String getName() {
        return "Choose columns";
    }
    
    /**
     * This method returns enabled columns
     * @return List with propertyNames (i.e. faultMember)
     */
    public List getEnabledColumns() {
        return nodeManager.getEnabledColumns();
    }
    
    public void okButtonActionPerformed(java.awt.event.ActionEvent actionEvent) {
        List list = getEnabledColumns();
        logger.debug("enabled columns count " + list.size());
        logger.debug(list.toString());
        
        String compName = NbBundle.getMessage(ActiveListExplorerPanel.class, 
                                   "LBL_Active_list_component_name");
        String [] newColumns = (String [])list.toArray(new String[0]);
       
        AcWindowManager.setTableColumns(compName, newColumns);
        close(); 
       
    }    
    
    public void cancelButtonActionPerformed(java.awt.event.ActionEvent actionEvent) {
        close();
    }    

    public void applyButtonActionPerformed(java.awt.event.ActionEvent actionEvent) {
        List list = getEnabledColumns();
        String compName = NbBundle.getMessage(ActiveListExplorerPanel.class, 
                                   "LBL_Active_list_component_name");
        String [] newColumns = (String [])list.toArray(new String[0]);
       
        AcWindowManager.setTableColumns(compName, newColumns);
    } 


    /**
     * Reset this explorer
     */
    public void reset() {
        initNodeManager();
    }


    /** Method for test execution */
    public static void main(String args[]) {
        DisplayableColumnExplorer expl = new DisplayableColumnExplorer(
                            new String [] { "faultFamily", "faultMember", });
        WindowUtils.openInMode(expl, expl.getName());

    }
   
    public void updateColumns(String [] newUserProperties) {
        userProperties = newUserProperties;
        initNodeManager();  
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel actionButtonPanel;
    private javax.swing.JButton disableButton;
    private javax.swing.JButton downButton;
    private javax.swing.JPanel eastPanel;
    private javax.swing.JButton enableButton;
    private javax.swing.JButton upButton;
    // End of variables declaration//GEN-END:variables
    
    private javax.swing.JButton okButton;
    private javax.swing.JButton applyButton;
    private javax.swing.JButton cancelButton;
    private javax.swing.JPanel okCancelButtonPanel;
    private javax.swing.JPanel southButtonPanel;
  
    /** indicates wether this explorer should have okCancelButtonPanel */ 
    private boolean withOkCancelButtonPanel = true;

 
    /** node Manager */
    private DisplayableColumnNodeManager nodeManager = null;
    /** root Node */
    private Object rootNode = null;

    //
    // -- node Manager ----------------------------------------
    //
    private class DisplayableColumnNodeManager implements ChildrenListManager {
        /** logger */
        private final Logger logger =
            Logger.getLogger(DisplayableColumnNodeManager.class.getName());
    
        /** node list */
        private NodeList nodeList = null; 
     
        /** all property names */ 
        private String [] allProperties = null;
        /** all property display names */
        private String [] allPropertyDisplayNames = null;

        /** user property names */
        private String [] userProperties = null;

        /**
         * Create new <code>DisplayableColumnNodeManager</code> object
         * @param allPropertyNames matrix with property names, this properties
         *          comes from <code>DisplayableChangeEventAdapter</code>
         * @param allPropertyDisplayNames matrix with display names for each 
         *          property name
         * @param userPropertyNames matrix with user properties
         */
        public DisplayableColumnNodeManager(String [] allPropertyNames, 
                                            String [] allPropertyDisplayNames,
                                            String [] userPropertyNames
                                            ) {
            allProperties = allPropertyNames;
            this.allPropertyDisplayNames = allPropertyDisplayNames;
            userProperties = userPropertyNames;

        }
                
        
        public java.util.Comparator getComparator() {
            return null;   // do not compare
        }
        /** method from interface */ 
        public void initChildrenList(NodeList nodeList) {
            this.nodeList = nodeList;

            List userPropNames = Arrays.asList(userProperties);
            for (int i = 0; i < allProperties.length; i++) {
                String propName = allProperties[i];
                String dispName = allPropertyDisplayNames[i];
                String iconPath = Constants.DISABLE_COLUMN_ICON_PATH;
                boolean enabled = false;
                if ( userPropNames.contains(propName) ) {
                    iconPath = Constants.ENABLE_COLUMN_ICON_PATH;
                    enabled = true;
                }
                try {
                    nodeList.addNode(NodeFactory.createNode(
                            new DisplayColumnBean(propName, dispName,
                                                  iconPath, enabled)
                        )
                    );
                } catch (java.beans.IntrospectionException ie) {
                    logger.error(ie.toString());
                }
            }
        }
        /** This method return enabled columns 
         * @return enabled columns or empty list
         */
        public List getEnabledColumns() {
            ArrayList list = new ArrayList();
            Iterator iter = nodeList.iterator();
            while (iter.hasNext()) {
                DisplayColumnBean bean = (DisplayColumnBean) ((GPNode) iter.next()).getBean();
                if ( bean.isEnabled() ) 
                    list.add(bean.getName());
            }
            return list;
        }
    } 
}
