/*
* Copyright (C) The Community OpenORB Project. All rights reserved.
*
* This software is published under the terms of The OpenORB Community Software
* License version 1.0, a copy of which has been included with this distribution
* in the LICENSE.txt file.
*/
package org.openorb.util.urlhandler;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;

import org.openorb.util.urlhandler.resource.Handler;

/**
 * This is the factory class to create a custom URL stream handler.
 *
 * @author  Chris Wood
 * @version $Revision: 1.4 $ $Date: 2002/06/28 08:59:06 $ 
 */
public class HandlerFactory
    extends java.lang.Object
    implements URLStreamHandlerFactory
{
    /**
     * Returns a URLStreamHandler instance when the parameter
     * was equal to &quot;classpath&quot;.
     *
     * @param p A string specifying the stream handler to create.
     * @return A stream handler instance when the parameter p
     * is equal to &quot;classpath&quot; or null otherwise.
     */
    public URLStreamHandler createURLStreamHandler( String p )
    {
        if ( p.equals( "classpath" ) )
            return new Handler();

        return null;
    }

}
