/*
* Copyright (C) The Community OpenORB Project. All rights reserved.
*
* This software is published under the terms of The OpenORB Community Software
* License version 1.0, a copy of which has been included with this distribution
* in the LICENSE.txt file.
*/

package org.openorb.compiler.object;

import org.openorb.compiler.parser.*;

/**
 * Cette classe represente l'objet IDL Param
 *
 * @author Jerome Daniel
 * @version $Revision: 1.4 $ $Date: 2002/08/21 08:19:22 $ 
 */

public class IdlParam extends IdlObject implements org.openorb.compiler.idl.reflect.idlParameter
{
    /**
     * Flag qui indique l'attribut du parametre
     */
    private int _attr;

    /**
     * Cree un objet IDL Param
     */
    public IdlParam( IdlObject father )
    {
        super( IdlType.e_param, father );
    }

    /**
     * Retourne l'attribut du parametre
     *
     * @return l'attribut
     */
    public int param_attr()
    {
        return _attr;
    }

    /**
     * Fixe l'attribut du parametre
     *
     * @param val l'attribut
     */
    public void param_attr ( int val )
    {
        _attr = val;
    }

    // ------------------------------------------------------------------------------------------
    // IDL Reflection
    // ------------------------------------------------------------------------------------------

    public int paramMode()
    {
        return _attr;
    }

    public org.openorb.compiler.idl.reflect.idlObject paramType()
    {
        reset();
        return current();
    }

    public java.util.Enumeration content()
    {
        return new org.openorb.compiler.idl.reflect.idlEnumeration( null );
    }
}
