/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.LayoutPersistence;
import com.jidesoft.swing.Searchable;
import com.jidesoft.utils.SecurityUtils;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class AbstractLayoutPersistence
implements LayoutPersistence {
    public static final short V2004 = 19;
    public static final short V2005_09 = 20;
    protected short _version = (short)20;
    protected static final String DEFAULT_PROFILE_NAME = "default";
    public static final String PROPERTY_PROFILE_KEY = "profileKey";
    public static final String PROPERTY_USE_PREF = "usePref";
    public static final String PROPERTY_VERSION = "version";
    protected String _profileKey = "profile";
    protected static final int MAX_PREF_BYTE_ARRAY_LENGTH = 6144;
    protected boolean _loadingLayoutData = false;
    protected boolean _useFrameBounds = true;
    protected boolean _useFrameState = true;
    protected boolean _usePref = true;
    protected static final String LAYOUT_COUNT_STRING = "_count";
    protected final String LAYOUT_POSTFIX = ".layout";
    protected String _layoutDirectory = null;
    private PropertyChangeSupport a;
    private boolean b = true;

    public short getVersion() {
        return this._version;
    }

    public void setVersion(short s) {
        this._version = s;
    }

    public String getProfileKey() {
        return this._profileKey;
    }

    public void setProfileKey(String string) {
        block9: {
            String string2;
            block8: {
                int n;
                block6: {
                    String string3;
                    block7: {
                        block5: {
                            block4: {
                                n = Searchable.y;
                                string3 = string;
                                if (n != 0) break block4;
                                if (string3 == null) break block5;
                                string3 = string.trim();
                            }
                            if (n != 0) break block6;
                            if (string3.length() != 0) break block7;
                        }
                        throw new IllegalArgumentException("profileKey cannot be null or empty.");
                    }
                    string3 = string2 = this._profileKey;
                }
                if (n != 0) break block8;
                if (string.equals(string2)) break block9;
                this._profileKey = string;
            }
            this.firePropertyChange(PROPERTY_PROFILE_KEY, string2, string);
        }
    }

    private static void a(Preferences preferences, String string, byte[] byArray) {
        block14: {
            int n;
            int n2;
            int n3;
            int n4;
            block12: {
                block13: {
                    n4 = Searchable.y;
                    n3 = byArray.length;
                    if (n4 != 0) break block12;
                    if (n3 > 6144) break block13;
                    n2 = preferences.getInt(string + LAYOUT_COUNT_STRING, -99);
                    if (n4 == 0) {
                        if (n2 > 0) {
                            for (n = 0; n < n2; ++n) {
                                preferences.remove(string + "_" + n);
                                if (n4 == 0) {
                                    if (n4 == 0) continue;
                                }
                                break;
                            }
                        } else {
                            preferences.putByteArray(string, byArray);
                            preferences.putInt(string + LAYOUT_COUNT_STRING, 0);
                        }
                    }
                    if (n4 == 0) break block14;
                }
                n3 = preferences.getInt(string + LAYOUT_COUNT_STRING, -99);
            }
            int n5 = n2 = n3;
            if (n4 == 0) {
                if (n5 == 0) {
                    preferences.remove(string);
                }
                n5 = byArray.length / 6144 + 1;
            }
            n = n5;
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, byArray.length);
            byte[] byArray2 = new byte[6144];
            for (int k = 0; k < n; ++k) {
                block17: {
                    int n6;
                    int n7;
                    block15: {
                        block16: {
                            n7 = k;
                            n6 = n - 1;
                            if (n4 != 0) break block15;
                            if (n7 == n6) break block16;
                            byteBuffer.get(byArray2, 0, 6144);
                            if (n4 == 0) break block17;
                        }
                        n7 = byArray.length;
                        n6 = k * 6144;
                    }
                    int n8 = n7 - n6;
                    byArray2 = new byte[n8];
                    byteBuffer.get(byArray2, 0, n8);
                }
                preferences.putByteArray(string + "_" + k, byArray2);
                if (n4 == 0) continue;
            }
            preferences.putInt(string + LAYOUT_COUNT_STRING, n);
        }
    }

    private static byte[] a(Preferences preferences, String string) {
        int n;
        ByteBuffer byteBuffer;
        block4: {
            int n2;
            int n3 = Searchable.y;
            byte[] byArray = new byte[]{};
            int n4 = n2 = preferences.getInt(string + LAYOUT_COUNT_STRING, 0);
            if (n3 == 0) {
                if (n4 == 0) {
                    return preferences.getByteArray(string, byArray);
                }
                n4 = n2 * 6144;
            }
            byteBuffer = ByteBuffer.allocate(n4);
            for (n = 0; n < n2; ++n) {
                byteBuffer.put(preferences.getByteArray(string + "_" + n, byArray));
                if (n3 == 0) {
                    if (n3 == 0) continue;
                }
                break block4;
            }
            n = byteBuffer.position();
        }
        byte[] byArray = new byte[n];
        byteBuffer.position(0);
        byteBuffer.get(byArray, 0, n);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLayoutData() {
        boolean bl = this._loadingLayoutData;
        this._loadingLayoutData = true;
        try {
            this.loadLayoutDataFrom(DEFAULT_PROFILE_NAME);
        }
        finally {
            this._loadingLayoutData = bl;
        }
    }

    public boolean isLayoutAvailable(String string) {
        int n;
        block8: {
            int n2;
            block7: {
                n = Searchable.y;
                n2 = this._usePref;
                if (n != 0) break block7;
                if (n2 == 0) break block8;
                n2 = 0;
            }
            byte[] byArray = new byte[n2];
            Preferences preferences = null;
            try {
                preferences = Preferences.userRoot();
            }
            catch (AccessControlException accessControlException) {
                return false;
            }
            byArray = AbstractLayoutPersistence.a(preferences.node(this._profileKey), string);
            boolean bl = byArray.length;
            if (n == 0) {
                if (!bl) {
                    return false;
                }
                bl = true;
            }
            return bl;
        }
        String string2 = this.getLayoutDirectory() + File.separator + string + ".layout";
        File file = new File(string2);
        boolean bl = file.exists();
        if (n == 0) {
            if (!bl) {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    public List getAvailableLayouts() {
        File[] fileArray;
        File file;
        int n = Searchable.y;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this._usePref) {
            Preferences preferences = null;
            try {
                preferences = Preferences.userRoot();
            }
            catch (AccessControlException accessControlException) {
                return arrayList;
            }
            try {
                Preferences preferences2 = preferences.node(this._profileKey);
                String[] stringArray = preferences2.keys();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    String string = stringArray[n2];
                    if (n == 0) {
                        if (n == 0) {
                            if (string.endsWith(LAYOUT_COUNT_STRING)) {
                                arrayList.add(string.substring(0, string.length() - LAYOUT_COUNT_STRING.length()));
                            }
                            ++n2;
                        }
                        if (n == 0) continue;
                    }
                    break;
                }
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
            return arrayList;
        }
        String string = this.getLayoutDirectory() + File.separator;
        File file2 = file = new File(string);
        if (n == 0) {
            if (!file2.exists()) {
                return arrayList;
            }
            file2 = file;
        }
        if ((fileArray = file2.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".layout");
            }
        })) != null) {
            int n3 = 0;
            while (n3 < fileArray.length) {
                String string2 = fileArray[n3].getName();
                if (n == 0) {
                    if (string2.endsWith(".layout")) {
                        arrayList.add(string2.substring(0, string2.length() - ".layout".length()));
                    }
                    ++n3;
                }
                if (n == 0) continue;
            }
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeLayout(String string) {
        Object object;
        Object object2;
        int n = Searchable.y;
        if (this._usePref) {
            block11: {
                int n2;
                int n3;
                object2 = null;
                try {
                    object2 = Preferences.userRoot();
                }
                catch (AccessControlException accessControlException) {
                    return;
                }
                object = ((Preferences)object2).node(this._profileKey);
                int n4 = n3 = ((Preferences)object).getInt(string + LAYOUT_COUNT_STRING, 0);
                if (n == 0) {
                    if (n4 == 0) {
                        return;
                    }
                    n4 = n2 = 0;
                }
                while (n2 < n3) {
                    ((Preferences)object).remove(string + "_" + n2);
                    ++n2;
                    if (n == 0) {
                        if (n == 0) continue;
                    }
                    break block11;
                }
                ((Preferences)object).remove(string + LAYOUT_COUNT_STRING);
            }
            if (n == 0) return;
        }
        object2 = this.getLayoutDirectory() + File.separator + string + ".layout";
        try {
            object = new File((String)object2);
            boolean bl = ((File)object).exists();
            if (n == 0) {
                if (!bl) {
                    return;
                }
                bl = ((File)object).delete();
            }
            if (!bl) return;
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLayoutDataFrom(String string) {
        block13: {
            int n = Searchable.y;
            boolean bl = this._loadingLayoutData;
            this._loadingLayoutData = true;
            try {
                int n2;
                byte[] byArray;
                block20: {
                    block19: {
                        byte[] byArray2;
                        block18: {
                            block15: {
                                Object object;
                                block14: {
                                    byArray = new byte[]{};
                                    if (!this._usePref) break block14;
                                    object = null;
                                    try {
                                        object = Preferences.userRoot();
                                        byArray = AbstractLayoutPersistence.a(((Preferences)object).node(this._profileKey), string);
                                    }
                                    catch (AccessControlException accessControlException) {
                                        this.resetToDefault();
                                    }
                                    if (n == 0) break block15;
                                }
                                object = this.getLayoutDirectory() + File.separator + string + ".layout";
                                try {
                                    File file;
                                    block17: {
                                        boolean bl2;
                                        block16: {
                                            file = new File((String)object);
                                            bl2 = file.exists();
                                            if (n != 0) break block16;
                                            if (bl2) break block17;
                                            bl2 = file.createNewFile();
                                        }
                                        if (!bl2) {
                                            throw new IOException("Cannot open " + (String)object);
                                        }
                                    }
                                    FileInputStream fileInputStream = new FileInputStream(file);
                                    int n3 = fileInputStream.available();
                                    byArray = new byte[n3];
                                    fileInputStream.read(byArray);
                                    fileInputStream.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            byArray2 = byArray;
                            if (n != 0) break block18;
                            if (byArray2 == null) break block19;
                            byArray2 = byArray;
                        }
                        n2 = byArray2.length;
                        if (n != 0) break block13;
                        if (n2 != 0) break block20;
                    }
                    this.resetToDefault();
                    if (n == 0) break block13;
                }
                n2 = this.loadLayoutFrom(new ByteArrayInputStream(byArray)) ? 1 : 0;
            }
            finally {
                this._loadingLayoutData = bl;
            }
        }
    }

    public boolean isLayoutDataVersionValid(String string) {
        Object object;
        byte[] byArray;
        block18: {
            boolean bl;
            block17: {
                block16: {
                    byte[] byArray2;
                    int n;
                    block15: {
                        block11: {
                            block10: {
                                n = Searchable.y;
                                byArray = new byte[]{};
                                if (!this._usePref) break block10;
                                object = null;
                                try {
                                    object = Preferences.userRoot();
                                    byArray = AbstractLayoutPersistence.a(((Preferences)object).node(this._profileKey), string);
                                }
                                catch (AccessControlException accessControlException) {
                                    this.resetToDefault();
                                }
                                if (n == 0) break block11;
                            }
                            object = this.getLayoutDirectory() + File.separator + string + ".layout";
                            try {
                                File file;
                                block13: {
                                    boolean bl2;
                                    block14: {
                                        block12: {
                                            file = new File((String)object);
                                            bl2 = file.exists();
                                            if (n != 0) break block12;
                                            if (bl2) break block13;
                                            bl2 = file.createNewFile();
                                        }
                                        if (n != 0) break block14;
                                        if (bl2) break block13;
                                        bl2 = false;
                                    }
                                    return bl2;
                                }
                                FileInputStream fileInputStream = new FileInputStream(file);
                                int n2 = fileInputStream.available();
                                byArray = new byte[n2];
                                fileInputStream.read(byArray);
                                fileInputStream.close();
                            }
                            catch (Exception exception) {
                                return false;
                            }
                        }
                        byArray2 = byArray;
                        if (n != 0) break block15;
                        if (byArray2 == null) break block16;
                        byArray2 = byArray;
                    }
                    bl = byArray2.length;
                    if (n != 0) break block17;
                    if (bl) break block18;
                }
                bl = false;
            }
            return bl;
        }
        object = new DataInputStream(new ByteArrayInputStream(byArray));
        try {
            short s = ((DataInputStream)object).readShort();
            return this.isVersionCompatible(s);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isVersionCompatible(int n) {
        int n2 = Searchable.y;
        int n3 = this._version;
        if (n2 != 0) return n3 != 0;
        if (n3 == n) return 1 != 0;
        n3 = this._version;
        int n4 = 20;
        if (n2 == 0) {
            if (n3 != n4) return 0 != 0;
            n3 = n;
            if (n2 != 0) return n3 != 0;
            n4 = 19;
        }
        if (n3 != n4) return 0 != 0;
        return 1 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLayoutDataFromFile(String string) {
        block8: {
            int n = Searchable.y;
            boolean bl = this._loadingLayoutData;
            this._loadingLayoutData = true;
            try {
                int n2;
                byte[] byArray;
                block11: {
                    block10: {
                        byte[] byArray2;
                        block9: {
                            byArray = null;
                            try {
                                File file = new File(string);
                                if (file.exists()) {
                                    FileInputStream fileInputStream = new FileInputStream(file);
                                    int n3 = fileInputStream.available();
                                    byArray = new byte[n3];
                                    fileInputStream.read(byArray);
                                    fileInputStream.close();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            byArray2 = byArray;
                            if (n != 0) break block9;
                            if (byArray2 == null) break block10;
                            byArray2 = byArray;
                        }
                        n2 = byArray2.length;
                        if (n != 0) break block8;
                        if (n2 != 0) break block11;
                    }
                    this.resetToDefault();
                    if (n == 0) break block8;
                }
                n2 = this.loadLayoutFrom(new ByteArrayInputStream(byArray)) ? 1 : 0;
            }
            finally {
                this._loadingLayoutData = bl;
            }
        }
    }

    public void saveLayoutData() {
        AbstractLayoutPersistence abstractLayoutPersistence = this;
        if (Searchable.y == 0) {
            if (abstractLayoutPersistence._loadingLayoutData) {
                return;
            }
            abstractLayoutPersistence = this;
        }
        abstractLayoutPersistence.saveLayoutDataAs(DEFAULT_PROFILE_NAME);
    }

    public String getLayoutDirectory() {
        String string;
        block4: {
            block5: {
                String string2;
                block7: {
                    boolean bl;
                    block6: {
                        int n = Searchable.y;
                        string = this._layoutDirectory;
                        if (n != 0) break block4;
                        if (string != null) break block5;
                        string2 = SecurityUtils.getProperty("user.home", "") + File.separator + "." + this._profileKey;
                        File file = new File(string2);
                        bl = file.isDirectory();
                        if (n != 0) break block6;
                        if (bl) break block7;
                        bl = file.mkdirs();
                    }
                    if (!bl) {
                        System.err.println("Failed to create directory: " + string2);
                    }
                }
                return string2;
            }
            string = this._layoutDirectory;
        }
        return string;
    }

    public void setLayoutDirectory(String string) {
        this._layoutDirectory = string;
    }

    public void saveLayoutDataAs(String string) {
        block13: {
            int n = Searchable.y;
            if (this._loadingLayoutData) {
                return;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                Object object;
                this.saveLayoutTo(byteArrayOutputStream);
                if (this._usePref) {
                    object = null;
                    try {
                        object = Preferences.userRoot();
                        AbstractLayoutPersistence.a(((Preferences)object).node(this._profileKey), string, byteArrayOutputStream.toByteArray());
                    }
                    catch (AccessControlException accessControlException) {
                        // empty catch block
                    }
                    if (n == 0) break block13;
                }
                object = this.getLayoutDirectory() + File.separator + string + ".layout";
                try {
                    File file;
                    block15: {
                        boolean bl;
                        block14: {
                            file = new File((String)object);
                            bl = file.exists();
                            if (n != 0) break block14;
                            if (bl) break block15;
                            bl = file.createNewFile();
                        }
                        if (!bl) {
                            throw new IOException("Cannot open " + (String)object);
                        }
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(byteArrayOutputStream.toByteArray());
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    System.err.println(exception.getLocalizedMessage());
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLayoutDataToFile(String string) {
        if (this._loadingLayoutData) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.saveLayoutTo(byteArrayOutputStream);
            try {
                File file;
                block12: {
                    boolean bl;
                    block11: {
                        file = new File(string);
                        bl = file.exists();
                        if (Searchable.y != 0) break block11;
                        if (bl) break block12;
                        bl = file.createNewFile();
                    }
                    if (!bl) {
                        throw new IOException("Cannot open " + string);
                    }
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byteArrayOutputStream.toByteArray());
                fileOutputStream.close();
            }
            catch (Exception exception) {
                System.err.println(exception.getLocalizedMessage());
            }
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getLocalizedMessage());
        }
    }

    public void setLayoutRawData(byte[] byArray) {
        this.loadLayoutFrom(new ByteArrayInputStream(byArray));
    }

    public byte[] getLayoutRawData() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.saveLayoutTo(byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getLocalizedMessage());
            return new byte[0];
        }
    }

    public void setLayoutData(String string) {
        this.loadLayoutFrom(new ByteArrayInputStream(string.getBytes()));
    }

    public String getLayoutData() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.saveLayoutTo(byteArrayOutputStream);
            return byteArrayOutputStream.toString();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getLocalizedMessage());
            return "";
        }
    }

    public void setLayoutData(String string, String string2) {
        try {
            this.loadLayoutFrom(new ByteArrayInputStream(string.getBytes(string2)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(unsupportedEncodingException.getLocalizedMessage());
        }
    }

    public String getLayoutData(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.saveLayoutTo(byteArrayOutputStream);
            return byteArrayOutputStream.toString(string);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getLocalizedMessage());
            return "";
        }
    }

    public boolean isUsePref() {
        return this._usePref;
    }

    public void setUsePref(boolean bl) {
        block3: {
            boolean bl2;
            block2: {
                bl2 = this._usePref;
                if (Searchable.y != 0) break block2;
                if (bl == bl2) break block3;
                this._usePref = bl;
            }
            this.firePropertyChange(PROPERTY_USE_PREF, bl2, bl);
        }
    }

    public void setUseFrameState(boolean bl) {
        this._useFrameState = bl;
    }

    public void setUseFrameBounds(boolean bl) {
        this._useFrameBounds = bl;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        PropertyChangeSupport propertyChangeSupport = this.a;
        if (Searchable.y == 0) {
            if (propertyChangeSupport == null) {
                this.a = new PropertyChangeSupport(this);
            }
            propertyChangeSupport = this.a;
        }
        propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport;
        block3: {
            block4: {
                block2: {
                    if (propertyChangeListener == null) break block2;
                    propertyChangeSupport = this.a;
                    if (Searchable.y != 0) break block3;
                    if (propertyChangeSupport != null) break block4;
                }
                return;
            }
            propertyChangeSupport = this.a;
        }
        propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        PropertyChangeSupport propertyChangeSupport = this.a;
        if (Searchable.y == 0) {
            if (propertyChangeSupport == null) {
                return new PropertyChangeListener[0];
            }
            propertyChangeSupport = this.a;
        }
        return propertyChangeSupport.getPropertyChangeListeners();
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        PropertyChangeSupport propertyChangeSupport = this.a;
        if (Searchable.y == 0) {
            if (propertyChangeSupport == null) {
                this.a = new PropertyChangeSupport(this);
            }
            propertyChangeSupport = this.a;
        }
        propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport;
        block3: {
            block4: {
                block2: {
                    if (propertyChangeListener == null) break block2;
                    propertyChangeSupport = this.a;
                    if (Searchable.y != 0) break block3;
                    if (propertyChangeSupport != null) break block4;
                }
                return;
            }
            propertyChangeSupport = this.a;
        }
        propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        PropertyChangeSupport propertyChangeSupport = this.a;
        if (Searchable.y == 0) {
            if (propertyChangeSupport == null) {
                return new PropertyChangeListener[0];
            }
            propertyChangeSupport = this.a;
        }
        return propertyChangeSupport.getPropertyChangeListeners(string);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeSupport propertyChangeSupport;
        PropertyChangeSupport propertyChangeSupport2 = propertyChangeSupport = this.a;
        if (Searchable.y == 0) {
            if (propertyChangeSupport2 == null) {
                return;
            }
            propertyChangeSupport2 = propertyChangeSupport;
        }
        propertyChangeSupport2.firePropertyChange(string, object, object2);
    }

    protected void firePropertyChange(String string, boolean bl, boolean bl2) {
        PropertyChangeSupport propertyChangeSupport;
        PropertyChangeSupport propertyChangeSupport2 = propertyChangeSupport = this.a;
        if (Searchable.y == 0) {
            if (propertyChangeSupport2 == null) {
                return;
            }
            propertyChangeSupport2 = propertyChangeSupport;
        }
        propertyChangeSupport2.firePropertyChange(string, bl, bl2);
    }

    protected void firePropertyChange(String string, int n, int n2) {
        PropertyChangeSupport propertyChangeSupport;
        PropertyChangeSupport propertyChangeSupport2 = propertyChangeSupport = this.a;
        if (Searchable.y == 0) {
            if (propertyChangeSupport2 == null) {
                return;
            }
            propertyChangeSupport2 = propertyChangeSupport;
        }
        propertyChangeSupport2.firePropertyChange(string, n, n2);
    }

    public void loadInitialLayout(String string) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new File(string));
        this.loadInitialLayout(document);
    }

    public void loadInitialLayout(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        this.loadInitialLayout(document);
    }

    public boolean isLast() {
        return this.b;
    }

    public void setLast(boolean bl) {
        this.b = bl;
    }
}

