/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.type.baseimpl.types;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.openarchitectureware.expression.TypeSystem;
import org.openarchitectureware.type.Feature;
import org.openarchitectureware.type.Type;
import org.openarchitectureware.type.baseimpl.OperationImpl;
import org.openarchitectureware.type.baseimpl.types.BuiltinBaseType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntegerTypeImpl
extends BuiltinBaseType
implements Type {
    public IntegerTypeImpl(TypeSystem ts, String name) {
        super(ts, name);
    }

    @Override
    public boolean isInstance(Object o) {
        return o instanceof Integer || o instanceof BigInteger || o instanceof Byte || o instanceof Long || o instanceof Short;
    }

    @Override
    public Object newInstance() {
        return new Long(-1L);
    }

    @Override
    public Feature[] getContributedFeatures() {
        return new Feature[]{new OperationImpl(this, "+", (Type)this, new Type[]{this}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (params[0] == null) {
                    return null;
                }
                return new Long(((Number)target).longValue() + ((Number)params[0]).longValue());
            }
        }, new OperationImpl(this, "-", (Type)this, new Type[]{this}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (params[0] == null) {
                    return null;
                }
                return new Long(((Number)target).longValue() - ((Number)params[0]).longValue());
            }
        }, new OperationImpl(this, "-", (Type)this, new Type[0]){

            public Object evaluateInternal(Object target, Object[] params) {
                return new Long(((Number)target).longValue() * -1L);
            }
        }, new OperationImpl(this, "*", (Type)this, new Type[]{this}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (params[0] == null) {
                    return null;
                }
                return new Long(((Number)target).longValue() * ((Number)params[0]).longValue());
            }
        }, new OperationImpl(this, "/", (Type)this, new Type[]{this}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (params[0] == null) {
                    return null;
                }
                return new Long(((Number)target).longValue() / ((Number)params[0]).longValue());
            }
        }, new OperationImpl(this, "==", this.getTypeSystem().getBooleanType(), new Type[]{this.getTypeSystem().getObjectType()}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    return new Boolean(target == params[0]);
                }
                try {
                    return IntegerTypeImpl.this.toLong(target).equals(IntegerTypeImpl.this.toLong(params[0]));
                }
                catch (Exception exception) {
                    if (target instanceof Number && params[0] instanceof Number) {
                        if (((Number)target).doubleValue() == ((Number)params[0]).doubleValue()) {
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
            }
        }, new OperationImpl(this, "!=", this.getTypeSystem().getBooleanType(), new Type[]{this.getTypeSystem().getObjectType()}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    if (params[0] != null) {
                        return true;
                    }
                    return false;
                }
                try {
                    return !IntegerTypeImpl.this.toLong(target).equals(IntegerTypeImpl.this.toLong(params[0]));
                }
                catch (Exception exception) {
                    if (target instanceof Number && params[0] instanceof Number) {
                        if (((Number)target).doubleValue() != ((Number)params[0]).doubleValue()) {
                            return true;
                        }
                        return false;
                    }
                    return true;
                }
            }
        }, new OperationImpl(this, ">", this.getTypeSystem().getBooleanType(), new Type[]{this.getTypeSystem().getObjectType()}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    return Boolean.FALSE;
                }
                if (params[0] == null) {
                    return Boolean.FALSE;
                }
                try {
                    if (IntegerTypeImpl.this.toLong(target).compareTo(IntegerTypeImpl.this.toLong(params[0])) > 0) {
                        return true;
                    }
                    return false;
                }
                catch (Exception exception) {
                    if (((Number)target).doubleValue() > ((Number)params[0]).doubleValue()) {
                        return true;
                    }
                    return false;
                }
            }
        }, new OperationImpl(this, ">=", this.getTypeSystem().getBooleanType(), new Type[]{this.getTypeSystem().getObjectType()}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    return params[0] == null ? Boolean.TRUE : Boolean.FALSE;
                }
                if (params[0] == null) {
                    return Boolean.FALSE;
                }
                try {
                    if (IntegerTypeImpl.this.toLong(target).compareTo(IntegerTypeImpl.this.toLong(params[0])) >= 0) {
                        return true;
                    }
                    return false;
                }
                catch (Exception exception) {
                    if (((Number)target).doubleValue() >= ((Number)params[0]).doubleValue()) {
                        return true;
                    }
                    return false;
                }
            }
        }, new OperationImpl(this, "<", this.getTypeSystem().getBooleanType(), new Type[]{this.getTypeSystem().getObjectType()}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    return Boolean.FALSE;
                }
                if (params[0] == null) {
                    return Boolean.FALSE;
                }
                try {
                    if (IntegerTypeImpl.this.toLong(target).compareTo(IntegerTypeImpl.this.toLong(params[0])) < 0) {
                        return true;
                    }
                    return false;
                }
                catch (Exception exception) {
                    if (((Number)target).doubleValue() < ((Number)params[0]).doubleValue()) {
                        return true;
                    }
                    return false;
                }
            }
        }, new OperationImpl(this, "<=", this.getTypeSystem().getBooleanType(), new Type[]{this.getTypeSystem().getObjectType()}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    return params[0] == null ? Boolean.TRUE : Boolean.FALSE;
                }
                if (params[0] == null) {
                    return Boolean.FALSE;
                }
                try {
                    if (IntegerTypeImpl.this.toLong(target).compareTo(IntegerTypeImpl.this.toLong(params[0])) <= 0) {
                        return true;
                    }
                    return false;
                }
                catch (Exception exception) {
                    if (((Number)target).doubleValue() <= ((Number)params[0]).doubleValue()) {
                        return true;
                    }
                    return false;
                }
            }
        }, new OperationImpl(this, "upTo", this.getTypeSystem().getListType(this), new Type[]{this}){

            public String getDocumentation() {
                return "returns a List of Integers starting with the value of the target expression, up tothe value of the specified Integer, incremented by one.<br/>e.g. '1.upTo(5)' evaluates to {1,2,3,4,5}";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                ArrayList<Long> result = new ArrayList<Long>();
                long l1 = IntegerTypeImpl.this.toLong(target);
                long l2 = IntegerTypeImpl.this.toLong(params[0]);
                while (l1 <= l2) {
                    result.add(new Long(l1));
                    ++l1;
                }
                return result;
            }
        }, new OperationImpl(this, "upTo", this.getTypeSystem().getListType(this), new Type[]{this, this}){

            public String getDocumentation() {
                return "returns a List of Integers starting with the value of the target expression, up tothe value of the first paramter, incremented by the second parameter.<br/>e.g. '1.upTo(10, 2)' evaluates to {1,3,5,7,9}";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                ArrayList<Long> result = new ArrayList<Long>();
                long l1 = IntegerTypeImpl.this.toLong(target);
                long l2 = IntegerTypeImpl.this.toLong(params[0]);
                long l3 = IntegerTypeImpl.this.toLong(params[1]);
                while (l1 <= l2) {
                    result.add(new Long(l1));
                    l1 += l3;
                }
                return result;
            }
        }};
    }

    public Set<Type> getSuperTypes() {
        return Collections.singleton(this.getTypeSystem().getRealType());
    }

    Long toLong(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Integer) {
            return new Long(((Integer)o).longValue());
        }
        if (o instanceof BigInteger) {
            return new Long(((BigInteger)o).longValue());
        }
        if (o instanceof Byte) {
            return new Long(((Byte)o).longValue());
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Short) {
            return new Long(((Short)o).longValue());
        }
        throw new IllegalArgumentException(String.valueOf(o.getClass().getName()) + " not supported");
    }

    @Override
    public Object convert(Object src, Class<?> targetType) {
        Long l = this.toLong(src);
        if (targetType.isAssignableFrom(Integer.class) || targetType.isAssignableFrom(Integer.TYPE)) {
            return new Integer(l.intValue());
        }
        if (targetType.isAssignableFrom(BigInteger.class)) {
            return BigInteger.valueOf(l);
        }
        if (targetType.isAssignableFrom(Byte.class) || targetType.isAssignableFrom(Byte.TYPE)) {
            return new Byte(l.byteValue());
        }
        if (targetType.isAssignableFrom(Long.class) || targetType.isAssignableFrom(Long.TYPE)) {
            return src;
        }
        if (targetType.isAssignableFrom(Short.class) || targetType.isAssignableFrom(Short.TYPE)) {
            return new Short(l.shortValue());
        }
        return super.convert(src, targetType);
    }
}

