/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.type.baseimpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openarchitectureware.type.Operation;
import org.openarchitectureware.type.Type;
import org.openarchitectureware.type.baseimpl.FeatureImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OperationImpl
extends FeatureImpl
implements Operation {
    private List<Type> paramTypes;
    private Type owner;
    private int hashCode = 0;

    public OperationImpl(Type owner, String name, Type returnType, Type ... paramTypes) {
        super(name, returnType);
        this.paramTypes = paramTypes == null ? new ArrayList() : Arrays.asList(paramTypes);
        this.owner = owner;
    }

    @Override
    public final Object evaluate(Object target, Object[] params) {
        try {
            return this.evaluateInternal(target, params);
        }
        catch (NullPointerException e) {
            if (target == null) {
                return null;
            }
            throw e;
        }
    }

    protected abstract Object evaluateInternal(Object var1, Object[] var2);

    @Override
    public Type getOwner() {
        return this.owner;
    }

    @Override
    public List<Type> getParameterTypes() {
        return this.paramTypes;
    }

    @Override
    public Type getReturnType(Type targetType, Type[] paramTpes) {
        return this.getReturnType();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Operation) {
            boolean equals;
            Operation op = (Operation)obj;
            boolean bl = equals = this.getOwner().equals(op.getOwner()) && this.getName().equals(op.getName()) && this.getParameterTypes().size() == op.getParameterTypes().size();
            if (equals) {
                List<Type> typesA = this.getParameterTypes();
                List<Type> typesB = op.getParameterTypes();
                int i = 0;
                while (i < typesA.size() && equals) {
                    Type a = typesA.get(i);
                    Type b = typesB.get(i);
                    equals = equals && a.equals(b);
                    ++i;
                }
            }
            return equals;
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 17;
            this.hashCode = this.hashCode * 37 + this.owner.hashCode();
            this.hashCode = this.hashCode * 37 + this.getName().hashCode();
            int i = 0;
            while (i < this.paramTypes.size()) {
                this.hashCode = this.hashCode * 37 + this.paramTypes.get(i).hashCode();
                ++i;
            }
        }
        return this.hashCode;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        if (this.getReturnType() != null) {
            buff.append(this.getReturnType().toString());
        } else {
            buff.append("void");
        }
        buff.append(" ").append(this.getOwner().toString());
        buff.append(".").append(this.getName()).append("(");
        int i = 0;
        int x = this.getParameterTypes().size();
        while (i < x) {
            Type paramType = this.getParameterTypes().get(i);
            buff.append(paramType.toString());
            if (i + 1 < x) {
                buff.append(",");
            }
            ++i;
        }
        buff.append(")");
        return buff.toString();
    }

    @Override
    public String getDocumentation() {
        return "";
    }
}

