/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.expression.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.openarchitectureware.expression.AnalysationIssue;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.ast.Expression;
import org.openarchitectureware.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListLiteral
extends Expression {
    private Expression[] elements;

    public ListLiteral(Expression[] contents) {
        this.elements = contents;
    }

    public Expression[] getElements() {
        return this.elements;
    }

    public List<Expression> getElementsAsList() {
        return Arrays.asList(this.elements);
    }

    @Override
    public Object evaluateInternal(ExecutionContext ctx) {
        ArrayList<Object> col = new ArrayList<Object>();
        Expression[] params = this.getElements();
        int i = 0;
        while (i < params.length) {
            col.add(params[i].evaluate(ctx));
            ++i;
        }
        return col;
    }

    @Override
    public Type analyzeInternal(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type t = null;
        int i = 0;
        while (i < this.elements.length) {
            Expression element = this.elements[i];
            Type exprType = element.analyze(ctx, issues);
            if (exprType == null) {
                return null;
            }
            if (t == null || exprType.isAssignableFrom(t)) {
                t = exprType;
            }
            ++i;
        }
        return ctx.getListType(t);
    }

    @Override
    protected String toStringInternal() {
        return "{" + this.expressionsToString() + "}";
    }

    private String expressionsToString() {
        String r = "";
        int i = 0;
        while (i < this.elements.length) {
            r = String.valueOf(r) + this.elements[i].toString();
            if (i + 1 < this.elements.length) {
                r = String.valueOf(r) + ",";
            }
            ++i;
        }
        return r;
    }
}

